/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.account.fdckf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tcvat.business.service.outputtax.fdckf.EstateSalesConfirmLedgerService;

public class EstateSalesConfirmLedgerOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("stage");
        e.getFieldKeys().add("skssqz");
        e.getFieldKeys().add("skssqq");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.room");
        e.getFieldKeys().add("entryentity.dqqrxse");
        e.getFieldKeys().add("entryentity.dqkpxse");
        e.getFieldKeys().add("entryentity.dqwkpxse");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                block8: {
                    block7: {
                        if (!"delete".equals(this.getOperateKey())) break block7;
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            String orgid;
                            Date skssqz;
                            Date skssqq;
                            boolean isDeclared;
                            DynamicObject org = (DynamicObject)dataEntity.getValue("org");
                            if (org == null || !(isDeclared = EstateSalesConfirmLedgerService.isDeclared(skssqq = (Date)dataEntity.getValue("skssqq"), skssqz = (Date)dataEntity.getValue("skssqz"), orgid = org.getString("id")))) continue;
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u671f\u6570\u636e\u5df2\u7533\u62a5\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"EstateSalesConfirmLedgerOpPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                        }
                        break block8;
                    }
                    if (!"save".equals(this.getOperateKey())) break block8;
                    TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIds();
                    HashSet set1 = listTaxResult.getData() != null ? new HashSet((Collection)listTaxResult.getData()) : new HashSet(16);
                    ArrayList<Long> projectids = new ArrayList<Long>(16);
                    ArrayList<Long> stageids = new ArrayList<Long>(16);
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        Long project = (Long)dataEntity.getDataEntity().get("project.id");
                        Long stage = (Long)dataEntity.getDataEntity().get("stage.id");
                        projectids.add(project);
                        stageids.add(stage);
                    }
                    DynamicObjectCollection dynamicObjectCollection = EstateSalesConfirmLedgerService.queryProjectByIds(projectids);
                    Map<Long, Long> proToOrgMap = dynamicObjectCollection.stream().collect(Collectors.toMap(a -> a.getLong("id"), b -> b.getLong("taxorg"), (m, n) -> m));
                    DynamicObjectCollection queryStageByIds = EstateSalesConfirmLedgerService.queryStageByIds(stageids);
                    Map<Long, Long> stageToProMap = queryStageByIds.stream().collect(Collectors.toMap(a -> a.getLong("id"), b -> b.getLong("taxproject"), (m, n) -> m));
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        Long id = dataEntity.getDataEntity().getLong("id");
                        Long org = (Long)dataEntity.getDataEntity().get("org.id");
                        Long project = (Long)dataEntity.getDataEntity().get("project.id");
                        Long stage = (Long)dataEntity.getDataEntity().get("stage.id");
                        String billno = dataEntity.getDataEntity().getString("billno");
                        Date skssqq = dataEntity.getDataEntity().getDate("skssqq");
                        Date skssqz = dataEntity.getDataEntity().getDate("skssqz");
                        if (org == null || project == null || stage == null) continue;
                        if (org != null && !set1.contains(org)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7eb3\u7a0e\u4e3b\u4f53\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EstateSalesConfirmLedgerOpPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                            continue;
                        }
                        if (org != null && !org.equals(proToOrgMap.get(project))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7a0e\u52a1\u9879\u76ee\u4e0d\u5c5e\u4e8e\u8be5\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EstateSalesConfirmLedgerOpPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                            continue;
                        }
                        if (project != null && !project.equals(stageToProMap.get(stage))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5de5\u7a0b\u9879\u76ee\u5206\u671f\u4e0d\u5c5e\u4e8e\u8be5\u7a0e\u52a1\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EstateSalesConfirmLedgerOpPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                            continue;
                        }
                        Map<String, Object> validSkssq = EstateSalesConfirmLedgerService.validSkssq(skssqq, skssqz, org);
                        if (Boolean.FALSE.toString().equals(validSkssq.get("success"))) {
                            this.addFatalErrorMessage(dataEntity, (String)validSkssq.get("msg"));
                            continue;
                        }
                        boolean isDeclared = EstateSalesConfirmLedgerService.isDeclared(skssqq, skssqz, org.toString());
                        if (!isDeclared) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u671f\u6570\u636e\u5df2\u7533\u62a5\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"EstateSalesConfirmLedgerOpPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            ArrayList<Long> orgs = new ArrayList<Long>(16);
            ArrayList<Long> projects = new ArrayList<Long>(16);
            ArrayList<Long> stages = new ArrayList<Long>(16);
            for (DynamicObject dataEntity : dataEntities) {
                orgs.add(dataEntity.getLong("org.id"));
                projects.add(dataEntity.getLong("project.id"));
                stages.add(dataEntity.getLong("stage.id"));
            }
            List<DynamicObject> queryRooms = EstateSalesConfirmLedgerService.queryRooms(orgs, projects, stages);
            Map<String, List<DynamicObject>> roomMap = queryRooms.stream().collect(Collectors.groupingBy(a -> a.getLong("taxorg") + "_" + a.getLong("taxproject") + "_" + a.getLong("stage")));
            for (DynamicObject dataEntity : dataEntities) {
                long org = dataEntity.getLong("org.id");
                long project = dataEntity.getLong("project.id");
                long stage = dataEntity.getLong("stage.id");
                String key = org + "_" + project + "_" + stage;
                List roomMapOrDefault = roomMap.getOrDefault(key, new ArrayList());
                Map<Long, DynamicObject> roomMapping = roomMapOrDefault.stream().collect(Collectors.toMap(a -> a.getLong("id"), b -> b, (m, n) -> m));
                DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
                BigDecimal dqkpxsehj = BigDecimal.ZERO;
                BigDecimal dqwkpxsehj = BigDecimal.ZERO;
                BigDecimal dqqrxsehj = BigDecimal.ZERO;
                for (DynamicObject dynamicObject : entryentity) {
                    long roomid = dynamicObject.getLong("room.id");
                    BigDecimal dsjrksmj = roomMapping.containsKey(roomid) ? roomMapping.get(roomid).get("area") : BigDecimal.ZERO;
                    dynamicObject.set("dsjrksmj", (Object)dsjrksmj);
                    BigDecimal dqqrxse = dynamicObject.getBigDecimal("dqqrxse");
                    BigDecimal dqkpxse = dynamicObject.getBigDecimal("dqkpxse");
                    BigDecimal dqwkpxse = dynamicObject.getBigDecimal("dqwkpxse");
                    dqkpxsehj = dqkpxsehj.add(dqkpxse);
                    dqwkpxsehj = dqwkpxsehj.add(dqwkpxse);
                    dqqrxsehj = dqqrxsehj.add(dqqrxse);
                }
                dataEntity.set("dqkpxsehj", (Object)dqkpxsehj);
                dataEntity.set("dqwkpxsehj", (Object)dqwkpxsehj);
                dataEntity.set("dqqrxsehj", (Object)dqqrxsehj);
            }
        }
    }
}

