/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.opplugin.DeclareQueryListOp;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeclareDueryListOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(DeclareQueryListOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            PrepayStatusService prepayStatusService = new PrepayStatusService();
            Set ids = Arrays.stream(dataEntities).map(one -> one.getPkValue()).collect(Collectors.toSet());
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"org,skssqq,skssqz,prepayproject,declareserialno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            ArrayList<String> errors = new ArrayList<String>(16);
            for (DynamicObject entity : dataEntities) {
                try {
                    Object pkValue = entity.getPkValue();
                    DynamicObject declare = Arrays.stream(objects).filter(one -> one.getPkValue().equals(pkValue)).findFirst().get();
                    Long orgId = declare.getDynamicObject("org").getLong("id");
                    Date skssqq = declare.getDate("skssqq");
                    Date skssqz = declare.getDate("skssqz");
                    String projectid = declare.getDynamicObject("prepayproject").getString("id");
                    String declareserialno = declare.getString("declareserialno");
                    prepayStatusService.delete(orgId.toString(), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz), projectid, declareserialno);
                    TemplateUtils.deleteReport((Boolean)Boolean.TRUE, (String)declareserialno, (Long)orgId, (String)"zzsyjskb", (Date)skssqq, (Date)skssqz);
                    successObjs.add(entity);
                    TemplateUtils.updateApllyDeclareserialno((String)declareserialno);
                }
                catch (Exception e) {
                    errors.add("DeclareDueryListOp:" + e.toString());
                    String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u7533\u62a5\u6570\u636e\u5931\u8d25\u3002", (String)"DeclareDueryListOp_0", (String)"taxc-tcvat", (Object[])new Object[0]), entity.getString("billno"));
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_declare_error", "", msg, ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                }
            }
            logger.error(((Object)errors).toString());
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        }
    }
}

