/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.jzjt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tcvat.business.service.jzjt.JzjtService;
import org.apache.commons.collections4.CollectionUtils;

public class JzjtTssqbBljdbsOp
extends AbstractOperationServicePlugIn {
    private JzjtService jzjtService = new JzjtService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("skssqq");
        e.getFieldKeys().add("skssqz");
        e.getFieldKeys().add("entryentity.bljd");
        e.getFieldKeys().add("templatetype");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                Map result = JzjtTssqbBljdbsOp.this.sendTaxRefundInfo(this.dataEntities, operateKey);
                Map<Object, Object> resultMap = JzjtTssqbBljdbsOp.this.jzjtService.getResultMessage(result, operateKey);
                if (resultMap.size() > 0) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        if (null == resultMap.get(dataEntity.getBillNo())) continue;
                        this.addFatalErrorMessage(dataEntity, (String)resultMap.get(dataEntity.getBillNo()));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] tssqb;
        String operationKey = args.getOperationKey();
        Object[] ids = Stream.of(args.getDataEntities()).map(o -> o.getLong("id")).toArray();
        for (DynamicObject object : tssqb = this.jzjtService.loadTssqb(ids)) {
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isNotEmpty((Collection)entryentity)) continue;
            if ("unapply".equals(operationKey)) {
                ((DynamicObject)entryentity.get(0)).set("bljd", (Object)"wsq");
                continue;
            }
            if ("apply".equals(operationKey)) {
                ((DynamicObject)entryentity.get(0)).set("bljd", (Object)"ysq");
                continue;
            }
            if ("done".equals(operationKey)) {
                ((DynamicObject)entryentity.get(0)).set("bljd", (Object)"ybj");
                continue;
            }
            if (!"unaudit".equals(operationKey)) continue;
            ((DynamicObject)entryentity.get(0)).set("bljd", (Object)"wsq");
        }
        if (tssqb.length > 0) {
            SaveServiceHelper.save((DynamicObject[])tssqb);
        }
    }

    private Map<String, Object> sendTaxRefundInfo(ExtendedDataEntity[] dataEntities, String operationKey) {
        if ("done".equals(operationKey)) {
            ArrayList<Map<String, Object>> jzjtTssqbInfoList = new ArrayList<Map<String, Object>>();
            Map<String, BigDecimal> orgSkssqqSkssqzMap = this.jzjtService.getTsjsDraftOrgSkssqqSkssqzMap(dataEntities);
            Map<String, List<DynamicObject>> tssqbDetailMap = this.jzjtService.getOriginalTaxStatusMap(dataEntities);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                List<DynamicObject> originalTaxStatusList = tssqbDetailMap.get(dataEntity.getDataEntity().getString("id"));
                if (null == originalTaxStatusList) continue;
                for (DynamicObject taxStautsObj : originalTaxStatusList) {
                    if (this.jzjtService.checkData(taxStautsObj)) continue;
                    String taxPeriod = taxStautsObj.getString("value");
                    String taxPeriodStr = taxPeriod.replaceAll("[^\\\\x00-\\\\xf+]", "-");
                    String startDate = taxPeriodStr.substring(0, 10);
                    String endDate = taxPeriodStr.substring(12, 22);
                    if (null == orgSkssqqSkssqzMap.get(dataEntity.getDataEntity().getDynamicObject("org").getString("id") + startDate + endDate)) continue;
                    jzjtTssqbInfoList.add(this.jzjtService.buildTaxRefundInfo(orgSkssqqSkssqzMap, dataEntity.getDataEntity(), startDate, endDate));
                }
            }
            return (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"addTaxRefundInfo", (Object[])new Object[]{jzjtTssqbInfoList});
        }
        if ("unapply".equals(operationKey) || "apply".equals(operationKey) || "unaudit".equals(operationKey)) {
            List billnoList = Arrays.stream(dataEntities).filter(d -> "ybj".equals(((DynamicObject)d.getDataEntity().getDynamicObjectCollection("entryentity").get(0)).getString("bljd"))).map(d -> d.getDataEntity().getString("billno")).collect(Collectors.toList());
            if (billnoList.size() == 0) {
                return new HashMap<String, Object>();
            }
            return (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"deleteTaxRefundInfo", (Object[])new Object[]{billnoList});
        }
        return new HashMap<String, Object>();
    }
}

