/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.prepay;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.prepay.application.PrepayApplicationService;

public class PrepayApplicationDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("declarenumber");
        e.getFieldKeys().add("salesentry");
        e.getFieldKeys().add("deductentry");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String declarenumber = (String)dataEntity.getValue("declarenumber");
                    if (!StringUtil.isNotBlank((CharSequence)declarenumber)) continue;
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u9884\u7f34\u7533\u62a5\u8868\u201c%s\u201d,\u8bf7\u5148\u5220\u9664\u9884\u7f34\u7533\u62a5\u8868\u540e\u518d\u64cd\u4f5c", (String)"PrepayApplicationDeleteOp_0", (String)"taxc-tcvat", (Object[])new Object[0]), declarenumber));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            dataEntity = BusinessDataServiceHelper.loadSingle((Object)e.getDataEntities()[0].getLong("id"), (String)"tcvat_prepay_application");
            DynamicObjectCollection salesentry = dataEntity.getDynamicObjectCollection("salesentry");
            for (DynamicObject dynamicObject : salesentry) {
                PrepayApplicationService.rollbackStatus(dynamicObject);
            }
            DynamicObjectCollection deductentry = dataEntity.getDynamicObjectCollection("deductentry");
            for (DynamicObject dynamicObject : deductentry) {
                PrepayApplicationService.calculateRollbackValue(dynamicObject);
            }
        }
    }
}

