/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.prepay;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.tcvat.common.util.PrepayRuleUtils;

public class PrepaySharingPlanAssignOp
extends AbstractOperationServicePlugIn {
    private static String[] FIELDS_SETTING = new String[]{"bizname", "table", "amountfield", "datatype", "absolute", "datadirection", "filtercondition"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    ArrayList errorList = new ArrayList();
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObjectCollection planentity = entity.getDynamicObjectCollection("planentity");
                    for (DynamicObject plan : planentity) {
                        DynamicObjectCollection projectentity = plan.getDynamicObjectCollection("projectentity");
                        DynamicObjectCollection ruleentity = plan.getDynamicObjectCollection("ruleentity");
                        DynamicObject[] currentRuleList = BusinessDataServiceHelper.load((Object[])ruleentity.stream().map(rule -> rule.getLong("ruleid")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_rule_prepay"));
                        List<Long> projects = projectentity.stream().map(a -> a.getDynamicObject("prepayproject").getLong("id")).collect(Collectors.toList());
                        List<DynamicObject> sharingAndProjectRules = PrepayRuleUtils.getSharingRules(projects, plan.getLong("id"), false);
                        for (DynamicObject current : currentRuleList) {
                            for (DynamicObject saved : sharingAndProjectRules) {
                                PrepaySharingPlanAssignOp.this.compareRule(current, saved, errorList, "deduction", "");
                                PrepaySharingPlanAssignOp.this.compareRule(current, saved, errorList, "", "entity");
                            }
                        }
                        List<DynamicObject> privateRules = PrepayRuleUtils.getPrivateRules(projects, false);
                        HashSet<Long> set = new HashSet<Long>();
                        set.addAll(projects);
                        Map<Long, List<DynamicObject>> map = privateRules.stream().collect(Collectors.groupingBy(a -> a.getLong("prepayproject.id")));
                        for (Long project : set) {
                            if (!map.containsKey(project)) continue;
                            List<DynamicObject> privateRuleList = map.get(project);
                            for (DynamicObject current : currentRuleList) {
                                for (DynamicObject saved : privateRuleList) {
                                    PrepaySharingPlanAssignOp.this.compareRule(current, saved, errorList, "deduction", "");
                                    PrepaySharingPlanAssignOp.this.compareRule(current, saved, errorList, "", "entity");
                                }
                            }
                        }
                    }
                    if (errorList.isEmpty()) continue;
                    for (String msg : errorList) {
                        this.addWarningMessage(dataEntity, msg);
                    }
                }
            }
        });
    }

    private void compareRule(DynamicObject current, DynamicObject saved, List<String> msgList, String prefix, String suffix) {
        DynamicObjectCollection currentEntry = current.getDynamicObjectCollection(prefix + "entry" + suffix);
        DynamicObjectCollection savedEntry = saved.getDynamicObjectCollection(prefix + "entry" + suffix);
        for (DynamicObject currentRow : currentEntry) {
            for (DynamicObject savedRow : savedEntry) {
                boolean equals;
                if (current.get("id").equals(saved.get("id")) || !(equals = this.compareAccounting(currentRow, savedRow, FIELDS_SETTING, prefix))) continue;
                String errMsg = ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u7f16\u7801\u662f\u201c%1$s\u201d\u7684\u9884\u7f34\u9879\u76ee\u53d6\u6570\u89c4\u5219\uff0c\u548c\u88ab\u5171\u4eab\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d \u7f16\u7801\u662f\u201c%3$s\u201d\u7684\u89c4\u5219\u660e\u7ec6\u5185\u5bb9\u91cd\u590d\uff0c\u4e3a\u907f\u514d\u91cd\u590d\u53d6\u6570\uff0c\u8bf7\u8c03\u6574\u5171\u4eab\u65b9\u6848\uff0c\u6216\u4fee\u6539\u5bf9\u5e94\u7684\u89c4\u5219\u914d\u7f6e", (String)"PrepaySharingPlanAssignOp_0", (String)"taxc-tcvat", (Object[])new Object[0]);
                String msg = String.format(errMsg, current.getString("number"), saved.getDynamicObject("org").getString("name"), saved.getString("number"));
                msgList.add(msg);
            }
        }
    }

    private boolean compareAccounting(DynamicObject a1, DynamicObject a2, String[] filtersName, String prefix) {
        boolean equals = true;
        for (String field : filtersName) {
            if (null == a1.get(prefix + field) || a1.get(prefix + field).equals(a2.get(prefix + field))) continue;
            equals = false;
            break;
        }
        return equals;
    }
}

