/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.prepay.project;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class ProjectSaveValidator
extends AbstractValidator {
    private String entityName;

    public ProjectSaveValidator(String entityName) {
        this.entityName = entityName;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject projectInfo = dataEntity.getDataEntity();
            if (this.repeat(projectInfo)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u7f16\u7801\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"ProjectSaveValidator_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                continue;
            }
            if (projectInfo.getBoolean("cswhjss") && StringUtil.isBlank((CharSequence)projectInfo.getString("zone"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9644\u52a0\u7a0e\u8d39\u9879\u76ee\u6240\u5728\u5730\u201d\u3002", (String)"ProjectSaveValidator_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                continue;
            }
            DynamicObject taxorg = projectInfo.getDynamicObject("taxorg");
            if (taxorg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7ec4\u7ec7\u53d6\u6570\u5173\u7cfb", (String)"ProjectSaveValidator_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                continue;
            }
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)taxorg.getLong("id")).getData()).booleanValue()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ProjectSaveValidator_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
            this.checkProjectDate(dataEntity);
        }
    }

    private void checkProjectDate(ExtendedDataEntity dataEntity) {
        Object contractentity = dataEntity.getValue("contractentity");
        if (Objects.isNull(contractentity)) {
            return;
        }
        for (DynamicObject dynamicObject : (DynamicObjectCollection)contractentity) {
            Date planstart = dynamicObject.getDate("planstart");
            Date planend = dynamicObject.getDate("planend");
            if (Objects.isNull(planstart) || Objects.isNull(planend)) {
                return;
            }
            if (!planstart.after(planend)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5408\u540c\u6709\u6548\u671f\u59cb\u201d\u9700\u65e9\u4e8e\u201c\u5408\u540c\u6709\u6548\u671f\u6b62\u201d\u3002", (String)"ProjectSaveValidator_6", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private boolean repeat(DynamicObject projectInfo) {
        QFilter numberFilter = new QFilter("number", "=", (Object)projectInfo.getString("number"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.entityName, (String)"id", (QFilter[])new QFilter[]{numberFilter});
        return dynamicObject != null && projectInfo.getLong("id") != dynamicObject.getLong("id");
    }
}

