/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class IncomeRuleDisableOp
extends AbstractOperationServicePlugIn {
    private static final String WKPSR_RULE_ENTITY = "tcvat_rule_wkpsr";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("disable".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            List incomeRuleIds = Stream.of(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection wkpsrRules = QueryServiceHelper.query((String)WKPSR_RULE_ENTITY, (String)"id,rulename", (QFilter[])new QFilter[]{new QFilter("rulename", "in", incomeRuleIds), new QFilter("enable", "=", (Object)"1")});
            if (CollectionUtils.isEmpty((Collection)wkpsrRules)) {
                return;
            }
            Map<Long, Long> wkpsrRuleIdMap = wkpsrRules.stream().collect(Collectors.toMap(o -> o.getLong("rulename"), o -> o.getLong("id")));
            ArrayList<Long> updateList = new ArrayList<Long>();
            for (DynamicObject dataEntity2 : dataEntities) {
                long ruleId = dataEntity2.getLong("id");
                Long wkpsrRuleId = wkpsrRuleIdMap.get(ruleId);
                if (wkpsrRuleId == null) continue;
                updateList.add(wkpsrRuleId);
            }
            OperationServiceHelper.executeOperate((String)operationKey, (String)WKPSR_RULE_ENTITY, (Object[])updateList.toArray(new Long[0]), (OperateOption)OperateOption.create());
        }
    }
}

