/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.common.util.ValidateUtils;
import org.apache.commons.compress.utils.Lists;

public class RuleInvoiceSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject rule = dataEntity.getDataEntity();
                    String name = rule.getDataEntityType().getName();
                    if (!rule.getBoolean("enable")) continue;
                    List<Object> rules = Lists.newArrayList();
                    RuleInvoiceSaveOp.this.queryAllRules(rule, rules, name);
                    if (CollectionUtils.isNotEmpty((Collection)rules) && !Objects.isNull(rule.get("id"))) {
                        rules = rules.stream().filter(one -> !one.get("id").equals(rule.get("id"))).collect(Collectors.toList());
                    }
                    ArrayList msg = Lists.newArrayList();
                    ValidateUtils.judgeRepetation(rule, rules, msg, "filtercondition");
                    msg.forEach(one -> this.addFatalErrorMessage(dataEntity, (String)one.get("msg")));
                }
            }
        });
    }

    private void queryAllRules(DynamicObject rule, List<DynamicObject> rules, String name) {
        HashMap result = new HashMap();
        Long orgid = rule.getDynamicObject("org").getLong("id");
        HashMap rulePublicIdMap = new HashMap();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("org", "=", (Object)orgid));
        if (name.equals("tcvat_rule_outputproject")) {
            Long jzjtcpid = Objects.isNull(rule.getDynamicObject("jzjtcp")) ? 0L : rule.getDynamicObject("jzjtcp").getLong("id");
            filterList.add(new QFilter("jzjtcp", "=", (Object)jzjtcpid));
            RuleUtils.queryRulesByType((RuleTypeEnum)RuleTypeEnum.XXXM, (Boolean)Boolean.FALSE, rulePublicIdMap, filterList, result, (String)"");
            rules.addAll((Collection)result.get(RuleTypeEnum.XXXM));
        } else if (name.equals("tcvat_rule_incomeproject")) {
            RuleUtils.queryRulesByType((RuleTypeEnum)RuleTypeEnum.JXXM, (Boolean)Boolean.FALSE, rulePublicIdMap, filterList, result, (String)"");
            rules.addAll((Collection)result.get(RuleTypeEnum.JXXM));
        }
    }
}

