/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.common.enums.RuleTypeStrategyEnum;
import kd.taxc.tcvat.common.util.ValidateUtils;
import org.apache.commons.compress.utils.Lists;

public class RuleValidatorOp
extends AbstractOperationServicePlugIn {
    private static final List<String> ruleList = Arrays.asList("tcvat_rule_income", "tcvat_ncp_rule", "tcvat_ncp_product_rule", "tcvat_rule_perpre", "tcvat_rule_refund", "tcvat_rule_mdts");
    private static final List<String> inOutRuleList = Arrays.asList("tcvat_rule_incomeproject", "tcvat_rule_outputproject");
    private static final List<String> allRuleList = Arrays.asList("tcvat_sbx_rule_config", "tcvat_incomep_rule_config", "tcvat_prepay_rule_config", "tcvat_tz_rule_config", "tcvat_ncp_rule_config", "tcvat_ldts_rule_config");

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    List<Object> rules;
                    DynamicObject rule = dataEntity.getDataEntity();
                    String name = rule.getDataEntityType().getName();
                    if (allRuleList.contains(name)) {
                        String string = rule.getDynamicObject("group").getString("id");
                        String formId = RuleTypeStrategyEnum.getStrategyByGroupId(string).getFormId();
                        if (StringUtil.isBlank((CharSequence)formId)) continue;
                        name = formId;
                    }
                    rule = BusinessDataServiceHelper.loadSingle((String)name, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rule.getLong("id"))});
                    if (ruleList.contains(rule.getDataEntityType().getName())) {
                        List<BaseResult> baseResults = ValidateUtils.validateByDirector(Collections.singletonList(rule));
                        baseResults.stream().flatMap(e -> ((List)e.getData()).stream()).forEach(e -> this.addFatalErrorMessage(dataEntity, (String)e));
                        continue;
                    }
                    if (inOutRuleList.contains(name)) {
                        rules = Lists.newArrayList();
                        RuleValidatorOp.this.queryAllRules(rule, rules, name);
                        if (CollectionUtils.isNotEmpty(rules) && !Objects.isNull(rule.get("id"))) {
                            DynamicObject rule1 = rule;
                            rules = rules.stream().filter(one -> !one.get("id").equals(rule1.get("id"))).collect(Collectors.toList());
                        }
                        ArrayList msg = Lists.newArrayList();
                        ValidateUtils.judgeRepetation(rule, rules, msg, "filtercondition");
                        msg.forEach(one -> this.addFatalErrorMessage(dataEntity, (String)one.get("msg")));
                        continue;
                    }
                    if ("tcvat_rule_prepay".equals(name)) {
                        rules = new ArrayList<DynamicObject>();
                        RuleValidatorOp.this.queryAllRules(rule, rules, name);
                        this.validatePrepay(dataEntity, rules, rule);
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rule.getDynamicObjectCollection("entryentity"))) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u9500\u552e\u989d\u53d6\u6570\u89c4\u5219\u3002", (String)"TaxPrePayRuleSaveOp_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                        continue;
                    }
                    try {
                        List<Map<String, Object>> errorList = ValidateUtils.validate(Collections.singletonList(rule));
                        for (Map<String, Object> map : errorList) {
                            this.addFatalErrorMessage(dataEntity, (String)map.get("msg"));
                        }
                    }
                    catch (Exception e2) {
                        throw new KDBizException("rule data error!");
                    }
                }
            }

            private void validatePrepay(ExtendedDataEntity dataEntity, List<DynamicObject> rules, DynamicObject rule) {
                ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>(8);
                rules.stream().filter(r -> !r.getString("number").equals(rule.getString("number"))).filter(r -> r.getDynamicObject("prepayproject").getString("id").equals(rule.getDynamicObject("prepayproject").getString("id"))).findAny().ifPresent(r -> {
                    HashMap<String, String> errorMap = new HashMap<String, String>(1);
                    errorMap.put("msg", String.format(ResManager.loadKDString((String)"%s\u5df2\u914d\u7f6e\u53d6\u6570\u89c4\u5219\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e", (String)"TaxPrePayRuleSaveOp_0", (String)"taxc-tcvat", (Object[])new Object[0]), r.getDynamicObject("prepayproject").getString("name")));
                    errorList.add(errorMap);
                });
                errorList.addAll(ValidateUtils.validate(rule));
                for (Map map : errorList) {
                    this.addFatalErrorMessage(dataEntity, (String)map.get("msg"));
                }
            }
        });
    }

    private void queryAllRules(DynamicObject rule, List<DynamicObject> rules, String name) {
        HashMap result = new HashMap();
        Long orgid = rule.getDynamicObject("org").getLong("id");
        HashMap rulePublicIdMap = new HashMap();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("org", "=", (Object)orgid));
        if (name.equals("tcvat_rule_outputproject")) {
            Long jzjtcpid = Objects.isNull(rule.getDynamicObject("jzjtcp")) ? 0L : rule.getDynamicObject("jzjtcp").getLong("id");
            filterList.add(new QFilter("jzjtcp", "=", (Object)jzjtcpid));
            RuleUtils.queryRulesByType((RuleTypeEnum)RuleTypeEnum.XXXM, (Boolean)Boolean.FALSE, rulePublicIdMap, filterList, result, (String)"");
            rules.addAll((Collection)result.get(RuleTypeEnum.XXXM));
        } else if (name.equals("tcvat_rule_incomeproject")) {
            RuleUtils.queryRulesByType((RuleTypeEnum)RuleTypeEnum.JXXM, (Boolean)Boolean.FALSE, rulePublicIdMap, filterList, result, (String)"");
            rules.addAll((Collection)result.get(RuleTypeEnum.JXXM));
        } else if (name.equals("tcvat_rule_prepay")) {
            RuleUtils.queryRulesByType((RuleTypeEnum)RuleTypeEnum.PREPAY, (Boolean)Boolean.TRUE, rulePublicIdMap, filterList, result, (String)"");
            rules.addAll((Collection)result.get(RuleTypeEnum.PREPAY));
        }
    }
}

