/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.tcvat.common.util.ValidateUtils;

public class TaxRuleSaveOp
extends AbstractOperationServicePlugIn {
    private static final List<String> ruleList = Arrays.asList("tcvat_rule_income", "tcvat_ncp_rule", "tcvat_ncp_product_rule", "tcvat_rule_perpre", "tcvat_rule_refund", "tcvat_rule_mdts", "tcvat_rule_jzjt_jxse", "tcvat_rule_mdts");

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject rule = dataEntity.getDataEntity();
                    if (!rule.getBoolean("enable")) {
                        return;
                    }
                    if (ruleList.contains(rule.getDataEntityType().getName())) {
                        List<BaseResult> baseResults = ValidateUtils.validateByDirector(Collections.singletonList(rule));
                        baseResults.stream().flatMap(e -> ((List)e.getData()).stream()).forEach(e -> this.addFatalErrorMessage(dataEntity, (String)e));
                        continue;
                    }
                    List<Map<String, Object>> errorList = ValidateUtils.validate(Collections.singletonList(rule));
                    for (Map<String, Object> map : errorList) {
                        this.addFatalErrorMessage(dataEntity, (String)map.get("msg"));
                    }
                }
            }
        });
    }
}

