/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.taxrefund;

import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQEvent;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQSender;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQType;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.mq.TaxRefundStatusHandler;
import kd.taxc.tcvat.business.service.taxrefund.StateInitDataService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundAccountService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundAssistService;

public class TaxRefundAccountSaveOp
extends AbstractOperationServicePlugIn {
    private TaxRefundAccountService taxRefundAccountService = new TaxRefundAccountService();

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if (operationKey.equals("save")) {
            DynamicObject taxRefundAccount = dataEntities[0];
            DynamicObject org = taxRefundAccount.getDynamicObject("org");
            Long orgId = org.getLong("id");
            Date skssqq = taxRefundAccount.getDate("skssqq");
            Date skssqz = taxRefundAccount.getDate("skssqz");
            this.taxRefundAccountService.setEnterPrise(taxRefundAccount, orgId);
            String taxlimit = TaxRefundAssistService.getLimit(DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
            this.taxRefundAccountService.setBqksqthldtse(taxRefundAccount, taxlimit, orgId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taxRefundAccount});
            TaxRefundMQSender.sendMQ(Collections.singletonList(taxRefundAccount), (String)TaxRefundMQType.TAX_REFUND.name(), (String)TaxRefundMQEvent.NEW.name());
            DynamicObject declareDyo = StateInitDataService.getDeclareReport(orgId, skssqq, skssqz);
            if (null == declareDyo) {
                return;
            }
            TaxRefundStatusHandler taxRefundStatusHandler = new TaxRefundStatusHandler();
            taxRefundStatusHandler.auditHandler(declareDyo);
        }
    }
}

