/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.taxrefund;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tpo.refund.TaxRefundServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundApplyService;
import org.apache.commons.collections.CollectionUtils;

public class TaxRefundProcessOp
extends AbstractOperationServicePlugIn {
    private TaxRefundApplyService taxRefundApplyService = new TaxRefundApplyService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity.bljd");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("skssqq");
        e.getFieldKeys().add("skssqz");
        e.getFieldKeys().add("templatetype");
        e.getFieldKeys().add("entryentity.bqsqthdzlldse");
        e.getFieldKeys().add("entryentity.bqsqthdclldse");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                TaxResult refunds;
                ExtendedDataEntity dataEntitie;
                String operateKey = this.getOperateKey();
                if (TaxRefundProcessOp.this.isValided(operateKey, dataEntitie = this.dataEntities[0], (TaxResult<List<DynamicObject>>)(refunds = TaxRefundServiceHelper.getTaxRefundByBillId((List)Lists.newArrayList((Object[])new String[]{dataEntitie.getBillNo()}), (String)"tcvat_taxrefund", (Long)1L)))) {
                    this.addFatalErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u7533\u62a5\u8868\u7f16\u53f7\uff1a%s \u7684\u4e0b\u6e38\u9000\u7a0e\u4fe1\u606f\u4e3a\u672a\u9000\u7a0e\u6216\u672a\u751f\u6210\u51ed\u8bc1\u65f6\u624d\u80fd\u64cd\u4f5c\u3002", (String)"TaxRefundProcessOp_1", (String)"taxc-tcvat", (Object[])new Object[0]), dataEntitie.getBillNo()));
                } else {
                    String bljd = ((DynamicObject)dataEntitie.getDataEntity().getDynamicObjectCollection("entryentity").get(0)).getString("bljd");
                    if ("zyts".equals(bljd) || "yts".equals(bljd)) {
                        this.addMessage(dataEntitie, ResManager.loadKDString((String)"\u529e\u7406\u72b6\u6001\u53d8\u52a8\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u9700\u8981\u8c03\u6574\u7533\u62a5\u8868\u6570\u636e\u3002", (String)"TaxRefundProcessOp_0", (String)"taxc-tcvat", (Object[])new Object[0]), ErrorLevel.Warning);
                    }
                }
            }
        });
    }

    private boolean isValided(String operateKey, ExtendedDataEntity dataEntitie, TaxResult<List<DynamicObject>> refunds) {
        if (refunds.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)refunds.getData()))) {
            DynamicObject data = (DynamicObject)((List)refunds.getData()).get(0);
            if (this.isNeedJudge(operateKey, dataEntitie.getDataEntity()) && ("1".equals(data.getString("taxrefundstatus")) || "1".equals(data.getString("isvoucher")))) {
                return true;
            }
        }
        return false;
    }

    private boolean isNeedJudge(String operateKey, DynamicObject dataEntitie) {
        String bljd = ((DynamicObject)dataEntitie.getDynamicObjectCollection("entryentity").get(0)).getString("bljd");
        if ("wsq".equals(operateKey) && !"wsq".equals(bljd)) {
            return true;
        }
        return ("zyts".equals(operateKey) || "ysq".equals(operateKey)) && "yts".equals(bljd);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List pkids = Arrays.stream(dataEntities).map(d -> d.getLong("id")).collect(Collectors.toList());
        String operationKey = e.getOperationKey();
        QFilter qFilter = new QFilter("id", "in", pkids);
        DynamicObject[] applyDyos = BusinessDataServiceHelper.load((String)"tcvat_tax_refund_apply", (String)"billno,billstatus,auditor,templatetype,templateid,datatype,nsrsbh,nsrmc,taxtype,org,taxsystem,skssqq,skssqz,remarks,modifier,auditdate,createtime,modifytime,creator,type,generatebusinessdoc,entryentity.bqsqthdclldse,entryentity.bqsqthdzlldse,entryentity.sqthxm,entryentity.bljd,entryentity.zytssj,id,entryentity.id,entryentity.seq", (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(applyDyos.length);
        ArrayList<DynamicObject> declareReportList = new ArrayList<DynamicObject>(applyDyos.length);
        ArrayList<DynamicObject> taxRefundAccountList = new ArrayList<DynamicObject>(applyDyos.length);
        List billNos = Arrays.asList(dataEntities).stream().map(o -> o.getString("billno")).collect(Collectors.toList());
        TaxResult refunds = TaxRefundServiceHelper.getTaxRefundByBillId(billNos, (String)"tcvat_taxrefund", (Long)1L);
        this.taxRefundApplyService.sendTaxRefundInfo(operationKey, dataEntities, (TaxResult<List<DynamicObject>>)refunds);
        for (DynamicObject applyDyo : applyDyos) {
            DynamicObjectCollection entryentity = applyDyo.getDynamicObjectCollection("entryentity");
            DynamicObject entry = (DynamicObject)entryentity.get(0);
            entry.set("bljd", (Object)operationKey);
            if ("zyts".equals(operationKey)) {
                entry.set("zytssj", (Object)DateUtils.format((Date)new Date()));
            }
            if ("wsq".equals(operationKey) || "ysq".equals(operationKey)) {
                entry.set("zytssj", null);
            }
            updateList.add(applyDyo);
            Long org = applyDyo.getDynamicObject("org").getLong("id");
            Date skssqq = applyDyo.getDate("skssqq");
            Date skssqz = applyDyo.getDate("skssqz");
            this.taxRefundApplyService.updateDeclareReport(operationKey, declareReportList, org, skssqq, skssqz);
            this.taxRefundApplyService.updateTaxRefund(operationKey, taxRefundAccountList, org, skssqq, skssqz);
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])declareReportList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])taxRefundAccountList.toArray(new DynamicObject[0]));
    }
}

