/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.mservice.accrual;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AccrualListDto;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.mservice.api.AccrualListQueryService;

public class AccrualListQueryServiceImpl
implements AccrualListQueryService {
    private static Log LOGGER = LogFactory.getLog(AccrualListQueryServiceImpl.class);

    @Override
    public List<Map<String, Object>> query(List<Long> orgList, List<Long> baseTaxIds, Date accrualDate) {
        LicenseCheckResult licenseCheckResult = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            LOGGER.info("\u6ca1\u6709\u589e\u503c\u7a0e\u5e95\u7a3f\u8bb8\u53ef\u65e0\u9700\u7f16\u5236\u5e95\u7a3f");
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<AccrualListDto> taxableListDtos = new ArrayList<AccrualListDto>(orgList.size());
        Date month = DateUtils.getFirstDateOfMonth((Date)accrualDate);
        for (Long org : orgList) {
            List engineResponses = TaxDeclareHelper.doDraftVerify((Long)org, (Date)accrualDate, null, null, (Boolean)false, (Boolean)false, (String)"sjjt");
            for (EngineResponse engineResponse : engineResponses) {
                Map data;
                if (!engineResponse.getSuccess().booleanValue() || (data = (Map)engineResponse.getData()) == null || data.size() <= 0) continue;
                AccrualListDto taxableListDto = AccrualListDto.getInstanceFromMap((Map)data);
                taxableListDto.setCategory(AccrualListEnum.ZZS.getCategory());
                taxableListDto.setTaxcatetory(AccrualListEnum.ZZS.getBaseTaxId());
                taxableListDtos.add(taxableListDto);
            }
        }
        ArrayList results = taxableListDtos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AccrualListDto>(Comparator.comparing(a -> a.getOrg() + DateUtils.format((Date)a.getSkssqq()) + DateUtils.format((Date)a.getSkssqz()) + a.getTemplatetype()))), ArrayList::new));
        List<Long> doOrgs = results.stream().map(a -> a.getOrg()).collect(Collectors.toList());
        Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)month, (int)-3));
        Date endDate = DateUtils.getLastDateOfMonth((Date)month);
        this.fillDgInfo(startDate, endDate, doOrgs, results);
        return results.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
    }

    private void fillDgInfo(Date startDate, Date endDate, List<Long> doOrgs, ArrayList<AccrualListDto> results) {
        QFilter orgFilter = new QFilter("org", "in", doOrgs);
        QFilter dateFilter = new QFilter("skssqq", ">=", (Object)startDate).and("skssqz", "<=", (Object)endDate);
        QFilter typeFilter = new QFilter("templatetype", "in", (Object)TemplateTypeConstant.TCVAT_SJJT_TYPES);
        DynamicObjectCollection dgList = QueryServiceHelper.query((String)"tcvat_sjjt_draft_query", (String)"billstatus,billno,skssqq, skssqz, templatetype,org,id", (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
        Map<String, DynamicObject> dgMap = dgList.stream().collect(Collectors.toMap(a -> this.getUniqKey((DynamicObject)a), b -> b, (m, n) -> m));
        for (AccrualListDto result : results) {
            if (Objects.equals(result.getBillstatus(), TaxableListDto.DRAFTSTATUS_WXBZ)) continue;
            String key = result.getOrg().toString() + DateUtils.format((Date)result.getSkssqq()) + DateUtils.format((Date)result.getSkssqz());
            DynamicObject dynamicObject = dgMap.get(key);
            if (dynamicObject != null) {
                result.setBillstatus(StringUtil.isEmpty((CharSequence)dynamicObject.getString("billstatus")) ? "nodata" : dynamicObject.getString("billstatus"));
                result.setBillno(dynamicObject.getString("billno"));
                continue;
            }
            result.setBillstatus("nodata");
        }
    }

    private String getUniqKey(DynamicObject a) {
        return a.getString("org") + DateUtils.format((Date)a.getDate("skssqq")) + DateUtils.format((Date)a.getDate("skssqz"));
    }
}

