/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.mservice.declare;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.taxrange.TaxableListQueryService;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;

public class TaxableListQueryServiceImpl
implements TaxableListQueryService {
    private static Log LOGGER = LogFactory.getLog(TaxableListQueryServiceImpl.class);

    public List<Map<String, Object>> queryDraftTaxableList(List<Long> orgList, List<String> draftCategories, Date declareDate) {
        ArrayList<TaxableListDto> taxableListDtos = new ArrayList<TaxableListDto>(orgList.size());
        LicenseCheckResult licenseCheckResult = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            LOGGER.info("\u6ca1\u6709\u589e\u503c\u7a0e\u5e95\u7a3f\u8bb8\u53ef\u65e0\u9700\u7f16\u5236\u5e95\u7a3f");
            return new ArrayList<Map<String, Object>>(0);
        }
        Date month = DateUtils.getFirstDateOfMonth((Date)declareDate);
        for (Long org : orgList) {
            List engineResponses = TaxDeclareHelper.doDraftVerify((Long)org, (Date)declareDate, null, null, (Boolean)false, (Boolean)false, (String)"nssb");
            for (EngineResponse engineResponse : engineResponses) {
                Map data;
                if (!engineResponse.getSuccess().booleanValue() || (data = (Map)engineResponse.getData()) == null || data.size() <= 0) continue;
                TaxableListDto taxableListDto = TaxableListDto.getInstanceFromMap((Map)data);
                taxableListDto.setTaxcatetory(TaxableListEnum.ZZS.getBaseTaxId());
                taxableListDto.setSbbcategory(TaxableListEnum.ZZS.getSbbCategory());
                taxableListDto.setDgcategory(TaxableListEnum.ZZS.getDgCategory());
                taxableListDto.setMonth(month);
                taxableListDto.setTaxationsys(RuleFetchConstant.DEFALUT_TAXSYSTEM);
                taxableListDto.setTaxareagroup(RuleFetchConstant.DEFALUT_TAXAREAGROUP);
                taxableListDtos.add(taxableListDto);
            }
        }
        ArrayList results = taxableListDtos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TaxableListDto>(Comparator.comparing(a -> a.getOrg() + DateUtils.format((Date)a.getSkssqq()) + DateUtils.format((Date)a.getSkssqz()) + a.getTemplatetype()))), ArrayList::new));
        List<Long> doOrgs = results.stream().map(a -> a.getOrg()).collect(Collectors.toList());
        Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)month, (int)-5));
        Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)month, (int)-1));
        this.fillDgInfo(startDate, endDate, doOrgs, results);
        return results.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
    }

    public List<Map<String, Object>> queryDeclareTaxableList(List<Long> orgList, List<String> declareCategories, Date declareDate) {
        ArrayList<TaxableListDto> taxableListDtos = new ArrayList<TaxableListDto>(orgList.size());
        Date month = DateUtils.getFirstDateOfMonth((Date)declareDate);
        if (orgList == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        Map zeroDeclareMap = SystemParamUtil.getAppParameterBatch((String)"tcvat", (String)"zerodeclare", orgList);
        for (Long org : orgList) {
            Boolean zeroDeclare = zeroDeclareMap.get(org) != null ? (Boolean)zeroDeclareMap.get(org) : Boolean.FALSE;
            List engineResponses = TaxDeclareHelper.doDeclareVerify((Long)org, (Date)declareDate, null, null, (Boolean)false, (Boolean)zeroDeclare);
            for (EngineResponse engineResponse : engineResponses) {
                Map data;
                if (!engineResponse.getSuccess().booleanValue() || (data = (Map)engineResponse.getData()) == null || data.size() <= 0) continue;
                TaxableListDto taxableListDto = TaxableListDto.getInstanceFromMap((Map)data);
                taxableListDto.setTaxcatetory(TaxableListEnum.ZZS.getBaseTaxId());
                taxableListDto.setSbbcategory(TaxableListEnum.ZZS.getSbbCategory());
                taxableListDto.setDgcategory(TaxableListEnum.ZZS.getDgCategory());
                taxableListDto.setMonth(month);
                taxableListDto.setPaystatus(TaxableListDto.PAYSTATUS_WJK);
                taxableListDto.setDeclarestatus(TaxableListDto.DECLARESTATUS_WBZ);
                taxableListDto.setDraftstatus(TaxableListDto.DRAFTSTATUS_WXBZ);
                taxableListDto.setTaxationsys(RuleFetchConstant.DEFALUT_TAXSYSTEM);
                taxableListDto.setTaxareagroup(RuleFetchConstant.DEFALUT_TAXAREAGROUP);
                taxableListDtos.add(taxableListDto);
            }
        }
        ArrayList results = taxableListDtos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TaxableListDto>(Comparator.comparing(a -> a.getOrg() + DateUtils.format((Date)a.getSkssqq()) + DateUtils.format((Date)a.getSkssqz()) + a.getTemplatetype()))), ArrayList::new));
        ArrayList<Long> doOrgs = new ArrayList<Long>(results.size());
        for (TaxableListDto result : results) {
            doOrgs.add(result.getOrg());
        }
        Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)month, (int)-5));
        Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)month, (int)-1));
        this.fillSbbInfo(startDate, endDate, doOrgs, results);
        return results.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
    }

    private Map<Long, Long> getMainOfficeMap(List<Long> orgs) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgs);
        return ((List)result.getData()).stream().collect(Collectors.toMap(d -> d.getLong("taxorg.id"), d -> d.getLong("taxoffice.id"), (m, n) -> m));
    }

    private void fillSbbInfo(Date startDate, Date endDate, ArrayList<Long> doOrgs, ArrayList<TaxableListDto> results) {
        QFilter dateFilter = new QFilter("skssqq", ">=", (Object)startDate).and("skssqz", "<=", (Object)endDate);
        QFilter orgFilter = new QFilter("org", "in", doOrgs);
        String[] types = (String[])TemplateTypeConstant.getTypeMap().get("zzs");
        QFilter typeFilter = new QFilter("type", "in", (Object)types);
        DynamicObjectCollection sbbList = QueryServiceHelper.query((String)"tcvat_zzs_declare_list", (String)"paystatus,declarestatus,billno,skssqq,skssqz,org,id,type", (QFilter[])new QFilter[]{dateFilter, orgFilter, typeFilter});
        Map<String, DynamicObject> sbbMap = sbbList.stream().collect(Collectors.toMap(a -> this.getUniqKey((DynamicObject)a, true), b -> b, (m, n) -> m));
        Map<Long, Long> taxMainMap = this.getMainOfficeMap(doOrgs);
        for (TaxableListDto result : results) {
            String key = result.getOrg().toString() + DateUtils.format((Date)result.getSkssqq()) + DateUtils.format((Date)result.getSkssqz()) + result.getTemplatetype();
            DynamicObject dynamicObject = sbbMap.get(key);
            if (dynamicObject != null) {
                result.setSbbno(dynamicObject.getString("billno"));
                result.setPaystatus(dynamicObject.getString("paystatus"));
                result.setDeclarestatus(dynamicObject.getString("declarestatus"));
            } else {
                result.setPaystatus(TaxableListDto.PAYSTATUS_WJK);
                result.setDeclarestatus(TaxableListDto.DECLARESTATUS_WBZ);
            }
            Long taxoffice = taxMainMap.getOrDefault(result.getOrg(), 0L);
            result.setTaxauthority(taxoffice);
        }
    }

    private String getUniqKey(DynamicObject a, boolean isDeclare) {
        if (isDeclare) {
            return a.getString("org") + DateUtils.format((Date)a.getDate("skssqq")) + DateUtils.format((Date)a.getDate("skssqz")) + a.getString("type");
        }
        return a.getString("org") + DateUtils.format((Date)a.getDate("startdate")) + DateUtils.format((Date)a.getDate("enddate"));
    }

    private void fillDgInfo(Date startDate, Date endDate, List<Long> doOrgs, ArrayList<TaxableListDto> results) {
        LicenseCheckResult licenseCheckResult = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            results.stream().forEach(a -> a.setDraftstatus(TaxableListDto.DRAFTSTATUS_WXBZ));
            return;
        }
        QFilter orgFilter = new QFilter("org", "in", doOrgs);
        QFilter dateFilter = new QFilter("startdate", ">=", (Object)startDate).and("enddate", "<=", (Object)endDate);
        QFilter typeFilter = new QFilter("drafttype", "=", (Object)"zzs");
        DynamicObjectCollection dgList = QueryServiceHelper.query((String)"tctb_draft_main", (String)"billstatus,billno,startdate,enddate,org,id", (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
        Map<String, DynamicObject> dgMap = dgList.stream().collect(Collectors.toMap(a -> this.getUniqKey((DynamicObject)a, false), b -> b, (m, n) -> m));
        Map<Long, Long> taxMainMap = this.getMainOfficeMap(doOrgs);
        for (TaxableListDto result : results) {
            if (!Objects.equals(result.getDraftstatus(), TaxableListDto.DRAFTSTATUS_WXBZ)) {
                String key = result.getOrg().toString() + DateUtils.format((Date)result.getSkssqq()) + DateUtils.format((Date)result.getSkssqz());
                DynamicObject dynamicObject = dgMap.get(key);
                if (dynamicObject != null) {
                    result.setDraftstatus(StringUtil.isEmpty((CharSequence)dynamicObject.getString("billstatus")) ? TaxableListDto.DRAFTSTATUS_WBZ : dynamicObject.getString("billstatus"));
                    result.setDraftNo(dynamicObject.getString("billno"));
                } else {
                    result.setDraftstatus(TaxableListDto.DRAFTSTATUS_WBZ);
                }
            }
            Long taxoffice = taxMainMap.getOrDefault(result.getOrg(), 0L);
            result.setTaxauthority(taxoffice);
        }
    }
}

