/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.mservice.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.handler.QueryOrSaveDeclareHandler;
import kd.taxc.bdtaxr.common.declare.handler.QueryOrSaveDeclareServiceFactory;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.mservice.api.EngineService;

public class DeclareEngineServiceImpl
implements EngineService {
    private static Log LOGGER = LogFactory.getLog(DeclareEngineServiceImpl.class);

    @Override
    public String generate(String request) {
        DeclareRequest engineRequest = (DeclareRequest)SerializationUtils.fromJsonString((String)request, DeclareRequest.class);
        HashMap<String, Date> paramMap = new HashMap<String, Date>();
        EngineResponse engineResponse = new EngineResponse(Boolean.FALSE, paramMap, ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7533\u62a5\u4efb\u52a1\u751f\u6210\u6210\u529f", (String)"DeclareEngineServiceImpl_5", (String)"taxc-tcvat-mservice", (Object[])new Object[0]), "500");
        try {
            Date endDate;
            Date startDate;
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)Long.parseLong(engineRequest.getOrgId()));
            EngineResponse verifyRes = TaxDeclareHelper.verifyZeroDeclareLicenseOrg((boolean)zerodeclare, (boolean)true, (String)engineRequest.getOrgId());
            if (!verifyRes.getSuccess().booleanValue()) {
                engineResponse.setMessage(verifyRes.getMessage());
                return SerializationUtils.toJsonString((Object)engineResponse);
            }
            if (Objects.isNull(engineRequest.getStartDate()) && Objects.isNull(engineRequest.getEndDate())) {
                Map initDateMap = PeriodService.preTaxPeriod((String)engineRequest.getOrgId(), (Date)engineRequest.getExecuteTime());
                startDate = (Date)initDateMap.get("startDate");
                endDate = (Date)initDateMap.get("endDate");
            } else {
                startDate = engineRequest.getStartDate();
                endDate = engineRequest.getEndDate();
                if (null == startDate || null == endDate) {
                    engineResponse.setMessage(ResManager.loadKDString((String)"\u7533\u62a5\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeclareEngineServiceImpl_1", (String)"taxc-tcvat-mservice", (Object[])new Object[0]));
                    return SerializationUtils.toJsonString((Object)engineResponse);
                }
            }
            paramMap.put("skssqq", startDate);
            paramMap.put("skssqz", endDate);
            Map taxPayerTypeMap = TaxDeclareHelper.getTaxPayerType((String)engineRequest.getOrgId(), (Date)startDate, (Date)endDate);
            String taxpayertype = (String)taxPayerTypeMap.get("taxpayertype");
            LOGGER.info("DeclareTaxPayerTypeMap" + SerializationUtils.toJsonString((Object)taxPayerTypeMap));
            EngineResponse verifyResult = TaxDeclareHelper.verifyDeclareTaxpayerType((Map)taxPayerTypeMap, (boolean)zerodeclare, (String)engineRequest.getOrgId(), (Date)startDate, (Date)endDate);
            if (!verifyResult.getSuccess().booleanValue()) {
                engineResponse.setMessage(verifyResult.getMessage());
                return SerializationUtils.toJsonString((Object)engineResponse);
            }
            if (zerodeclare) {
                engineResponse = this.createSBB(engineRequest.getOrgId(), engineResponse, startDate, endDate, taxpayertype, true);
                return SerializationUtils.toJsonString((Object)engineResponse);
            }
            if ("zzsybnsr_yz_zjg".equals(taxpayertype)) {
                DynamicObjectCollection collection = OrgUtils.queryOrgGroupDetailForCollectedOrg((String)"zzs", (String)engineRequest.getOrgId(), (String)DateUtils.format((Date)startDate));
                ArrayList<String> zjgOrgid = new ArrayList<String>(10);
                List colOrgs = collection.stream().map(a -> a.getLong("orgid")).collect(Collectors.toList());
                Map appParameterBatch = SystemParamUtil.getAppParameterBatch((String)"tcvat", (String)"zerodeclare", colOrgs);
                for (DynamicObject planObj : collection) {
                    String orgid = planObj.getString("orgid");
                    Object isZeroDeclare = appParameterBatch.get(Long.parseLong(orgid));
                    if ("1".equals(planObj.getString("levelname")) && (planObj.getBoolean("issuesbb") || Boolean.TRUE.equals(isZeroDeclare))) {
                        zjgOrgid.add(orgid);
                        continue;
                    }
                    if (!"2".equals(planObj.getString("levelname")) || !planObj.getBoolean("issuesbb") && !Boolean.TRUE.equals(isZeroDeclare)) continue;
                    DeclareRequest clone = engineRequest.clone();
                    clone.setOrgId(orgid);
                    String generate = this.generate(SerializationUtils.toJsonString((Object)clone));
                    engineResponse = (EngineResponse)SerializationUtils.fromJsonString((String)generate, EngineResponse.class);
                }
                for (String orgid : zjgOrgid) {
                    engineResponse = this.createSBB(orgid, engineResponse, startDate, endDate, taxpayertype, false);
                }
            } else {
                engineResponse = this.createSBB(engineRequest.getOrgId(), engineResponse, startDate, endDate, taxpayertype, false);
            }
        }
        catch (Exception e) {
            engineResponse.setSuccess(Boolean.FALSE);
            engineResponse.setMessage(e.getMessage());
        }
        return SerializationUtils.toJsonString((Object)engineResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineResponse createSBB(String orgid, EngineResponse engineResponse, Date startDate, Date endDate, String taxpayertype, boolean zerodeclare) {
        Map cache = TaxDeclareHelper.getTemplateType((String)"declare", (String)orgid, (String)DateUtils.format((Date)startDate), (String)DateUtils.format((Date)endDate), (String)"nssb");
        LOGGER.info("DeclareCache" + SerializationUtils.toJsonString((Object)cache));
        if (null != cache.get("orgmsg")) {
            engineResponse.setMessage((String)cache.get("orgmsg"));
            return engineResponse;
        }
        String templateType = (String)cache.get("templatetype");
        String lockKey = String.format("zzscreatelock-%s-%s-%s-%s", orgid, DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), templateType);
        DLock reentrant = DLock.createReentrant((String)lockKey, (String)"kd.taxc.tcvat.mservice.engine.DeclareEngineServiceImpl.createSBB");
        reentrant.fastMode();
        boolean b = reentrant.tryLock(1000L);
        if (!b) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u5df2\u6709\u4efb\u52a1\u5728\u6267\u884c\u751f\u6210\u6b64\u7533\u62a5\u8868", (String)"DeclareEngineServiceImpl_4", (String)"taxc-tcvat-mservice", (Object[])new Object[0]));
            return engineResponse;
        }
        try {
            QFilter filterList = new QFilter("org", "=", (Object)Long.valueOf(orgid)).and(new QFilter("skssqq", "=", (Object)DateUtils.trunc((Date)startDate))).and(new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)endDate))).and(new QFilter("type", "in", Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg")));
            DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_zzs_declare_list", (String)"type", (QFilter[])new QFilter[]{filterList});
            if (null != object) {
                String orgName = OrgUtils.getOrgNameById((String)orgid);
                String declareType = (String)TemplateTypeConstant.getMap().get(object.getString("type"));
                LOGGER.info("DeclareEngineResponse" + SerializationUtils.toJsonString((Object)engineResponse));
                engineResponse.setMessage(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u5df2\u5b58\u5728\u5c5e\u671f\u4e3a\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u7684\u3010%4$s\u3011\u7533\u62a5\u8868,\u65e0\u9700\u751f\u6210\u3002", (String)"DeclareEngineServiceImpl_0", (String)"taxc-tcvat-mservice", (Object[])new Object[0]), orgName, DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), declareType));
                EngineResponse engineResponse2 = engineResponse;
                return engineResponse2;
            }
            if (zerodeclare && !"zzsxgmnsr".equals(cache.get("templatetype"))) {
                templateType = "zzsybnsr";
            }
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(orgid));
            requestModel.setSkssqq(DateUtils.format((Date)startDate));
            requestModel.setSkssqz(DateUtils.format((Date)endDate));
            HashMap<String, String> bizParams = new HashMap<String, String>(16);
            bizParams.put("taxPayerType", taxpayertype);
            DynamicObject zlb = YbnsrService.queryYbnsr((String)orgid, (String)templateType, (String)DateUtils.format((Date)startDate), (String)DateUtils.format((Date)endDate), (int)0, null);
            bizParams.put("zlbid", null == zlb ? "0" : zlb.getString("id"));
            bizParams.put("registerType", TaxDeclareHelper.getTaxRegisterType((String)orgid));
            DynamicObject declare = YbnsrService.queryYbnsr((String)orgid, (String)templateType, (String)DateUtils.format((Date)startDate), (String)DateUtils.format((Date)endDate), Collections.emptyMap());
            if (declare != null) {
                bizParams.put("cache_sbbid", declare.getString("id"));
            }
            HashMap<String, String> extendParamMap = new HashMap<String, String>();
            extendParamMap.put("zerodeclare", zerodeclare ? "1" : "0");
            requestModel.setExtendParams(extendParamMap);
            bizParams.put("zerodeclare", zerodeclare ? "1" : "0");
            String billNo = DeclareUtils.getBillNo((String)orgid, (Date)startDate, (Date)endDate, (String)templateType);
            requestModel.setBillNo(billNo);
            requestModel.setBusinessMap(bizParams);
            requestModel.setTemplateType(templateType);
            Long templateId = DeclareServiceHelper.getTemplateId((DeclareRequestModel)requestModel);
            if (null == templateId) {
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u7533\u62a5\u8868\u5931\u8d25\uff0c\u6a21\u677f\u672a\u627e\u5230", (String)"DeclareEngineServiceImpl_6", (String)"taxc-tcvat-mservice", (Object[])new Object[0]));
            }
            requestModel.setTemplateId(templateId);
            requestModel.setRefresh(Boolean.TRUE);
            QueryOrSaveDeclareHandler handler = QueryOrSaveDeclareServiceFactory.create((Long)requestModel.getTemplateId());
            DeclareResponseModel responseModel = handler.query(requestModel);
            handler.save(requestModel, responseModel.getData(), responseModel.getData(), responseModel.getMetaDataMap());
            handler.savePost(requestModel, responseModel);
            engineResponse.setSuccess(Boolean.TRUE);
        }
        finally {
            reentrant.unlock();
        }
        return engineResponse;
    }
}

