/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.mservice.engine;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.vo.DraftRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.mservice.api.EngineService;

public class DraftEngineServiceImpl
implements EngineService {
    private static Log LOGGER = LogFactory.getLog(DraftEngineServiceImpl.class);
    private TcvatDraftService draftService = new TcvatDraftService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generate(String request) {
        DraftRequest engineRequest = (DraftRequest)SerializationUtils.fromJsonString((String)request, DraftRequest.class);
        HashMap<String, Date> paramMap = new HashMap<String, Date>();
        EngineResponse engineResponse = new EngineResponse(Boolean.FALSE, paramMap, null, null);
        Map initDateMap = PeriodService.preTaxPeriod((String)engineRequest.getOrgId(), (Date)engineRequest.getExecuteTime());
        Date startDate = (Date)initDateMap.get("startDate");
        Date endDate = DateUtils.getLastDateOfMonth2((Date)((Date)initDateMap.get("endDate")));
        paramMap.put("skssqq", startDate);
        paramMap.put("skssqz", endDate);
        Map taxPayerTypeMap = TaxDeclareHelper.getTaxPayerType((String)engineRequest.getOrgId(), (Date)startDate, (Date)endDate);
        String taxpayertype = (String)taxPayerTypeMap.get("taxpayertype");
        LOGGER.info("draftTaxPayerTypeMap" + SerializationUtils.toJsonString((Object)taxPayerTypeMap));
        DLock reentrant = this.createReentrantLock(engineRequest, startDate, endDate, taxpayertype);
        boolean zzsdraftcreatelock = reentrant.tryLock(1000L);
        if (!zzsdraftcreatelock) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u5df2\u6709\u4efb\u52a1\u5728\u6267\u884c\u751f\u6210\u6b64\u5e95\u7a3f", (String)"DraftEngineServiceImpl_3", (String)"taxc-tcvat-mservice", (Object[])new Object[0]));
            return SerializationUtils.toJsonString((Object)engineResponse);
        }
        try {
            LicenseCheckResult result = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
            if (!result.getHasLicense().booleanValue()) {
                engineResponse.setMessage(result.getMsg());
                String string = SerializationUtils.toJsonString((Object)engineResponse);
                return string;
            }
            String verifyMsg = TaxDeclareHelper.verify((String)engineRequest.getOrgId());
            if (null != verifyMsg) {
                engineResponse.setMessage(verifyMsg);
                String string = SerializationUtils.toJsonString((Object)engineResponse);
                return string;
            }
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)Long.parseLong(engineRequest.getOrgId()));
            if (zerodeclare) {
                String orgname = OrgUtils.getOrgNameById((String)engineRequest.getOrgId());
                engineResponse.setMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"DraftEngineServiceImpl_1", (String)"taxc-tcvat-mservice", (Object[])new Object[0]), orgname));
                String string = SerializationUtils.toJsonString((Object)engineResponse);
                return string;
            }
            if ((taxpayertype.equals("zzsybnsr") || taxpayertype.equals("zzsybnsr_yz_fzjg") || taxpayertype.equals("zzsybnsr_hz_fzjg")) && null != taxPayerTypeMap.get("taxpayertypemsg")) {
                engineResponse.setMessage((String)taxPayerTypeMap.get("taxpayertypemsg"));
                String orgname = SerializationUtils.toJsonString((Object)engineResponse);
                return orgname;
            }
            Map cache = TaxDeclareHelper.getTemplateType((String)"draft", (String)engineRequest.getOrgId(), (String)DateUtils.format((Date)startDate), (String)DateUtils.format((Date)endDate), (String)"nssb");
            LOGGER.info("draftCache" + SerializationUtils.toJsonString((Object)cache));
            if (null != cache.get("orgmsg")) {
                engineResponse.setMessage((String)cache.get("orgmsg"));
                String string = SerializationUtils.toJsonString((Object)engineResponse);
                return string;
            }
            String errMsg = this.draftService.checkAlreadyExistsDraft("nssb", engineRequest.getOrgId(), startDate, endDate);
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                engineResponse.setMessage(errMsg);
                LOGGER.info("draftEngineResponse" + SerializationUtils.toJsonString((Object)engineResponse));
                String string = SerializationUtils.toJsonString((Object)engineResponse);
                return string;
            }
            EngineHandler handler = EngineHandlerFactory.createHandler((String)taxpayertype);
            TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel((String)engineRequest.getOrgId(), (String)DateUtils.format((Date)startDate), (String)DateUtils.format((Date)endDate), (String)taxpayertype, null, (String)"nssb");
            LOGGER.info("draftEngineModel" + SerializationUtils.toJsonString((Object)engineModel));
            handler.validate((EngineModel)engineModel);
            handler.execute((EngineModel)engineModel);
            engineResponse.setSuccess(Boolean.TRUE);
            engineResponse.setMessage(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u5e95\u7a3f\u4efb\u52a1\u751f\u6210\u6210\u529f", (String)"DraftEngineServiceImpl_2", (String)"taxc-tcvat-mservice", (Object[])new Object[0]));
        }
        catch (KDBizException exception) {
            engineResponse.setSuccess(Boolean.FALSE);
            engineResponse.setMessage(exception.getMessage());
        }
        finally {
            reentrant.unlock();
        }
        return SerializationUtils.toJsonString((Object)engineResponse);
    }

    public DLock createReentrantLock(DraftRequest engineRequest, Date startDate, Date endDate, String taxpayertype) {
        String lockKey = String.format("zzsdraftcreatelock-%s-%s-%s-%s", engineRequest.getOrgId(), DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), taxpayertype);
        DLock reentrant = DLock.createReentrant((String)lockKey, (String)"kd.taxc.tcvat.mservice.engine.DeclareEngineServiceImpl.createSBB");
        reentrant.fastMode();
        return reentrant;
    }
}

