/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.mservice.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.common.util.UUID;

public class IncomeEngineService {
    private static final String PAGE_ACCOUNT_SUMMARY = "tcvat_account_summary";
    private static final String PAGE_ACCOUNTING_DETAIL = "tcvat_accdetail_income";
    private static final Set<String> TAX_METHOD_JYZS = new HashSet<String>(){
        {
            this.add("4");
            this.add("5");
        }
    };

    public Map<String, BigDecimal> execute(Map<String, Object> param) throws Exception {
        String orgId = (String)param.get("org");
        EngineModel model = new EngineModel(orgId, (String)param.get("startDate"), (String)param.get("endDate"));
        String rulePurpose = (String)param.get("rulePurpose");
        List incomeRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(orgId), (RuleTypeEnum)RuleTypeEnum.INCOME, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.INCOME);
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < incomeRuleList.size(); ++i) {
            DynamicObject incomerule = (DynamicObject)incomeRuleList.get(i);
            String serialno = UUID.randomUUID();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)PAGE_ACCOUNT_SUMMARY);
            DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
            summary.set("serialno", (Object)serialno);
            summary.set("jzjt", incomerule.get("jzjt"));
            summary.set("org", (Object)orgId);
            summary.set("taxperiod", model.getCustom().get("taxperiod"));
            summary.set("ruleid", (Object)incomerule.getLong("id"));
            summary.set("description", (Object)incomerule.getString("name"));
            DynamicObject taxmethodValue = incomerule.getDynamicObject("taxation");
            summary.set("taxmethod", (Object)taxmethodValue.getString("name"));
            summary.set("taxmethodtype", taxmethodValue.get("id"));
            String taxrate = incomerule.getDynamicObject("taxrate").getString("name");
            summary.set("taxrate", (Object)taxrate);
            taxrate = NewRuleSettingUtils.trimTaxRate((String)taxrate);
            NewRuleSettingTask invoiceTask = new NewRuleSettingTask(new ConcurrentHashMap(), new ConcurrentHashMap(), incomerule, model, incomerule.getDynamicObjectCollection("invoiceentity"), serialno, "tcvat_income_invoice", taxrate, "12", RuleSettingConstant.GET_DATE_TYPE_ZYSR, model.getStartDate().substring(0, 7));
            List invoiceFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)invoiceTask);
            NewRuleSettingTask otherInvoiceTask = new NewRuleSettingTask(new ConcurrentHashMap(), new ConcurrentHashMap(), incomerule, model, incomerule.getDynamicObjectCollection("entryentity1"), serialno, PAGE_ACCOUNTING_DETAIL, taxrate, "1", RuleSettingConstant.GET_DATE_TYPE_QTSR, model.getStartDate().substring(0, 7));
            List otherFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)otherInvoiceTask);
            NewRuleSettingTask ruleSettingTask = new NewRuleSettingTask(new ConcurrentHashMap(), new ConcurrentHashMap(), incomerule, model, incomerule.getDynamicObjectCollection("entryentity"), serialno, PAGE_ACCOUNTING_DETAIL, taxrate, "", RuleSettingConstant.GET_DATE_TYPE_WKPSR, model.getStartDate().substring(0, 7));
            List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
            List invoiceList = EngineTask.getFutureList((List)invoiceFutures);
            BigDecimal invoiceamount = IncomeUtils.getInvoiceTotalAmount((List)invoiceList, (String)"invoiceamount");
            List otherAccountingList = EngineTask.getFutureList((List)otherFutures);
            BigDecimal otherAccount = IncomeUtils.getAccountingAmount((List)otherAccountingList);
            List accountingList = EngineTask.getFutureList((List)futures);
            BigDecimal accountingamount = IncomeUtils.getAccountingAmount((List)accountingList);
            summary.set("invoiceamount", (Object)invoiceamount);
            BigDecimal invoicetaxamount = IncomeUtils.getInvoiceTotalAmount((List)invoiceList, (String)"taxamount");
            summary.set("invoicetaxamount", (Object)BigDecimalUtil.addObject((Object)invoiceamount, (Object)invoicetaxamount));
            BigDecimal totalAmount = BigDecimalUtil.addObject((Object)BigDecimalUtil.addObject((Object)invoiceamount, (Object)otherAccount), (Object)accountingamount);
            summary.set("taxamount", (Object)totalAmount);
            summaryList.add(summary);
        }
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal jyzsTaxAmount = BigDecimal.ZERO;
        BigDecimal msTaxAmount = BigDecimal.ZERO;
        BigDecimal ckmsAmount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(8);
        if (summaryList.size() > 0) {
            for (DynamicObject object : summaryList) {
                taxAmount = taxAmount.add(object.getBigDecimal("taxamount"));
                if (TAX_METHOD_JYZS.contains(object.getString("taxmethodtype"))) {
                    jyzsTaxAmount = jyzsTaxAmount.add(object.getBigDecimal("taxamount"));
                }
                if ("3".equals(object.getString("taxmethodtype"))) {
                    msTaxAmount = msTaxAmount.add(object.getBigDecimal("taxamount"));
                }
                if (!"19".equals(object.getString("taxmethodtype"))) continue;
                ckmsAmount = ckmsAmount.add(object.getBigDecimal("taxamount"));
            }
            resultMap.put("taxamount", taxAmount);
            resultMap.put("jyzstaxamount", jyzsTaxAmount);
            resultMap.put("mstaxamount", msTaxAmount);
            resultMap.put("ckmsamount", ckmsAmount);
        }
        return resultMap;
    }
}

