/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.mservice.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.transfer.apportion.task.ApportionRuleSettingTask;

public class TransferOutProportionServiceImpl {
    private static Log logger = LogFactory.getLog(TransferOutProportionServiceImpl.class);

    public Map<String, BigDecimal> getAmount(Map<String, Object> param) throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u8fdb\u9879\u5206\u644a\u6bd4\u4f8b\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        String orgId = (String)param.get("org");
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        List apportionRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(orgId), (RuleTypeEnum)RuleTypeEnum.APPORTION, (String)"ybnsr", (String)"nssb").get(RuleTypeEnum.APPORTION);
        ArrayList<DynamicObject> summaryInvoiceList = new ArrayList<DynamicObject>();
        for (DynamicObject rule : apportionRuleList) {
            String transferOutType = rule.getString("wfhfzclx");
            if (!transferOutType.equals(param.get("transferouttype"))) continue;
            this.unableDeductTax(rule, summaryInvoiceList, param, resultMap);
            this.totalSales(rule, summaryInvoiceList, param, resultMap);
            this.projectSales(rule, summaryInvoiceList, param, resultMap);
            break;
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u8fdb\u9879\u5206\u644a\u6bd4\u4f8b\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultMap;
    }

    private void unableDeductTax(DynamicObject rule, List<DynamicObject> summaryInvoiceList, Map<String, Object> param, Map<String, BigDecimal> resultMap) throws Exception {
        DynamicObjectCollection unablePartition = rule.getDynamicObjectCollection("entryentity");
        ApportionRuleSettingTask apportionRuleSettingTask = new ApportionRuleSettingTask(unablePartition, param, "");
        List apportionFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)apportionRuleSettingTask);
        List<DynamicObject> invoiceList = this.getFutureList(apportionFutures);
        summaryInvoiceList.addAll(invoiceList);
        BigDecimal unablededucttax = IncomeUtils.getAccountingAmount(invoiceList);
        resultMap.put("unablededucttax", unablededucttax);
    }

    private void totalSales(DynamicObject rule, List<DynamicObject> summaryInvoiceList, Map<String, Object> param, Map<String, BigDecimal> resultMap) throws Exception {
        boolean incomeDraft = rule.getBoolean("isfromdraft1");
        if (incomeDraft) {
            Object incomeData = param.get("incomeamount");
            Map incomeDataMap = (Map)incomeData;
            resultMap.put("totalsales", (BigDecimal)incomeDataMap.get("taxamount"));
        } else {
            DynamicObjectCollection unablePartition = rule.getDynamicObjectCollection("entryentity1");
            ApportionRuleSettingTask apportionRuleSettingTask = new ApportionRuleSettingTask(unablePartition, param, "1");
            List apportionFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)apportionRuleSettingTask);
            List<DynamicObject> invoiceList = this.getFutureList(apportionFutures);
            summaryInvoiceList.addAll(invoiceList);
            BigDecimal totalSales = IncomeUtils.getAccountingAmount(invoiceList);
            resultMap.put("totalsales", totalSales);
        }
    }

    private void projectSales(DynamicObject rule, List<DynamicObject> summaryInvoiceList, Map<String, Object> param, Map<String, BigDecimal> resultMap) throws Exception {
        String transferOutType = rule.getString("wfhfzclx");
        boolean incomeDraft = rule.getBoolean("1".equals(transferOutType) ? "isfromdraft12" : "isfromdraft11");
        if (incomeDraft) {
            Object incomeData = param.get("incomeamount");
            Map incomeDataMap = (Map)incomeData;
            resultMap.put("projectsales", "1".equals(transferOutType) ? incomeDataMap.getOrDefault("mstaxamount", BigDecimal.ZERO).add(incomeDataMap.getOrDefault("ckmsamount", BigDecimal.ZERO)) : (BigDecimal)incomeDataMap.get("jyzstaxamount"));
        } else {
            DynamicObjectCollection unablePartition = rule.getDynamicObjectCollection("1".equals(transferOutType) ? "entryentity12" : "entryentity11");
            ApportionRuleSettingTask apportionRuleSettingTask = new ApportionRuleSettingTask(unablePartition, param, "1".equals(transferOutType) ? "12" : "11");
            List apportionFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)apportionRuleSettingTask);
            List<DynamicObject> invoiceList = this.getFutureList(apportionFutures);
            summaryInvoiceList.addAll(invoiceList);
            BigDecimal totalSales = IncomeUtils.getAccountingAmount(invoiceList);
            resultMap.put("projectsales", totalSales);
        }
    }

    private List<DynamicObject> getFutureList(List<Future<Object>> futures) throws Exception {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (Future<Object> future : futures) {
            list.addAll((Collection)future.get());
        }
        return list;
    }
}

