/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.abstractbusiness;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.tcvvt.business.abstractbusiness.AbstractDeclareRuleFetchBusiness;
import kd.taxc.tcvvt.business.abstractbusiness.AbstractRuleFetchBusiness;
import kd.taxc.tcvvt.business.api.common.DeclareBusiness;
import kd.taxc.tcvvt.business.rulefetch.DeclareRuleFetchTask;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleEngineDto;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleFetchDto;
import kd.taxc.tcvvt.common.util.engine.PartitionSaveTask;
import kd.taxc.tcvvt.common.util.threadpools.ThreadPoolsService;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractDeclareBusiness
extends AbstractDeclareRuleFetchBusiness
implements DeclareBusiness {
    private static Log logger = LogFactory.getLog(AbstractDeclareBusiness.class);

    @Override
    public List<DynamicObject> queryMatchAccessConfig(Long orgId, QFilter otherFilter) {
        QFilter publicFilter;
        QFilter statusQ;
        QFilter enableQ;
        QFilter accessIdQ;
        DynamicObject[] collection;
        QFilter orgQ = new QFilter("org", "=", (Object)orgId);
        if (ObjectUtils.isNotEmpty((Object)otherFilter)) {
            orgQ.and(otherFilter);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter privateFilter = new QFilter("ruletype", "=", (Object)"private");
        DynamicObject[] privateAccessConfigList = BusinessDataServiceHelper.load((String)this.accessEntityName, (String)this.accessSelectFields, (QFilter[])new QFilter[]{orgQ, enableFilter, statusFilter, privateFilter});
        ArrayList<Object> privateAccessProjectIds = new ArrayList<Object>();
        List<DynamicObject> noRepeatPrivateAccessConfigList = this.removeRepetRetainOne(privateAccessConfigList, privateAccessProjectIds);
        List<DynamicObject> sharingPlanList = this.querySharingPlan(orgId, null);
        List<Object> publicAccessProjectIds = new ArrayList();
        publicAccessProjectIds = this.accessEntityName.equalsIgnoreCase("tcvvt_tax_accessconfig") ? sharingPlanList.stream().filter(row -> !privateAccessProjectIds.contains(row.getLong(this.sharingPlanRule_Accessproject) + "-" + row.getLong(this.sharingPlanRule_Projectcaliber))).filter(AbstractDeclareBusiness.distinctByKey(row -> row.getLong(this.sharingPlanRule_Accessproject) + "-" + row.getLong(this.sharingPlanRule_Projectcaliber))).map(o -> o.getLong(this.sharingPlanRule)).collect(Collectors.toList()) : sharingPlanList.stream().filter(row -> !privateAccessProjectIds.contains(row.getLong(this.sharingPlanRule_Accessproject))).filter(AbstractDeclareBusiness.distinctByKey(row -> row.getLong(this.sharingPlanRule_Accessproject))).map(o -> o.getLong(this.sharingPlanRule)).collect(Collectors.toList());
        ArrayList publicAccessConfigList = new ArrayList();
        if (ObjectUtils.isNotEmpty(publicAccessProjectIds) && null != (collection = BusinessDataServiceHelper.load((String)this.accessEntityName, (String)this.accessSelectFields, (QFilter[])new QFilter[]{accessIdQ = new QFilter("id", "in", publicAccessProjectIds), enableQ = new QFilter("enable", "=", (Object)"1"), statusQ = new QFilter("status", "=", (Object)"C"), publicFilter = new QFilter("ruletype", "=", (Object)"public"), otherFilter}))) {
            Collections.addAll(publicAccessConfigList, collection);
        }
        ArrayList<DynamicObject> allAccessConfigList = new ArrayList<DynamicObject>();
        allAccessConfigList.addAll(noRepeatPrivateAccessConfigList);
        allAccessConfigList.addAll(publicAccessConfigList);
        return allAccessConfigList;
    }

    @Override
    public List<DynamicObject> querySharingPlan(Long orgId, QFilter otherFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        QFilter orgQ = new QFilter(this.sharingPlanOrg, "=", (Object)orgId);
        if (ObjectUtils.isNotEmpty((Object)otherFilter)) {
            orgQ.and(otherFilter);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection sharingPlanList = QueryServiceHelper.query((String)this.sharingplanEntityName, (String)this.sharingplanSelectFields, (QFilter[])new QFilter[]{orgQ, enableFilter, statusFilter});
        if (ObjectUtils.isEmpty((Object)sharingPlanList)) {
            return list;
        }
        sharingPlanList.stream().forEach(o -> list.add((DynamicObject)o));
        return list;
    }

    @Override
    public List<RuleFetchDto> getRuleFetchSummaryAmount(RuleEngineDto ruleEngineDto, AbstractRuleFetchBusiness ruleFetchBusiness, String templateNum) {
        long time = System.currentTimeMillis();
        Long orgId = ruleEngineDto.getOrgId();
        List<DynamicObject> accessConfigList = this.queryMatchAccessConfig(orgId, null);
        ruleEngineDto.setAccessConfigList(accessConfigList);
        logger.info("{}\u6b65\u9aa41\uff1a\u83b7\u53d6\u6240\u6709\u5339\u914d\u7684\u53d6\u6570\u914d\u7f6e\u7ed3\u675f,\u83b7\u5f97\u53d6\u6570\u89c4\u5219\u6761\u6570\uff1a{},\u8017\u65f6{}", new Object[]{this.getClass().getName(), accessConfigList.size(), System.currentTimeMillis() - time});
        time = System.currentTimeMillis();
        List<RuleFetchDto> ruleFetchDtoList = ruleFetchBusiness.getRuleFetchSummaryAmount(ruleEngineDto, templateNum);
        List<DynamicObject> ruleFetchSummaryList = this.getFetchSummaryList(ruleFetchDtoList);
        List<DynamicObject> ruleFetchDetailList = this.getFetchDetailList(ruleFetchDtoList);
        logger.info("{}\u6b65\u9aa42\uff1a\u83b7\u53d6\u53d6\u6570\u8bb0\u5f55{}\u6761\uff0c\u660e\u7ec6\u8bb0\u5f55{}\u6761,\u8017\u65f6\uff1a{}", new Object[]{this.getClass().getName(), ruleFetchSummaryList.size(), ruleFetchDetailList.size(), System.currentTimeMillis() - time});
        this.delOldFetchAountAndSaveNew(ruleEngineDto, ruleFetchSummaryList, ruleFetchDetailList);
        return ruleFetchDtoList;
    }

    @Override
    public List<RuleFetchDto> getRuleFetchSummaryAmountTask(Long orgId, Date skssqq, Date skssqz, String templateType, AbstractRuleFetchBusiness ruleFetchBusiness, Map<String, String> formulakeyMap, Map<String, String> formulakeyMapSn, String templateNum) {
        long time = System.currentTimeMillis();
        List<DynamicObject> accessConfigList = this.queryMatchAccessConfig(orgId, null);
        logger.info("{}\u6b65\u9aa41\uff1a\u83b7\u53d6\u6240\u6709\u5339\u914d\u7684\u53d6\u6570\u914d\u7f6e\u7ed3\u675f,\u83b7\u5f97\u53d6\u6570\u89c4\u5219\u6761\u6570\uff1a{},\u8017\u65f6{}", new Object[]{this.getClass().getName(), accessConfigList.size(), System.currentTimeMillis() - time});
        time = System.currentTimeMillis();
        DeclareRuleFetchTask declareRuleFetchTask = new DeclareRuleFetchTask(orgId, skssqq, skssqz, templateType, accessConfigList, ruleFetchBusiness, formulakeyMap, formulakeyMapSn, templateNum);
        List<Future<Object>> submitReturnFuture = ThreadPoolsService.getInstance().submitReturnFuture(declareRuleFetchTask);
        try {
            for (Future<Object> future : submitReturnFuture) {
                future.get();
            }
        }
        catch (Exception e) {
            logger.error("{}\u83b7\u53d6\u53d6\u6570\u7ed3\u679c\u5f02\u5e38:{}", (Object)this.getClass().getName(), (Object)e.getMessage());
        }
        List<RuleFetchDto> resultList = declareRuleFetchTask.ruleFetchResultList;
        resultList = this.multipleGetFetch(resultList, orgId, skssqq, skssqz);
        List<DynamicObject> ruleFetchSummaryList = this.getFetchSummaryList(resultList);
        List<DynamicObject> ruleFetchDetailList = this.getFetchDetailList(resultList);
        logger.info("{}\u6b65\u9aa42\uff1a\u83b7\u53d6\u53d6\u6570\u8bb0\u5f55{}\u6761\uff0c\u660e\u7ec6\u8bb0\u5f55{}\u6761,\u8017\u65f6\uff1a{}", new Object[]{this.getClass().getName(), ruleFetchSummaryList.size(), ruleFetchDetailList.size(), System.currentTimeMillis() - time});
        time = System.currentTimeMillis();
        ThreadPoolsService.getInstance().submit(new PartitionSaveTask(ruleFetchSummaryList));
        ThreadPoolsService.getInstance().submit(new PartitionSaveTask(ruleFetchDetailList));
        logger.info("{}\u6b65\u9aa43:\u4fdd\u5b58\u79d1\u76ee\u8bb0\u5f55{}\u6761\uff0c\u660e\u7ec6\u8bb0\u5f55{}\u6761\uff0c\u8017\u65f6:{}", new Object[]{this.getClass().getName(), ruleFetchSummaryList.size(), ruleFetchDetailList.size(), System.currentTimeMillis() - time});
        return resultList;
    }

    @Override
    public Map<String, String> getFetchAmountParams(Long orgId, Date skssqq, Date skssqz, String templateType, AbstractRuleFetchBusiness ruleFetchBusiness) {
        HashMap<String, String> map = new HashMap<String, String>();
        String templatenum = this.gettemplatenum(orgId, skssqq, skssqz, templateType);
        RuleEngineDto ruleEngineDto = new RuleEngineDto(orgId, skssqq, skssqz, templateType, null);
        List<RuleFetchDto> ruleFetchDtoList = this.getRuleFetchSummaryAmount(ruleEngineDto, ruleFetchBusiness, templatenum);
        for (RuleFetchDto ruleFetchDto : ruleFetchDtoList) {
            if (!ObjectUtils.isNotEmpty((Object)ruleFetchDto.getFormulakey())) continue;
            map.put(ruleFetchDto.getFormulakey(), String.valueOf(ruleFetchDto.getFetchamount()));
        }
        return map;
    }

    @Override
    public Map<String, String> getFetchAmountParamsTask(Long orgId, Date skssqq, Date skssqz, String templateType, AbstractRuleFetchBusiness ruleFetchBusiness, Map<String, String> formulakeyMap, Map<String, String> formulakeyMapSn, String templateNum) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<RuleFetchDto> ruleFetchDtoList = this.getRuleFetchSummaryAmountTask(orgId, skssqq, skssqz, templateType, ruleFetchBusiness, formulakeyMap, formulakeyMapSn, templateNum);
        for (RuleFetchDto ruleFetchDto : ruleFetchDtoList) {
            if (!ObjectUtils.isNotEmpty((Object)ruleFetchDto.getFormulakey())) continue;
            map.put(ruleFetchDto.getFormulakey(), String.valueOf(ruleFetchDto.getReportingAmount()));
        }
        ruleFetchDtoList.clear();
        return map;
    }

    protected List<DynamicObject> getFetchDetailList(List<RuleFetchDto> resultList) {
        ArrayList<DynamicObject> ruleFetchDetailList = new ArrayList<DynamicObject>();
        for (RuleFetchDto ruleFetchDto : resultList) {
            List<RuleFetchDetailDto> detailDtoList = ruleFetchDto.getRuleFetchDetailDtoList();
            for (RuleFetchDetailDto detailDto : detailDtoList) {
                DynamicObject detailObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvvt_fetch_detail");
                detailObject.set("ruleid", (Object)detailDto.getRuleid());
                detailObject.set("org", (Object)detailDto.getOrgid());
                detailObject.set("serialno", (Object)detailDto.getSerialno());
                detailObject.set("skssqq", (Object)detailDto.getSkssqq());
                detailObject.set("skssqz", (Object)detailDto.getSkssqz());
                detailObject.set("filtercondition", (Object)detailDto.getFiltercondition());
                detailObject.set("amountfield", (Object)detailDto.getAmountfield());
                detailObject.set("datadirection", (Object)detailDto.getDatadirection());
                detailObject.set("bizname", (Object)detailDto.getBizname());
                detailObject.set("table", (Object)detailDto.getTable());
                detailObject.set("fetchamount", (Object)detailDto.getFetchamount());
                detailObject.set("absolute", (Object)detailDto.getAbsolute());
                detailObject.set("templatetype", (Object)detailDto.getTemplateType());
                detailObject.set("creater", (Object)RequestContext.get().getCurrUserId());
                detailObject.set("reportingamount", (Object)detailDto.getReportingamount());
                detailObject.set("exrate", (Object)detailDto.getExrate());
                ruleFetchDetailList.add(detailObject);
            }
        }
        return ruleFetchDetailList;
    }

    protected List<DynamicObject> getFetchSummaryList(List<RuleFetchDto> resultList) {
        ArrayList<DynamicObject> ruleFetchSummaryList = new ArrayList<DynamicObject>(8);
        for (RuleFetchDto ruleFetchDto : resultList) {
            DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)"tcvvt_fetch_summary");
            summary.set("org", (Object)ruleFetchDto.getOrgid());
            summary.set("skssqq", (Object)ruleFetchDto.getSkssqq());
            summary.set("skssqz", (Object)ruleFetchDto.getSkssqz());
            summary.set("datasource", (Object)"system");
            summary.set("creater", (Object)RequestContext.get().getCurrUserId());
            summary.set("modifier", (Object)RequestContext.get().getCurrUserId());
            summary.set("accessprojectid", (Object)ruleFetchDto.getAccessprojectid());
            summary.set("formulakey", (Object)ruleFetchDto.getFormulakey());
            summary.set("taxlimit", (Object)ruleFetchDto.getTaxlimit());
            summary.set("serialno", (Object)ruleFetchDto.getSerialno());
            summary.set("fetchamount", (Object)ruleFetchDto.getFetchamount());
            summary.set("templatetype", (Object)ruleFetchDto.getTemplateType());
            summary.set("reportingamount", (Object)ruleFetchDto.getReportingAmount());
            ruleFetchSummaryList.add(summary);
        }
        return ruleFetchSummaryList;
    }

    protected List<DynamicObject> removeRepetRetainOne(DynamicObject[] accessConfigList, List<Object> privateAccessProjectIdList) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        ArrayList<String> list = new ArrayList<String>();
        if (ObjectUtils.isEmpty((Object)accessConfigList)) {
            return result;
        }
        for (DynamicObject accessConfig : accessConfigList) {
            Long accessProjectId = accessConfig.getLong(this.accessProject);
            if (accessConfig.getDataEntityType().getName().equalsIgnoreCase("tcvvt_tax_accessconfig")) {
                Long projectcaliberId = accessConfig.getLong(this.projectcaliber);
                if (!ObjectUtils.isNotEmpty((Object)accessProjectId) || list.contains(accessProjectId + "-" + projectcaliberId)) continue;
                result.add(accessConfig);
                list.add(accessProjectId + "-" + projectcaliberId);
                privateAccessProjectIdList.add(accessProjectId + "-" + projectcaliberId);
                continue;
            }
            if (!ObjectUtils.isNotEmpty((Object)accessProjectId) || privateAccessProjectIdList.contains(accessProjectId)) continue;
            result.add(accessConfig);
            privateAccessProjectIdList.add(accessProjectId);
        }
        return result;
    }

    protected static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private void delOldFetchAountAndSaveNew(RuleEngineDto ruleEngineDto, List<DynamicObject> ruleFetchSummaryList, List<DynamicObject> ruleFetchDetailList) {
        HashMap formulakeyMap = new HashMap(64);
        Long orgId = ruleEngineDto.getOrgId();
        Date skssqq = ruleEngineDto.getSkssqq();
        Date skssqz = ruleEngineDto.getSkssqq();
        String templateType = ruleEngineDto.getTemplateType();
        QFilter taxTypeFilter = new QFilter("taxtype.number", "=", (Object)templateType);
        QFilter formulaname = new QFilter("formula", "like", (Object)"{P%");
        QFilter formulaTypeFilter = new QFilter("formulatype", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_formula_edit", (String)"id,formulaname,formulakey", (QFilter[])new QFilter[]{taxTypeFilter, formulaname, formulaTypeFilter});
        collection.forEach(m -> formulakeyMap.put(m.getString("formulaname"), m.getString("formulakey")));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("templateType", "=", (Object)templateType));
        QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tcvvt_fetch_summary", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_fetch_detail", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_fetch_adjust", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        ruleFetchSummaryList.stream().forEach(summary -> summary.set("formulakey", formulakeyMap.get(summary.getString("accessprojectid"))));
        long time = System.currentTimeMillis();
        ThreadPoolsService.getInstance().submit(new PartitionSaveTask(ruleFetchSummaryList));
        ThreadPoolsService.getInstance().submit(new PartitionSaveTask(ruleFetchDetailList));
        logger.info("{}\u6b65\u9aa43:\u4fdd\u5b58\u79d1\u76ee\u8bb0\u5f55{}\u6761\uff0c\u660e\u7ec6\u8bb0\u5f55{}\u6761\uff0c\u8017\u65f6:{}", new Object[]{this.getClass().getName(), ruleFetchSummaryList.size(), ruleFetchDetailList.size(), System.currentTimeMillis() - time});
    }

    public abstract List<RuleFetchDto> multipleGetFetch(List<RuleFetchDto> var1, Long var2, Date var3, Date var4);
}

