/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.abstractbusiness;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSourceFactory;
import kd.taxc.bdtaxr.common.constant.OrgFuncEnum;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.helper.ExrateConvertHelper;
import kd.taxc.bdtaxr.common.service.RuleFilterConditionService;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.tcvvt.business.abstractbusiness.AbstractDeclareRuleFetchBusiness;
import kd.taxc.tcvvt.business.api.common.RuleFetchBusiness;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleEngineDto;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleFetchDto;
import kd.taxc.tcvvt.common.enums.RuleConfigEnum;
import kd.taxc.tcvvt.common.util.FilterBuilderUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.rulefetch.RuleFetchUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class AbstractRuleFetchBusiness
extends AbstractDeclareRuleFetchBusiness
implements RuleFetchBusiness {
    private static Log logger = LogFactory.getLog(AbstractRuleFetchBusiness.class);
    private static final String ACCESS_ISSUMMURY = "issummury";

    @Override
    public List<RuleFetchDto> getRuleFetchSummaryAmount(RuleEngineDto ruleEngineDto, String templateNum) {
        ArrayList<RuleFetchDto> fetchResultList = new ArrayList<RuleFetchDto>(8);
        List<DynamicObject> accessConfigList = ruleEngineDto.getAccessConfigList();
        if (ObjectUtils.isEmpty(accessConfigList)) {
            return fetchResultList;
        }
        Map<String, List<Long>> isSumOrgRelationMap = this.getIsSumOrgRelationMap(ruleEngineDto);
        Map<Long, Map<Long, List<Long>>> accessconfigDatasourceOrgIdsMap = this.getAccessconfigDatasourceOrgIdsMap(accessConfigList, isSumOrgRelationMap);
        for (DynamicObject accessConfig : accessConfigList) {
            String serialNo = UUID.randomUUID().toString();
            String dataSource = "system";
            String projectcaliberid = "";
            if (accessConfig.getDataEntityType().getName().equalsIgnoreCase("tcvvt_tax_accessconfig")) {
                projectcaliberid = !ObjectUtils.isEmpty((Object)accessConfig.getString(this.projectcaliber)) ? accessConfig.getString(this.projectcaliber) : null;
            }
            RuleFetchDto ruleFetchDto = new RuleFetchDto(ruleEngineDto.getOrgId(), dataSource, serialNo, ruleEngineDto.getSkssqq(), ruleEngineDto.getSkssqz(), accessConfig.getString(this.accessProject), ruleEngineDto.getTemplateType(), projectcaliberid, null);
            List<RuleFetchDetailDto> fetchDetailList = this.getRuleFetchDetailAmount(ruleEngineDto, accessConfig, serialNo, templateNum, accessconfigDatasourceOrgIdsMap);
            ruleFetchDto.getRuleFetchDetailDtoList().addAll(fetchDetailList);
            if (!ObjectUtils.isEmpty(fetchDetailList)) {
                BigDecimal fetchAmount = BigDecimal.ZERO;
                BigDecimal reportingAmount = BigDecimal.ZERO;
                for (RuleFetchDetailDto ruleFetchDetailDto : fetchDetailList) {
                    fetchAmount = fetchAmount.add(ruleFetchDetailDto.getFetchamount());
                    reportingAmount = reportingAmount.add(ruleFetchDetailDto.getReportingamount());
                }
                ruleFetchDto.setFetchamount(this.handleSummaryAmount(accessConfig, fetchAmount));
                ruleFetchDto.setReportingAmount(this.handleSummaryAmount(accessConfig, reportingAmount));
                fetchResultList.add(ruleFetchDto);
            }
            if (!accessConfig.getDataEntityType().getName().equalsIgnoreCase("tcvvt_tax_accessconfig")) continue;
            String serialNoSn = UUID.randomUUID().toString();
            RuleFetchDto ruleFetchDtoSn = new RuleFetchDto(ruleEngineDto.getOrgId(), dataSource, serialNoSn, ruleEngineDto.getSkssqq(), ruleEngineDto.getSkssqz(), accessConfig.getString(this.accessProject), ruleEngineDto.getTemplateType(), projectcaliberid, "sn");
            List<RuleFetchDetailDto> fetchDetailListSn = this.getRuleFetchDetailAmountSn(ruleEngineDto, accessConfig, serialNoSn, templateNum);
            if (ObjectUtils.isEmpty(fetchDetailListSn)) continue;
            BigDecimal fetchAmountSn = BigDecimal.ZERO;
            BigDecimal reportingAmountSn = BigDecimal.ZERO;
            ruleFetchDtoSn.getRuleFetchDetailDtoList().addAll(fetchDetailListSn);
            for (RuleFetchDetailDto ruleFetchDetailDto : fetchDetailListSn) {
                fetchAmountSn = fetchAmountSn.add(ruleFetchDetailDto.getFetchamount());
                reportingAmountSn = reportingAmountSn.add(ruleFetchDetailDto.getReportingamount());
            }
            ruleFetchDtoSn.setFetchamount(this.handleSummaryAmount(accessConfig, fetchAmountSn));
            ruleFetchDtoSn.setReportingAmount(this.handleSummaryAmount(accessConfig, reportingAmountSn));
            fetchResultList.add(ruleFetchDtoSn);
        }
        return fetchResultList;
    }

    @Override
    public List<RuleFetchDetailDto> getRuleFetchDetailAmount(RuleEngineDto ruleEngineDto, DynamicObject accessConfig, String serialNo, String templateNum, Map<Long, Map<Long, List<Long>>> accessconfigDatasourceOrgIdsMap) {
        ArrayList<RuleFetchDetailDto> fetchResultDetailList = new ArrayList<RuleFetchDetailDto>();
        if (ObjectUtils.isEmpty((Object)accessConfig)) {
            return fetchResultDetailList;
        }
        DynamicObjectCollection ruleCollection = accessConfig.getDynamicObjectCollection(this.entryentity);
        if (ObjectUtils.isEmpty((Object)ruleCollection)) {
            return fetchResultDetailList;
        }
        for (DynamicObject ruleRow : ruleCollection) {
            DynamicObject dataSourceObject = ruleRow.getDynamicObject(this.ftable);
            Long tableId = dataSourceObject.getLong("id");
            Long amountfieldId = ruleRow.getDynamicObject(this.amountfield).getLong("id");
            String filterconditionS = ruleRow.getString(this.filtercondition);
            String datatypeS = ruleRow.getString(this.datatype);
            String datadirectionS = ruleRow.getString(this.datadirection);
            String biznameS = ruleRow.getString(this.bizname);
            String absoluteS = ruleRow.getString(this.absolute);
            BigDecimal exrateS = ExrateConvertHelper.calcExrate((String)ruleRow.getString(this.exratejson), (Date)ruleEngineDto.getSkssqq(), (Date)ruleEngineDto.getSkssqz());
            if (exrateS.compareTo(BigDecimal.ZERO) == 0) {
                exrateS = null;
            }
            RuleFetchDetailDto ruleFetchDetailDto = new RuleFetchDetailDto(ruleEngineDto.getOrgId(), filterconditionS, tableId, amountfieldId, datatypeS, datadirectionS, biznameS, ruleEngineDto.getSkssqq(), ruleEngineDto.getSkssqz(), accessConfig.getString(this.accessProject), serialNo, absoluteS, ruleEngineDto.getTemplateType(), exrateS);
            Map<Long, List<Long>> map = accessconfigDatasourceOrgIdsMap.get(accessConfig.getLong("id"));
            List<Long> orgList = map.get(tableId);
            BigDecimal sumAmount = this.calculareRuleFetchAmount(ruleEngineDto.getOrgId(), ruleEngineDto.getSkssqq(), ruleEngineDto.getSkssqz(), orgList, ruleRow, "bn");
            BigDecimal reportingamount = exrateS == null ? this.handleDetailAmount(accessConfig, sumAmount, templateNum) : this.handleDetailAmount(accessConfig, sumAmount.multiply(exrateS), templateNum);
            ruleFetchDetailDto.setReportingamount(reportingamount);
            ruleFetchDetailDto.setFetchamount(this.handleDetailAmount(accessConfig, sumAmount, templateNum));
            ruleFetchDetailDto.setFetchtype("bn");
            fetchResultDetailList.add(ruleFetchDetailDto);
        }
        return fetchResultDetailList;
    }

    @Override
    public BigDecimal calculareRuleFetchAmount(Long orgId, Date skssqq, Date skssqz, List<Long> orgList, DynamicObject ruleRow, String fetchType) {
        Map<String, String> fieldMap;
        String org;
        BigDecimal jsblS;
        String datatypeS;
        String datadirectionS;
        Boolean absoluteBoolean;
        String advancedconf;
        String conditionJson;
        String amountFieldEntity;
        String amountFieldName;
        DynamicObject amountFieldObject;
        String subEntityName;
        String entityName;
        Long tableId;
        DynamicObject tableObject;
        List<String> includeSubFilter = Arrays.asList("tdm_finance_main", "tcvat_nsrxx");
        BigDecimal taxRate = null;
        if ("sn".equalsIgnoreCase(fetchType)) {
            tableObject = ruleRow.getDynamicObject(this.ftable1);
            tableId = tableObject.getLong("id");
            entityName = tableObject.getString("name");
            subEntityName = tableObject.getString("subname");
            amountFieldObject = ruleRow.getDynamicObject(this.amountfield1);
            amountFieldName = amountFieldObject.getString("fieldname");
            amountFieldEntity = amountFieldObject.getString("fieldsubname");
            conditionJson = ruleRow.getString(this.conditionjson1);
            advancedconf = ruleRow.getString(this.advancedconfjson1);
            absoluteBoolean = ruleRow.getBoolean(this.absolute1);
            datadirectionS = ruleRow.getString(this.datadirection1);
            datatypeS = ruleRow.getString(this.datatype1);
            jsblS = ruleRow.getBigDecimal(this.jsbl1);
            if (DataType.JSFLQS.getCode().equals(datatypeS) || DataType.CYSLDSQS.getCode().equals(datatypeS) || DataType.SEHSHSJ.getCode().equals(datatypeS)) {
                taxRate = ruleRow.getBigDecimal("vatrate1");
            }
        } else {
            tableObject = ruleRow.getDynamicObject(this.ftable);
            tableId = tableObject.getLong("id");
            entityName = tableObject.getString("name");
            subEntityName = tableObject.getString("subname");
            amountFieldObject = ruleRow.getDynamicObject(this.amountfield);
            amountFieldName = amountFieldObject.getString("fieldname");
            amountFieldEntity = amountFieldObject.getString("fieldsubname");
            conditionJson = ruleRow.getString(this.conditionjson);
            advancedconf = ruleRow.getString(this.advancedconfjson);
            absoluteBoolean = ruleRow.getBoolean(this.absolute);
            datadirectionS = ruleRow.getString(this.datadirection);
            datatypeS = ruleRow.getString(this.datatype);
            jsblS = ruleRow.getBigDecimal(this.jsbl);
            taxRate = null;
            if (DataType.JSFLQS.getCode().equals(datatypeS) || DataType.CYSLDSQS.getCode().equals(datatypeS) || DataType.SEHSHSJ.getCode().equals(datatypeS)) {
                taxRate = ruleRow.getBigDecimal("vatrate");
            }
        }
        List<QFilter> filterList = new ArrayList<QFilter>();
        boolean amountEntityIsSubEntry = true;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        IDataEntityProperty property = mainEntityType.findProperty(amountFieldEntity);
        if (!StringUtils.equalsIgnoreCase((CharSequence)entityName, (CharSequence)amountFieldEntity) && ObjectUtils.isEmpty((Object)property)) {
            amountEntityIsSubEntry = false;
        }
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            if ((entityName.equals("gl_voucher") || entityName.equals("gl_balance")) && conditionJson.contains("assgrp")) {
                conditionJson = RuleFilterConditionService.queryAssgrp((String)conditionJson);
            }
            QFilter qFilters = FilterBuilderUtils.buildFilter(conditionJson, includeSubFilter.contains(entityName) && ObjectUtils.isEmpty((Object)property) ? amountFieldEntity : entityName);
            Map fiBdAccounts = GetGLBalanceCommonUtil.create((Long)orgId);
            if ((qFilters = GetGLBalanceCommonUtil.parseQFilter((Long)orgId, (String)entityName, (QFilter)qFilters, (Map)fiBdAccounts)) != null) {
                filterList.add(qFilters);
            }
        }
        if (!ObjectUtils.isNotEmpty((Object)(org = (fieldMap = RuleFetchUtil.getTableFields(tableId)).get("orgstate")))) {
            return BigDecimal.ZERO;
        }
        filterList.add(new QFilter(org, "in", orgList));
        ImmutablePair<Date, Date> datePair = this.setQueryDateByAdvanceConf(skssqq, skssqz, advancedconf);
        Date newStartdate = (Date)datePair.left;
        Date newEnddate = (Date)datePair.right;
        filterList = this.setFetchDateFilter(newStartdate, newEnddate, tableId, filterList);
        String tableName = entityName;
        String selectAmountField = amountFieldName;
        if (amountEntityIsSubEntry && !StringUtil.equalsIgnoreCase((CharSequence)entityName, (CharSequence)amountFieldEntity)) {
            selectAmountField = amountFieldEntity + "." + amountFieldName;
        } else {
            tableName = amountFieldEntity;
        }
        DynamicObjectCollection accountingList = new DynamicObjectCollection();
        switch (entityName) {
            case "gl_balance": {
                accountingList = QueryServiceHelper.query((String)tableName, (String)selectAmountField, (QFilter[])filterList.toArray(new QFilter[0]));
                break;
            }
            case "tdm_balance_new": {
                List qFilters = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TdmBalanceFilterService", (String)"buildBalanceNewFilter", (Object[])new Object[]{newStartdate, newEnddate, filterList, selectAmountField, null});
                accountingList = QueryServiceHelper.query((String)entityName, (String)selectAmountField, (QFilter[])qFilters.toArray(new QFilter[0]));
                break;
            }
            case "tdm_recording_voucher_new": {
                filterList.add(new QFilter(fieldMap.get("orgstate"), "in", orgList));
                filterList.add(new QFilter("accountyear", "=", (Object)kd.taxc.tcvvt.common.util.DateUtils.format(newEnddate, "yyyy")));
                int monthStart = kd.taxc.tcvvt.common.util.DateUtils.getMonthOfDate(newStartdate);
                int monthEnd = kd.taxc.tcvvt.common.util.DateUtils.getMonthOfDate(newEnddate);
                ArrayList<String> accountperiodList = new ArrayList<String>(2);
                for (int monthInt = monthStart; monthInt <= monthEnd; ++monthInt) {
                    String monthOfFormat = String.format("%02d", monthInt);
                    accountperiodList.add(monthOfFormat);
                }
                filterList.add(new QFilter("accountperiod", "in", accountperiodList));
                accountingList = QueryServiceHelper.query((String)tableName, (String)selectAmountField, (QFilter[])filterList.toArray(new QFilter[0]));
                break;
            }
            case "gl_voucher": {
                filterList.add(new QFilter(fieldMap.get("orgstate"), "in", orgList));
                filterList.add(new QFilter("bookeddate", ">=", (Object)newStartdate));
                filterList.add(new QFilter("bookeddate", "<=", (Object)newEnddate));
                accountingList = QueryServiceHelper.query((String)tableName, (String)selectAmountField, (QFilter[])filterList.toArray(new QFilter[0]));
                break;
            }
            case "tdm_finance_main": 
            case "tcvat_nsrxx": {
                QFilter q;
                QFilter q2;
                if (StringUtil.equalsIgnoreCase((CharSequence)amountFieldEntity, (CharSequence)"bdtaxr_pay_record")) {
                    QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                    QFilter startPaydateQ = new QFilter("paydate", ">=", (Object)newStartdate);
                    QFilter endPaydateQ = new QFilter("paydate", "<=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getDayLast(newEnddate));
                    if (StringUtils.isNotBlank((CharSequence)conditionJson) && StringUtils.isNotBlank((CharSequence)amountFieldEntity) && (q2 = FilterBuilderUtils.buildFilter(conditionJson, amountFieldEntity)) != null) {
                        orgFilter = orgFilter.and(q2);
                    }
                    orgFilter.and(startPaydateQ).and(endPaydateQ);
                    accountingList = QueryServiceHelper.query((String)tableName, (String)selectAmountField, (QFilter[])new QFilter[]{orgFilter});
                    break;
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)amountFieldEntity, (CharSequence)"tcret_ccxws_zb_hb")) {
                    QFilter rangeQFilter = new QFilter("enddate", ">=", (Object)newStartdate).and("enddate", "<=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getDayLast(newEnddate));
                    QFilter skssqzFilter = new QFilter("enddate", "=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getDayFirst(newEnddate)).or("enddate", "=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getDayLast(newEnddate));
                    skssqzFilter.or(rangeQFilter);
                    QFilter sbbIdsQ = QFilter.isNotNull((String)"sbbid");
                    if (StringUtils.isNotBlank((CharSequence)conditionJson) && StringUtils.isNotBlank((CharSequence)amountFieldEntity) && (q2 = FilterBuilderUtils.buildFilter(conditionJson, amountFieldEntity)) != null) {
                        skssqzFilter.and(q2);
                        sbbIdsQ.and(q2);
                    }
                    DynamicObjectCollection ccxwsCollection = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"sbbid", (QFilter[])new QFilter[]{skssqzFilter});
                    Set ccxwsIdSet = ccxwsCollection.stream().map(o -> o.getLong("sbbid")).collect(Collectors.toSet());
                    QFilter orgQ = new QFilter("org", "=", (Object)orgId);
                    QFilter nsrxxIdsQ = new QFilter("id", "in", ccxwsIdSet);
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{orgQ, nsrxxIdsQ});
                    List nsrxxIdsList = collection.stream().map(o -> o.getString("id")).collect(Collectors.toList());
                    sbbIdsQ.and(new QFilter("sbbid", "in", nsrxxIdsList));
                    accountingList = QueryServiceHelper.query((String)tableName, (String)selectAmountField, (QFilter[])new QFilter[]{sbbIdsQ, skssqzFilter});
                    break;
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)tableName, (CharSequence)"tcvat_nsrxx")) {
                    accountingList = QueryServiceHelper.query((String)tableName, (String)selectAmountField, (QFilter[])filterList.toArray(new QFilter[0]));
                    break;
                }
                List<String> sbbids = this.getSbbIds(orgId, orgList, newStartdate, newEnddate, fieldMap, entityName);
                QFilter filter = new QFilter("sbbid", "in", sbbids);
                if (StringUtils.isNotBlank((CharSequence)conditionJson) && StringUtils.isNotBlank((CharSequence)amountFieldEntity) && (q = FilterBuilderUtils.buildFilter(conditionJson, amountFieldEntity)) != null) {
                    filter = filter.and(q);
                }
                accountingList = QueryServiceHelper.query((String)tableName, (String)selectAmountField, (QFilter[])new QFilter[]{filter});
                break;
            }
            case "tdm_finance_hblrbfilter": 
            case "tdm_finance_hbzcfzbfilter": 
            case "tdm_finance_lrbfilter": 
            case "tdm_finance_syzqybdfilter": 
            case "tdm_finance_xjllbfilter": 
            case "tdm_finance_zcfzbfilter": {
                Long categoty = null;
                BigDecimal sumAmount = CustomSourceFactory.getInstance().queryBizDataRetSum(orgId, skssqq, skssqz, tableId, amountFieldName, entityName, conditionJson, advancedconf, categoty);
                return this.convertFetchAmount(sumAmount, absoluteBoolean, datadirectionS, datatypeS, taxRate, jsblS);
            }
            default: {
                accountingList = QueryServiceHelper.query((String)tableName, (String)selectAmountField, (QFilter[])filterList.toArray(new QFilter[0]));
            }
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject dyo : accountingList) {
            sumAmount = sumAmount.add(dyo.getBigDecimal(selectAmountField));
        }
        sumAmount = this.convertFetchAmount(sumAmount, absoluteBoolean, datadirectionS, datatypeS, taxRate, jsblS);
        return sumAmount;
    }

    @Override
    public List<Long> getOrgListByRelation(List<Long> orgList, Date skssqq, Date skssqz, DynamicObject dataSourceObject) {
        Long tableId = dataSourceObject.getLong("id");
        String entryName = dataSourceObject.getString("name");
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(orgList, (Date)skssqq, (Date)skssqz);
        Map<String, String> fieldMap = RuleFetchUtil.getTableFields(tableId);
        String org = fieldMap.get("orgstate");
        if (null != org) {
            String entityKey = entryName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            orgList = EngineCalcFilterService.getOrgListByRelation((Map)orgRelationMap, orgList, (String)entryName, (String)entityKey, (String)orgFieldName);
        }
        return orgList;
    }

    @Override
    public ImmutablePair<Date, Date> setQueryDateByAdvanceConf(Date startdate, Date enddate, String advancedconf) {
        Date target;
        if (advancedconf.equals(RuleConfigEnum.CUMULATIVE.getRuleConfigCode())) {
            startdate = kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfYear(startdate);
        }
        if (advancedconf.equals(RuleConfigEnum.TOBEGIN.getRuleConfigCode())) {
            startdate = kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfMonth(startdate);
            enddate = kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfMonth(startdate);
        }
        if (advancedconf.equals(RuleConfigEnum.TOEND.getRuleConfigCode())) {
            startdate = kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfMonth(enddate);
            enddate = kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfMonth(enddate);
        }
        if (advancedconf.equals(RuleConfigEnum.SQQMS.getRuleConfigCode())) {
            startdate = kd.taxc.tcvvt.common.util.DateUtils.addMonth(startdate, -1);
            enddate = kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfMonth(startdate);
        }
        if (advancedconf.equals(RuleConfigEnum.SNLJS.getRuleConfigCode())) {
            Date tempStartDate = startdate;
            startdate = kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfYear(kd.taxc.tcvvt.common.util.DateUtils.addYear(startdate, -1));
            enddate = kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfYear(kd.taxc.tcvvt.common.util.DateUtils.addYear(tempStartDate, -1));
        }
        if (advancedconf.equals(RuleConfigEnum.SNXQS.getRuleConfigCode())) {
            target = kd.taxc.tcvvt.common.util.DateUtils.addMonth(startdate, -11);
            startdate = kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfMonth(target);
            enddate = kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfMonth(target);
        }
        if (advancedconf.equals(RuleConfigEnum.SNTQS.getRuleConfigCode())) {
            target = kd.taxc.tcvvt.common.util.DateUtils.addMonth(startdate, -12);
            startdate = kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfMonth(target);
            enddate = kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfMonth(target);
        }
        if (advancedconf.equals(RuleConfigEnum.SNXXQS.getRuleConfigCode())) {
            int monthOffSet = DateUtils.getMonthSpan((Date)startdate, (Date)enddate);
            Date target2 = kd.taxc.tcvvt.common.util.DateUtils.addMonth(startdate, -12 + monthOffSet * 2);
            startdate = kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfMonth(target2);
            enddate = kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfMonth(target2);
        }
        if (advancedconf.equals(RuleConfigEnum.SNZHQS.getRuleConfigCode())) {
            if (DateUtils.isSameDay((Date)startdate, (Date)enddate)) {
                Date lastYear = DateUtils.addTime((Date)startdate, (int)-1, (int)0, (int)0);
                Date lastYearLastDay = DateUtils.getLastDateOfYear((Date)lastYear);
                startdate = DateUtils.getDayFirst((Date)lastYearLastDay);
                enddate = DateUtils.getDayLast((Date)lastYearLastDay);
            } else {
                int monthOffSet = DateUtils.getMonthSpan((Date)startdate, (Date)enddate);
                enddate = DateUtils.addMonth((Date)enddate, (int)-12);
                enddate = DateUtils.getLastDateOfYear((Date)enddate);
                enddate = DateUtils.getLastDateOfMonth((Date)enddate);
                startdate = DateUtils.addMonth((Date)enddate, (int)(-monthOffSet + 1));
                startdate = DateUtils.getFirstDateOfMonth((Date)startdate);
            }
        }
        return ImmutablePair.of((Object)startdate, (Object)enddate);
    }

    @Override
    public List<QFilter> setFetchDateFilter(Date startdate, Date enddate, Long tableId, List<QFilter> filterList) {
        Map<String, String> fieldMap = RuleFetchUtil.getTableFields(tableId);
        String dateField = fieldMap.get("datastate");
        logger.info("\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}#", (Object)kd.taxc.tcvvt.common.util.DateUtils.format(startdate), (Object)kd.taxc.tcvvt.common.util.DateUtils.format(enddate));
        if (StringUtil.isNotEmpty((CharSequence)dateField)) {
            QFilter startFilter = new QFilter(dateField, ">=", (Object)startdate);
            QFilter endFilter = new QFilter(dateField, "<=", (Object)enddate);
            filterList.add(startFilter);
            filterList.add(endFilter);
            return filterList;
        }
        return this.setYearMonthFilter(startdate, enddate, fieldMap, filterList);
    }

    protected BigDecimal convertFetchAmount(BigDecimal sumAmount, Boolean absolute, String datadirection, String datatype, BigDecimal taxrate, BigDecimal jsblS) {
        BigDecimal resultAmount = BigDecimal.ZERO;
        BigDecimal numAfterPositive = absolute != false ? sumAmount.abs() : sumAmount;
        BigDecimal reverse = new BigDecimal(-1);
        BigDecimal bigDecimal = resultAmount = "positive".equalsIgnoreCase(datadirection) ? numAfterPositive : numAfterPositive.multiply(reverse);
        if (taxrate != null) {
            if (DataType.JSFLQS.getCode().equals(datatype)) {
                resultAmount = resultAmount.divide(BigDecimal.ONE.add(taxrate), 2, RoundingMode.HALF_UP);
            } else if (DataType.CYSLDSQS.getCode().equals(datatype)) {
                if (taxrate.compareTo(BigDecimal.ZERO) != 0) {
                    resultAmount = resultAmount.divide(taxrate, 2, RoundingMode.HALF_UP);
                }
            } else if (DataType.SEHSHSJ.getCode().equals(datatype) && taxrate.compareTo(BigDecimal.ZERO) != 0) {
                resultAmount = resultAmount.divide(taxrate, 2, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.add(taxrate));
            }
        }
        if (jsblS != null) {
            resultAmount = resultAmount.multiply(BigDecimal.ZERO.add(jsblS));
        }
        return resultAmount;
    }

    public abstract BigDecimal handleDetailAmount(DynamicObject var1, BigDecimal var2, String var3);

    public abstract BigDecimal handleSummaryAmount(DynamicObject var1, BigDecimal var2);

    private List<QFilter> setYearMonthFilter(Date startDate, Date endDate, Map<String, String> fieldMap, List<QFilter> filterList) {
        String entityName = fieldMap.get("entity");
        String yearField = fieldMap.get("yearstate");
        String monthField = fieldMap.get("monthstate");
        int startYear = kd.taxc.tcvvt.common.util.DateUtils.getYearOfDate(startDate);
        int endYear = kd.taxc.tcvvt.common.util.DateUtils.getYearOfDate(endDate);
        int startMonth = kd.taxc.tcvvt.common.util.DateUtils.getMonthOfDate(startDate);
        int endMonth = kd.taxc.tcvvt.common.util.DateUtils.getMonthOfDate(endDate);
        boolean hasYear = StringUtil.isNotEmpty((CharSequence)yearField);
        boolean hasMonth = StringUtil.isNotEmpty((CharSequence)monthField);
        boolean yearFieldIsDateType = false;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = mainEntityType.getProperty(yearField);
        if (dynamicProperty instanceof DateTimeProp) {
            yearFieldIsDateType = true;
        }
        if (hasYear && hasMonth) {
            QFilter finalFilter = null;
            for (int year = startYear; year <= endYear; ++year) {
                QFilter qFilter = null;
                if (yearFieldIsDateType) {
                    QFilter q1 = new QFilter(yearField, ">=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfYear(startDate));
                    QFilter q2 = new QFilter(yearField, "<=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfYear(startDate));
                    qFilter = q1.and(q2);
                } else {
                    qFilter = new QFilter(yearField, "=", (Object)String.valueOf(year));
                }
                List<String> diffMonth = this.getDiffMonth(year == startYear ? startMonth : 1, year == endYear ? endMonth : 12);
                qFilter.and(new QFilter(monthField, "in", diffMonth));
                if (finalFilter == null) {
                    finalFilter = qFilter;
                    continue;
                }
                finalFilter.or(qFilter);
            }
            filterList.add(finalFilter);
        } else if (hasYear && !hasMonth) {
            QFilter qFilter = null;
            if (yearFieldIsDateType) {
                QFilter q1 = new QFilter(yearField, ">=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getFirstDateOfYear(startDate));
                QFilter q2 = new QFilter(yearField, "<=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getLastDateOfYear(startDate));
                qFilter = q1.and(q2);
            } else {
                qFilter = new QFilter(yearField, "=", (Object)String.valueOf(startYear));
            }
            for (int year = startYear + 1; year <= endYear; ++year) {
                qFilter.or(new QFilter(yearField, "=", (Object)String.valueOf(year)));
            }
            filterList.add(qFilter);
        } else if (!hasYear && hasMonth) {
            List<String> diffMonth = this.getDiffMonth(startMonth, endMonth);
            QFilter qFilter = new QFilter(monthField, "in", diffMonth);
            filterList.add(qFilter);
        }
        return filterList;
    }

    private List<String> getDiffMonth(int lessMonth, int largeMonth) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = lessMonth; i <= largeMonth; ++i) {
            if (i < 10) {
                strings.add("" + i);
                strings.add("0" + i);
            }
            strings.add(String.valueOf(i));
        }
        return strings;
    }

    private List<String> getSbbIds(Long orgId, List<Long> orgList, Date startDate, Date endDate, Map<String, String> fieldMap, String entryName) {
        ArrayList<String> sbbIds = new ArrayList(16);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter rangeQFilter = new QFilter("skssqz", ">=", (Object)startDate).and("skssqz", "<=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getDayLast(endDate));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getDayFirst(endDate)).or("skssqz", "=", (Object)kd.taxc.tcvvt.common.util.DateUtils.getDayLast(endDate));
        skssqzFilter.or(rangeQFilter);
        if (StringUtil.equalsIgnoreCase((CharSequence)entryName, (CharSequence)"tdm_finance_main")) {
            orgFilter = new QFilter("org", "in", orgList);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entryName, (String)"id", (QFilter[])new QFilter[]{orgFilter, skssqzFilter});
        sbbIds = collection.stream().map(o -> o.getString("id")).collect(Collectors.toList());
        return sbbIds;
    }

    @Override
    public List<RuleFetchDetailDto> getRuleFetchDetailAmountSn(RuleEngineDto ruleEngineDto, DynamicObject accessConfig, String serialNo, String templateNum) {
        Long orgId = ruleEngineDto.getOrgId();
        Date skssqq = ruleEngineDto.getSkssqq();
        Date skssqz = ruleEngineDto.getSkssqz();
        ArrayList<RuleFetchDetailDto> fetchResultDetailList = new ArrayList<RuleFetchDetailDto>();
        if (ObjectUtils.isEmpty((Object)accessConfig)) {
            return fetchResultDetailList;
        }
        DynamicObjectCollection ruleCollection = accessConfig.getDynamicObjectCollection(this.entryentity1);
        if (ObjectUtils.isEmpty((Object)ruleCollection)) {
            return fetchResultDetailList;
        }
        for (DynamicObject ruleRow : ruleCollection) {
            DynamicObject dataSourceObject = ruleRow.getDynamicObject(this.ftable1);
            Long tableId = dataSourceObject.getLong("id");
            Long amountfieldId = ruleRow.getDynamicObject(this.amountfield1).getLong("id");
            String filterconditionS = ruleRow.getString(this.filtercondition1);
            String datatypeS = ruleRow.getString(this.datatype1);
            String datadirectionS = ruleRow.getString(this.datadirection1);
            String biznameS = ruleRow.getString(this.bizname1);
            String absoluteS = ruleRow.getString(this.absolute1);
            BigDecimal exrateS = ExrateConvertHelper.calcExrate((String)ruleRow.getString(this.exratejson1), (Date)ruleEngineDto.getSkssqq(), (Date)ruleEngineDto.getSkssqz());
            if (exrateS.compareTo(BigDecimal.ZERO) == 0) {
                exrateS = null;
            }
            RuleFetchDetailDto ruleFetchDetailDto = new RuleFetchDetailDto(ruleEngineDto.getOrgId(), filterconditionS, tableId, amountfieldId, datatypeS, datadirectionS, biznameS, ruleEngineDto.getSkssqq(), ruleEngineDto.getSkssqz(), accessConfig.getString(this.accessProject), serialNo, absoluteS, ruleEngineDto.getTemplateType(), exrateS);
            List<Long> orgList = this.getOrgListByRelation(Collections.singletonList(orgId), skssqq, skssqz, dataSourceObject);
            BigDecimal sumAmount = this.calculareRuleFetchAmount(ruleEngineDto.getOrgId(), ruleEngineDto.getSkssqq(), ruleEngineDto.getSkssqz(), orgList, ruleRow, "sn");
            BigDecimal reportingamount = exrateS == null ? this.handleDetailAmount(accessConfig, sumAmount, templateNum) : this.handleDetailAmount(accessConfig, sumAmount.multiply(exrateS), templateNum);
            ruleFetchDetailDto.setReportingamount(reportingamount);
            ruleFetchDetailDto.setFetchamount(this.handleDetailAmount(accessConfig, sumAmount, templateNum));
            ruleFetchDetailDto.setFetchtype("sn");
            fetchResultDetailList.add(ruleFetchDetailDto);
        }
        return fetchResultDetailList;
    }

    private Set<Long> queryGroupTaxOrgList(Long orgId) {
        HashSet<Long> result = new HashSet<Long>(8);
        Date start = kd.taxc.tcvvt.common.util.DateUtils.getDayFirst(new Date());
        QFilter statueQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter nsrmcQ = new QFilter("nsrmc", "=", (Object)orgId);
        QFilter dateQ = QFilter.isNull((String)"enddate").and(new QFilter("startdate", "<=", (Object)start)).or(QFilter.isNotNull((String)"enddate").and(new QFilter("startdate", "<=", (Object)start).and(new QFilter("enddate", ">=", (Object)start))));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvvt_group", (String)"jt_mc", (QFilter[])new QFilter[]{statueQ, nsrmcQ, dateQ});
        Set set = collection.stream().map(o -> o.getLong("jt_mc")).collect(Collectors.toSet());
        QFilter jtmcFilter = new QFilter("jt_mc", "in", set);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tcvvt_group", (String)"nsrmc,sjnsrmc", (QFilter[])new QFilter[]{statueQ, jtmcFilter, dateQ});
        Set set1 = dynamicObjectCollection.stream().map(o -> o.getLong("nsrmc")).collect(Collectors.toSet());
        result.addAll(set1);
        return result;
    }

    private Map<String, List<Long>> getIsSumOrgRelationMap(RuleEngineDto ruleEngineDto) {
        Long orgId = ruleEngineDto.getOrgId();
        Date skssqq = ruleEngineDto.getSkssqq();
        Date skssqz = ruleEngineDto.getSkssqz();
        ArrayList<Long> orgIdList = new ArrayList<Long>(this.queryGroupTaxOrgList(orgId));
        HashMap<String, List<Long>> sumAndRelationMap = new HashMap<String, List<Long>>(16);
        List isSumAndIsRelationList = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(orgIdList, (Date)skssqq, (Date)skssqz);
        HashSet isSumAndIsRelationSet = new HashSet(isSumAndIsRelationList);
        isSumAndIsRelationList.clear();
        isSumAndIsRelationList.addAll(isSumAndIsRelationSet);
        ArrayList<Long> isSumAndNoRelationList = orgIdList;
        List noSumAndIsRelationList = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(orgId), (Date)skssqq, (Date)skssqz);
        HashSet noSumAndIsRelationSet = new HashSet(noSumAndIsRelationList);
        noSumAndIsRelationList.clear();
        noSumAndIsRelationList.addAll(noSumAndIsRelationSet);
        List<Long> noSumAndNoRelationList = Collections.singletonList(orgId);
        sumAndRelationMap.put("isSumAndIsRelation", isSumAndIsRelationList);
        sumAndRelationMap.put("isSumAndNoRelation", isSumAndNoRelationList);
        sumAndRelationMap.put("noSumAndIsRelation", noSumAndIsRelationList);
        sumAndRelationMap.put("noSumAndNoRelation", noSumAndNoRelationList);
        return sumAndRelationMap;
    }

    public List<Long> getRelationOrgList(DynamicObject dataSourceObject, Boolean isSummury, Map<String, List<Long>> isSumOrgRelationMap) {
        List<Object> resultOrgList = new ArrayList(16);
        boolean isRelationOrg = false;
        Long tableId = dataSourceObject.getLong("id");
        Map<String, String> fieldMap = RuleFetchUtil.getTableFields(tableId);
        String entryName = dataSourceObject.getString("name");
        String org = fieldMap.get("orgstate");
        if (null != org) {
            String orgFun;
            String entityKey = entryName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            if (Objects.requireNonNull(orgFun = MetadataUtil.getOrgFun((String)entryName, (String)entityKey, (String)orgFieldName)).equalsIgnoreCase(OrgFuncEnum.ACCOUNT.getNumber())) {
                isRelationOrg = true;
            }
        }
        if (isSummury.booleanValue() && isRelationOrg) {
            resultOrgList = isSumOrgRelationMap.get("isSumAndIsRelation");
        }
        if (!isSummury.booleanValue() && isRelationOrg) {
            resultOrgList = isSumOrgRelationMap.get("noSumAndIsRelation");
        }
        if (isSummury.booleanValue() && !isRelationOrg) {
            resultOrgList = isSumOrgRelationMap.get("isSumAndNoRelation");
        }
        if (!isSummury.booleanValue() && !isRelationOrg) {
            resultOrgList = isSumOrgRelationMap.get("noSumAndNoRelation");
        }
        return resultOrgList;
    }

    @Override
    public Map<Long, Map<Long, List<Long>>> getAccessconfigDatasourceOrgIdsMap(List<DynamicObject> accessConfigList, Map<String, List<Long>> isSumOrgRelationMap) {
        HashMap<Long, Map<Long, List<Long>>> accessconfigDatasourceOrgIdsMap = new HashMap<Long, Map<Long, List<Long>>>(512);
        for (DynamicObject accessConfig : accessConfigList) {
            boolean isSummury = false;
            Long accessConfigId = accessConfig.getLong("id");
            DynamicObjectCollection ruleCollection = accessConfig.getDynamicObjectCollection(this.entryentity);
            HashMap map = new HashMap();
            accessconfigDatasourceOrgIdsMap.put(accessConfigId, map);
            for (DynamicObject ruleRow : ruleCollection) {
                DynamicObject dataSourceObject = ruleRow.getDynamicObject(this.ftable);
                List<Long> relationOrgList = this.getRelationOrgList(dataSourceObject, isSummury, isSumOrgRelationMap);
                Map datasourceMap = (Map)accessconfigDatasourceOrgIdsMap.get(accessConfigId);
                datasourceMap.put(dataSourceObject.getLong("id"), relationOrgList);
                accessconfigDatasourceOrgIdsMap.put(accessConfigId, datasourceMap);
            }
        }
        return accessconfigDatasourceOrgIdsMap;
    }
}

