/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.finance;

import com.google.common.collect.Lists;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TcvvtDeclareDataBusinessImpl {
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";

    public static DynamicObject queryDeclareObjBySbbid(Long sbbid) {
        return BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
    }

    public static DynamicObject queryMessageObjByOrgAndDate(Long orgId, Date skssqq, Date skssqz, String nsrtype, String templateid) {
        QFilter orgQ = new QFilter("orgid", "=", (Object)orgId);
        QFilter startFilter = new QFilter("startdate", "=", (Object)skssqq);
        QFilter endFilter = new QFilter("enddate", "=", (Object)skssqz);
        QFilter nsrtypeQ = new QFilter("type", "=", (Object)nsrtype);
        QFilter templateidQ = new QFilter("templateid", "=", (Object)templateid);
        return BusinessDataServiceHelper.loadSingle((String)"tcvvt_message", (QFilter[])new QFilter[]{orgQ, startFilter, endFilter, nsrtypeQ, templateidQ});
    }

    public static DynamicObject queryTemplateNumberByTemplateId(String templateId) {
        QFilter templateNumebrQ = new QFilter("id", "=", (Object)Long.parseLong(templateId));
        return QueryServiceHelper.queryOne((String)"bdtaxr_template_main", (String)"number", (QFilter[])new QFilter[]{templateNumebrQ});
    }

    public static DynamicObjectCollection queryCheckReportByTemplateNumebr(String templateNumebr) {
        QFilter templateNumebrQ = new QFilter("type", "=", (Object)templateNumebr);
        return QueryServiceHelper.query((String)"tcvvt_check_report", (String)"id, mainname", (QFilter[])new QFilter[]{templateNumebrQ});
    }

    public static Boolean queryReportIntersection(String orgId, String reporttype, Date startDate, Date endDate) {
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        boolean exists = false;
        QFilter typeFilter = new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{"FR0001", "FR0002", "FR0003", "FR0004", "FR0011"}));
        if ("aysb".equalsIgnoreCase(reporttype)) {
            QFilter taxLimitFilter = new QFilter("taxlimit", "=", (Object)"season");
            QFilter skssqqzFilter = new QFilter(SKSSQQ, "<=", (Object)startDate).and(new QFilter(SKSSQZ, ">=", (Object)startDate));
            exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgIdFilter, typeFilter, taxLimitFilter, skssqqzFilter});
        } else if ("ajsb".equalsIgnoreCase(reporttype)) {
            QFilter taxLimitFilter = new QFilter("taxlimit", "=", (Object)"month");
            QFilter skssqqzFilter = new QFilter(SKSSQQ, ">=", (Object)startDate).and(new QFilter(SKSSQZ, "<=", (Object)endDate));
            exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgIdFilter, typeFilter, taxLimitFilter, skssqqzFilter});
        }
        return exists;
    }

    public static DynamicObject queryAttachmentIdsBySbbid(Long sbbid) {
        return BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
    }
}

