/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.finance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.login.utils.LoginUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.db.DBSaveUtils;
import kd.taxc.bdtaxr.common.db.MapToTableUtils;
import kd.taxc.bdtaxr.common.db.NewObjectUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvvt.common.enums.TcvvtInitReportDataEnum;
import org.apache.commons.lang3.ObjectUtils;

public class TcvvtInitReportDataBusinessImpl {
    private static final String EWBLXH = "ewblxh";
    private static final String EWBLNAME = "ewblname";
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";

    public static String saveTcvvtFinanceBureauData(Long orgId, String startDate, String endDate, String templateNum, String data) {
        String mainId = "";
        LoginUtils.logger.info("=====================data===================" + data);
        LoginUtils.logger.info("=====================\u7a0e\u5c40\u4e0b\u8f7d\u7533\u62a5\u8868\u5f00\u59cb===================");
        if (StringUtil.isNotBlank((CharSequence)data)) {
            LoginUtils.logger.info("=====================\u66ff\u6362\u6210\u7a0e\u5c40\u7248\u4e2d\u95f4\u8868\u7684\u62a5\u6587\u683c\u5f0f\u6570\u636e===================");
            String tempJsonData = TcvvtInitReportDataBusinessImpl.replaceTableName(data, templateNum);
            Map newMaps = (Map)JsonUtil.fromJson((String)tempJsonData, Map.class);
            if (ObjectUtils.isEmpty((Object)newMaps)) {
                LoginUtils.logger.info("=====================newMaps\u6570\u636e\u4e3a\u7a7a===================" + newMaps);
                return mainId;
            }
            Map<String, String> tableMap = TcvvtInitReportDataBusinessImpl.getTableMap(templateNum);
            LoginUtils.logger.info("=====================\u65b0\u589e\u6216\u8986\u76d6\u5df2\u6709\u7684\u6570\u636e===================");
            mainId = (String)newMaps.get(NewObjectUtils.getIdByKey((String)"tcvat_nsrxx"));
            TcvvtInitReportDataBusinessImpl.removeTables(newMaps, templateNum);
            LoginUtils.logger.info("=====================\u5c06newMaps\u8f6c\u6210\u5b9e\u4f53\u4fdd\u5b58\u5bf9\u8c61===================");
            Map newDbMap = MapToTableUtils.mapToTable((String)"tcvat_nsrxx", (String)mainId, (Map)newMaps, tableMap);
            List<String> rangeList = TcvvtInitReportDataBusinessImpl.targetTableNamesList(templateNum);
            newDbMap.keySet().removeIf(entry -> !rangeList.contains(entry));
            for (Map.Entry d : newDbMap.entrySet()) {
                String entityName = (String)d.getKey();
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
                ComboProp comboProp = (ComboProp)mainEntityType.getAllFields().get(EWBLXH);
                if (null == comboProp) continue;
                ArrayList amountFieldList = new ArrayList();
                for (Map.Entry entry2 : mainEntityType.getAllFields().entrySet()) {
                    if (!(entry2.getValue() instanceof DecimalProp)) continue;
                    amountFieldList.add(entry2.getKey());
                }
                HashMap ewblxhNameMap = new HashMap();
                comboProp.getComboItems().stream().forEach(row -> ewblxhNameMap.put(row.getValue(), row.getName().getLocaleValue()));
                Date skssqq = StringUtil.isEmpty((CharSequence)startDate) ? null : DateUtils.stringToDate((String)startDate);
                Date skssqz = StringUtil.isEmpty((CharSequence)endDate) ? null : DateUtils.stringToDate((String)endDate);
                LoginUtils.logger.info("=====================\u5148\u6839\u636e\u7ec4\u7ec7+\u6240\u5c5e\u671f\u5220\u9664\u5386\u53f2\u4e0b\u8f7d\u6570\u636e\uff0c\u518d\u63d2\u5165\u65b0\u6570\u636e===================");
                QFilter sbbidFilter = new QFilter(ORG, "=", (Object)orgId);
                QFilter skssqqFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
                QFilter skssqzFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
                DeleteServiceHelper.delete((String)((String)d.getKey()), (QFilter[])new QFilter[]{sbbidFilter, skssqqFilter, skssqzFilter});
                LoginUtils.logger.info("=====================\u5220\u9664\u5386\u53f2\u4e0b\u8f7d\u6570\u636e\u5b8c\u6bd5===================");
                LoginUtils.logger.info("=====================\u4e8c\u7ef4\u8868\u884c\u540d\u79f0\u8d4b\u503c\uff0c\u91d1\u989d\u8f6c\u6362\u5f00\u59cb===================");
                for (DynamicObject obj : (DynamicObjectCollection)d.getValue()) {
                    obj.set(EWBLNAME, ewblxhNameMap.get(obj.getString(EWBLXH)));
                    amountFieldList.stream().forEach(amountField -> obj.set(amountField, (Object)(null == obj.getBigDecimal(amountField) ? BigDecimal.ZERO : obj.getBigDecimal(amountField))));
                    obj.set(ORG, (Object)orgId);
                    obj.set(SKSSQQ, (Object)(null == startDate ? null : DateUtils.stringToDate((String)startDate)));
                    obj.set(SKSSQZ, (Object)(null == endDate ? null : DateUtils.stringToDate((String)endDate)));
                }
                LoginUtils.logger.info("=====================\u4e8c\u7ef4\u8868\u884c\u540d\u79f0\u8d4b\u503c\uff0c\u91d1\u989d\u8f6c\u6362\u7ed3\u675f===================");
            }
            LoginUtils.logger.info("=====================\u5148\u5220\u540e\u63d2\uff0c\u53ea\u7559\u7ec4\u7ec7+\u6240\u5c5e\u671f\u6700\u65b0\u7684\u4e00\u4efd===================");
            if (newDbMap.size() > 0) {
                DBSaveUtils.saveTable((Map)newDbMap);
            }
            LoginUtils.logger.info("=====================\u4fdd\u5b58\u5b8c\u6bd5===================");
        }
        return mainId;
    }

    private static String replaceTableName(String data, String templateNum) {
        for (TcvvtInitReportDataEnum value : TcvvtInitReportDataEnum.values()) {
            if (!templateNum.equalsIgnoreCase(value.getTemplateNum())) continue;
            Map<String, String> sourceTableNamesToTargetTableNamesMap = value.getSourceTableNamesToTargetTableNamesMap();
            for (Map.Entry<String, String> entry : sourceTableNamesToTargetTableNamesMap.entrySet()) {
                data = data.replace(entry.getKey(), entry.getValue());
            }
        }
        return data;
    }

    private static Map<String, String> getTableMap(String templateNum) {
        HashMap<String, String> tableMap = new HashMap<String, String>();
        for (TcvvtInitReportDataEnum value : TcvvtInitReportDataEnum.values()) {
            if (!templateNum.equalsIgnoreCase(value.getTemplateNum())) continue;
            Map<String, String> sourceTableNamesToTargetTableNamesMap = value.getSourceTableNamesToTargetTableNamesMap();
            for (Map.Entry<String, String> entry : sourceTableNamesToTargetTableNamesMap.entrySet()) {
                tableMap.put(entry.getValue(), entry.getValue());
            }
        }
        return tableMap;
    }

    private static void removeTables(Map<String, String> newMaps, String templateNum) {
        Iterator<Map.Entry<String, String>> delIter = newMaps.entrySet().iterator();
        while (delIter.hasNext()) {
            Map.Entry<String, String> entry = delIter.next();
            for (TcvvtInitReportDataEnum value : TcvvtInitReportDataEnum.values()) {
                if (!templateNum.equalsIgnoreCase(value.getTemplateNum())) continue;
                List<String> dontNeedSaveTableNames = value.getDontNeedSaveTableNames();
                for (String dontNeedSaveTableName : dontNeedSaveTableNames) {
                    if (!entry.getKey().contains(dontNeedSaveTableName)) continue;
                    delIter.remove();
                }
            }
        }
    }

    private static List<String> targetTableNamesList(String templateNum) {
        List<String> targetTableNamesList = new ArrayList<String>();
        for (TcvvtInitReportDataEnum value : TcvvtInitReportDataEnum.values()) {
            if (!templateNum.equalsIgnoreCase(value.getTemplateNum())) continue;
            targetTableNamesList = value.getSourceTableNamesToTargetTableNamesMap().values().stream().collect(Collectors.toList());
        }
        return targetTableNamesList;
    }

    public static Boolean queryInitReport(Long org, Date skssqq, Date skssqz, String templatetype) {
        QFilter orgF = new QFilter(ORG, "=", (Object)org);
        QFilter ssqqF = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter ssqzF = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter typeF = new QFilter("type", "=", (Object)templatetype);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcvvt_finance_init_record", (String)"id", (QFilter[])new QFilter[]{orgF, ssqqF, ssqzF, typeF});
        return !ObjectUtils.isEmpty((Object)dynamicObject);
    }

    public static String queryMiddlesbbid(Long org, Date skssqq, Date skssqz, String templatetype) {
        QFilter orgF = new QFilter(ORG, "=", (Object)org);
        QFilter ssqqF = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter ssqzF = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter typeF = new QFilter("type", "=", (Object)templatetype);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcvvt_finance_init_record", (String)"id,sbbid", (QFilter[])new QFilter[]{orgF, ssqqF, ssqzF, typeF});
        return ObjectUtils.isEmpty((Object)dynamicObject) ? "" : dynamicObject.getString("sbbid");
    }
}

