/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.finance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TcvvtLicenseCheckBusinessImpl {
    private static final boolean ISOPENLICENSE = true;

    public static void orgLicenseCheck(String orgId, String appId) {
        if (!ObjectUtils.isEmpty((Object)orgId)) {
            TaxResult license;
            boolean isZeroDeclare = MainReportUtil.isZeroDeclareOrg(orgId);
            if (!(ObjectUtils.isEmpty((Object)orgId) || isZeroDeclare || ObjectUtils.isEmpty((Object)(license = TaxcLicenseCheckDataServiceHelper.check((Long)Long.parseLong(orgId), (String)appId))) || ObjectUtils.isEmpty((Object)license.getData()) || ObjectUtils.isEmpty((Object)license.getCode()) || !license.getCode().equalsIgnoreCase(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode()) || !((Boolean)license.getData()).equals(Boolean.TRUE))) {
                throw new KDBizException(license.getMessage());
            }
        }
    }

    public static Map<Long, Boolean> orgLicenseCheck(List<Long> orgIds, String appId) {
        Map<Long, Object> queryZeroDeclareOrgs;
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(12);
        if (!ObjectUtils.isEmpty(orgIds) && ObjectUtils.isNotEmpty(queryZeroDeclareOrgs = MainReportUtil.queryZeroDeclareOrgs(orgIds))) {
            ArrayList needCheckOrgList = new ArrayList(12);
            Set<Map.Entry<Long, Object>> entries = queryZeroDeclareOrgs.entrySet();
            entries.stream().forEach(o -> {
                if (ObjectUtils.isNotEmpty(o.getValue()) && !((Boolean)o.getValue()).booleanValue()) {
                    needCheckOrgList.add(o.getKey());
                } else {
                    result.put((Long)o.getKey(), false);
                }
            });
            TaxResult mapTaxResult = TaxcLicenseCheckDataServiceHelper.checkBatch(needCheckOrgList, (String)appId);
            if (mapTaxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)mapTaxResult.getData())) {
                result.putAll((Map)mapTaxResult.getData());
            }
        }
        return result;
    }
}

