/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tcvvt.business.SubjectQueryService;
import org.apache.commons.collections4.CollectionUtils;

public class SubjectQueryServiceImpl
implements SubjectQueryService {
    private static SubjectQueryServiceImpl singleton = new SubjectQueryServiceImpl();

    private SubjectQueryServiceImpl() {
    }

    public static SubjectQueryServiceImpl getInstance() {
        return singleton;
    }

    @Override
    public Map<String, DynamicObject> querySubjects(String orgNumber, String nddm) {
        String key = orgNumber + "_" + nddm;
        Map resMap = (Map)this.getLocalMemoryCache().get(key);
        if (null == resMap) {
            HashMap<String, DynamicObject> tempMap = new HashMap<String, DynamicObject>();
            QFilter accountFilter = new QFilter("org.number", "=", (Object)orgNumber).and("nd_dm", "=", (Object)nddm);
            Map result = BusinessDataServiceHelper.loadFromCache((String)"tcvvt_clique_account", (String)"id,org_id,number,year", (QFilter[])new QFilter[]{accountFilter});
            result.forEach((k, v) -> tempMap.put(key + "_" + v.getString("number"), (DynamicObject)v));
            this.getLocalMemoryCache().put(key, tempMap);
            return tempMap;
        }
        return resMap;
    }

    @Override
    public DynamicObject querySubject(String orgNumber, String nddm, String number) {
        Map<String, DynamicObject> map = SubjectQueryServiceImpl.getInstance().querySubjects(orgNumber, nddm);
        if (!map.containsKey(orgNumber + "_" + nddm)) {
            QFilter accountFilter = new QFilter("org.number", "=", (Object)orgNumber).and("nd_dm", "=", (Object)nddm);
            Map result = BusinessDataServiceHelper.loadFromCache((String)"tcvvt_clique_account", (String)"id,org_id,number,year", (QFilter[])new QFilter[]{accountFilter});
            result.forEach((k, v) -> map.put(orgNumber + "_" + nddm + "_" + v.getString("number"), (DynamicObject)v));
            this.getLocalMemoryCache().put(orgNumber + "_" + nddm, map);
        }
        String key = orgNumber + "_" + nddm + "_" + number;
        return map.get(key);
    }

    @Override
    public void removeCache(String orgNumber, String nddm, String number) {
        String key = orgNumber + "_" + nddm + "_" + number;
        this.getLocalMemoryCache().remove(new String[]{key});
    }

    @Override
    public void removeCache(List<String> keys) {
        if (CollectionUtils.isNotEmpty(keys)) {
            this.getLocalMemoryCache().remove(keys.toArray(new String[keys.size()]));
        }
    }

    public LocalMemoryCache getLocalMemoryCache() {
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(500000);
        localConfig.setTimeout(3600);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("tcvvt_subject", "subjectNumber", localConfig);
    }
}

