/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.monthly;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.helper.ExrateConvertHelper;
import kd.taxc.tcvvt.business.rulefetch.RuleFetchBusinessImpl;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleEngineDto;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleFetchDetailDto;
import org.apache.commons.lang3.ObjectUtils;

public class MounthlyRuleFetchBusinessImpl
extends RuleFetchBusinessImpl {
    private static final String ACCESS_ISSUMMURY = "issummury";

    @Override
    public List<RuleFetchDetailDto> getRuleFetchDetailAmount(RuleEngineDto ruleEngineDto, DynamicObject accessConfig, String serialNo, String templatenum, Map<Long, Map<Long, List<Long>>> accessconfigDatasourceOrgIdsMap) {
        ArrayList<RuleFetchDetailDto> fetchResultDetailList = new ArrayList<RuleFetchDetailDto>();
        if (ObjectUtils.isEmpty((Object)accessConfig)) {
            return fetchResultDetailList;
        }
        DynamicObjectCollection ruleCollection = accessConfig.getDynamicObjectCollection(this.entryentity);
        if (ObjectUtils.isEmpty((Object)ruleCollection)) {
            return fetchResultDetailList;
        }
        boolean isSummury = accessConfig.getBoolean(ACCESS_ISSUMMURY);
        for (DynamicObject ruleRow : ruleCollection) {
            BigDecimal reportingamount;
            DynamicObject dataSourceObject = ruleRow.getDynamicObject(this.ftable);
            Long tableId = dataSourceObject.getLong("id");
            Long amountfieldId = ruleRow.getDynamicObject(this.amountfield).getLong("id");
            String filterconditionS = ruleRow.getString(this.filtercondition);
            String datatypeS = ruleRow.getString(this.datatype);
            String datadirectionS = ruleRow.getString(this.datadirection);
            String biznameS = ruleRow.getString(this.bizname);
            String absoluteS = ruleRow.getString(this.absolute);
            BigDecimal exrateS = ExrateConvertHelper.calcExrate((String)ruleRow.getString(this.exratejson), (Date)ruleEngineDto.getSkssqq(), (Date)ruleEngineDto.getSkssqz());
            if (exrateS.equals(BigDecimal.ZERO)) {
                exrateS = null;
            }
            RuleFetchDetailDto ruleFetchDetailDto = new RuleFetchDetailDto(ruleEngineDto.getOrgId(), filterconditionS, tableId, amountfieldId, datatypeS, datadirectionS, biznameS, ruleEngineDto.getSkssqq(), ruleEngineDto.getSkssqz(), accessConfig.getString(this.accessProject), serialNo, absoluteS, ruleEngineDto.getTemplateType(), exrateS);
            Map<Long, List<Long>> map = accessconfigDatasourceOrgIdsMap.get(accessConfig.getLong("id"));
            List<Long> relationOrgList = map.get(tableId);
            BigDecimal sumAmount = this.calculareRuleFetchAmount(ruleEngineDto.getOrgId(), ruleEngineDto.getSkssqq(), ruleEngineDto.getSkssqz(), relationOrgList, ruleRow, null);
            BigDecimal bigDecimal = reportingamount = exrateS == null ? this.handleDetailAmount(accessConfig, sumAmount, templatenum) : this.handleDetailAmount(accessConfig, sumAmount.multiply(exrateS), templatenum);
            if (null == sumAmount) continue;
            ruleFetchDetailDto.setFetchamount(this.handleDetailAmount(accessConfig, sumAmount, templatenum));
            ruleFetchDetailDto.setReportingamount(reportingamount);
            fetchResultDetailList.add(ruleFetchDetailDto);
        }
        return fetchResultDetailList;
    }

    @Override
    public BigDecimal handleDetailAmount(DynamicObject accessConfig, BigDecimal fetchDetailAmount, String templatenum) {
        return fetchDetailAmount.divide(new BigDecimal(100000000));
    }

    @Override
    public BigDecimal handleSummaryAmount(DynamicObject accessConfig, BigDecimal fetchSummaryAmount) {
        return fetchSummaryAmount;
    }

    @Override
    public Map<Long, Map<Long, List<Long>>> getAccessconfigDatasourceOrgIdsMap(List<DynamicObject> accessConfigList, Map<String, List<Long>> isSumOrgRelationMap) {
        HashMap<Long, Map<Long, List<Long>>> accessconfigDatasourceOrgIdsMap = new HashMap<Long, Map<Long, List<Long>>>(512);
        for (DynamicObject accessConfig : accessConfigList) {
            boolean isSummury = accessConfig.getBoolean(ACCESS_ISSUMMURY);
            Long accessConfigId = accessConfig.getLong("id");
            DynamicObjectCollection ruleCollection = accessConfig.getDynamicObjectCollection(this.entryentity);
            HashMap map = new HashMap();
            accessconfigDatasourceOrgIdsMap.put(accessConfigId, map);
            for (DynamicObject ruleRow : ruleCollection) {
                DynamicObject dataSourceObject = ruleRow.getDynamicObject(this.ftable);
                List<Long> relationOrgList = this.getRelationOrgList(dataSourceObject, isSummury, isSumOrgRelationMap);
                Map datasourceMap = (Map)accessconfigDatasourceOrgIdsMap.get(accessConfigId);
                datasourceMap.put(dataSourceObject.getLong("id"), relationOrgList);
                accessconfigDatasourceOrgIdsMap.put(accessConfigId, datasourceMap);
            }
        }
        return accessconfigDatasourceOrgIdsMap;
    }
}

