/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.qhjt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.tcvvt.common.util.engine.PartitionSaveTask;
import kd.taxc.tcvvt.common.util.threadpools.ThreadPoolsService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class QhjtCommonBusiness {
    private static final Log logger = LogFactory.getLog(QhjtCommonBusiness.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean syncData(Long userId, DynamicObject jtMc) {
        DLock lock = DLock.create((String)"syncOrgData2QHJT");
        try {
            boolean getLock = lock.tryLock();
            if (!getLock) {
                logger.info("\u540c\u6b65\u7a0e\u52a1\u7ec4\u7ec7\u81f3\u5343\u6237\u96c6\u56e2\u672a\u83b7\u53d6\u9501\uff0c\u4e0d\u6267\u884c");
                boolean bl = false;
                return bl;
            }
            QFilter qFilter = new QFilter("taxpayer", "is null", null).or("taxpayer", "=", (Object)"").or("unifiedsocialcode", "is null", null).or("unifiedsocialcode", "=", (Object)"");
            DynamicObjectCollection badDataList = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id,taxpayer,unifiedsocialcode", (QFilter[])new QFilter[]{qFilter});
            List badOrgIds = badDataList.stream().map(m -> m.getLong("org.id")).distinct().collect(Collectors.toList());
            DynamicObject[] allJtmcList = BusinessDataServiceHelper.load((String)"tcvvt_qhjt", (String)"id,number,groupname", (QFilter[])new QFilter[0]);
            Map<Long, DynamicObject> allJtmcListMap = Arrays.stream(allJtmcList).collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> null));
            List<Long> orgIds = QhjtCommonBusiness.queryTaxcMainOrgIdByIsTaxpayer();
            logger.info("\u83b7\u53d6\u6240\u6709\u72b6\u6001\u4e3a\u53ef\u7528\u3001\u7a0e\u6536\u5236\u5ea6=\u4e2d\u56fd\u5927\u9646\u7a0e\u5236\u4e0b\u7eb3\u7a0e\u4e3b\u4f53=\u662f\u3001\u4e14\u5bf9\u5e94\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u5ba1\u6838\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u7a0e\u52a1\u7ec4\u7ec7\u6570\u91cf\u4e3a:{}", (Object)(CollectionUtils.isEmpty(orgIds) ? 0 : orgIds.size()));
            DynamicObject[] groupList = BusinessDataServiceHelper.load((String)"tcvvt_group", (String)MetadataUtil.getAllFieldString((String)"tcvvt_group"), (QFilter[])new QFilter[]{new QFilter("tbsx", "=", (Object)"1")});
            DynamicObject[] taxMainList = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"orgid,orgid.id,orgid.name,registertime,taxationsys", (QFilter[])new QFilter[]{new QFilter("taxationsys", "=", (Object)1L).and(new QFilter("orgid.id", "in", orgIds))});
            Map<Long, DynamicObject> suitableTaxMainInfoMap = Arrays.stream(taxMainList).collect(Collectors.toMap(k -> k.getLong("orgid.id"), v -> v, (v1, v2) -> null));
            DynamicObject[] allTaxMainList = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"orgid,orgid.id,orgid.name,registertime,taxationsys", (QFilter[])new QFilter[]{new QFilter("taxationsys", "=", (Object)1L)});
            List allOrgIds = Arrays.stream(allTaxMainList).map(m -> m.getLong("orgid.id")).distinct().collect(Collectors.toList());
            Pair sysArgs = null;
            if (jtMc == null) {
                Map batchIssyncnszt = SystemParamUtil.getAppParameterBatch((String)"tcvvt", (String)"issyncnszt", allOrgIds);
                Map batchJtmc = SystemParamUtil.getAppParameterBatch((String)"tcvvt", (String)"jtmc", allOrgIds);
                sysArgs = Pair.of((Object)batchIssyncnszt, (Object)batchJtmc);
            }
            Map<Long, DynamicObject> allTaxMainInfoMap = Arrays.stream(allTaxMainList).collect(Collectors.toMap(k -> k.getLong("orgid.id"), v -> v, (v1, v2) -> null));
            Pair finalSysArgs = sysArgs;
            List<DynamicObject> updateList = QhjtCommonBusiness.checkDyoBeforeSaveOrUpdate(Arrays.stream(groupList).filter(m -> !badOrgIds.contains(m.getLong("nsrmc.id"))).map(m -> QhjtCommonBusiness.getUpdateDynamicObject(allJtmcListMap, suitableTaxMainInfoMap, allTaxMainInfoMap, m, jtMc, (Pair<Map<Long, Object>, Map<Long, Object>>)finalSysArgs, userId)).filter(Objects::nonNull).collect(Collectors.toList()));
            List collect = Arrays.stream(groupList).map(m -> m.getLong("nsrmc.id")).distinct().collect(Collectors.toList());
            orgIds.removeAll(collect);
            List<DynamicObject> addList = QhjtCommonBusiness.checkDyoBeforeSaveOrUpdate(orgIds.stream().filter(m -> !badOrgIds.contains(m)).map(m -> QhjtCommonBusiness.getAddDynamicObject(allJtmcListMap, suitableTaxMainInfoMap, jtMc, (Pair<Map<Long, Object>, Map<Long, Object>>)finalSysArgs, m, userId)).filter(Objects::nonNull).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(updateList)) {
                ThreadPoolsService.getInstance().submit(new PartitionSaveTask(updateList));
            }
            if (CollectionUtils.isNotEmpty(addList)) {
                ThreadPoolsService.getInstance().submit(new PartitionSaveTask(addList));
            }
        }
        catch (Exception ex) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error("\u540c\u6b65\u7a0e\u52a1\u7ec4\u7ec7\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return true;
    }

    private static DynamicObject getAddDynamicObject(Map<Long, DynamicObject> allJtmcListMap, Map<Long, DynamicObject> taxMainInfoMap, Object jtMc, Pair<Map<Long, Object>, Map<Long, Object>> sysArgs, Long orgId, Long userId) {
        DynamicObject tatbMainInfo = taxMainInfoMap.get(orgId);
        if (tatbMainInfo == null) {
            return null;
        }
        if (jtMc == null) {
            Pair<Boolean, Object> suitableSyncArgs = QhjtCommonBusiness.getSuitableSyncArgs(orgId, sysArgs);
            if (suitableSyncArgs == null || !((Boolean)suitableSyncArgs.getLeft()).booleanValue() || suitableSyncArgs.getRight() == null) {
                return null;
            }
            jtMc = suitableSyncArgs.getRight();
            if (jtMc instanceof Long) {
                jtMc = allJtmcListMap.get(Long.parseLong(jtMc.toString()));
            }
        }
        DynamicObject data = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvvt_group"));
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)"40", (long)orgId);
        Long parentOrgId = CollectionUtils.isEmpty((Collection)superiorOrgs) ? null : (Long)superiorOrgs.get(0);
        Date now = new Date();
        Date registerTime = tatbMainInfo.getDate("registertime");
        if (registerTime == null) {
            return null;
        }
        DynamicObject org = tatbMainInfo.getDynamicObject("orgid");
        data.set("number", null);
        data.set("name", null);
        data.set("status", (Object)"C");
        data.set("enable", (Object)1);
        data.set("loginaccount", null);
        data.set("nsrmc", (Object)org);
        data.set("username", null);
        data.set("contactno", null);
        data.set("cellphoneno", null);
        data.set("jt_mc", jtMc);
        data.set("sjnsrmc", (Object)parentOrgId);
        data.set("quoofreview", (Object)"1");
        data.set("startdate", (Object)registerTime);
        data.set("enddate", null);
        data.set("tbsx", (Object)true);
        data.set("datasource", (Object)"sjtb");
        data.set("creator", (Object)userId);
        data.set("createtime", (Object)now);
        data.set("modifier", (Object)userId);
        data.set("modifytime", (Object)now);
        data.set("ycsjnsrmc", (Object)parentOrgId);
        data.set("ycnsrmc", (Object)org);
        return data;
    }

    private static DynamicObject getUpdateDynamicObject(Map<Long, DynamicObject> allJtmcListMap, Map<Long, DynamicObject> suitableTaxMainInfoMap, Map<Long, DynamicObject> allTaxMainInfoMap, DynamicObject data, Object jtMc, Pair<Map<Long, Object>, Map<Long, Object>> sysArgs, Long userId) {
        long orgId = data.getLong("nsrmc.id");
        boolean isValid = suitableTaxMainInfoMap.containsKey(orgId);
        Date startdate = data.getDate("startdate");
        Date enddate = data.getDate("enddate");
        Boolean validOfBd = QhjtCommonBusiness.getValid(startdate, enddate);
        if (jtMc == null) {
            Pair<Boolean, Object> suitableSyncArgs = QhjtCommonBusiness.getSuitableSyncArgs(orgId, sysArgs);
            if (suitableSyncArgs == null || !((Boolean)suitableSyncArgs.getLeft()).booleanValue() || suitableSyncArgs.getRight() == null) {
                return null;
            }
            jtMc = suitableSyncArgs.getRight();
            if (jtMc instanceof Long) {
                jtMc = allJtmcListMap.get(Long.parseLong(jtMc.toString()));
            }
        }
        if (allTaxMainInfoMap.get(orgId) == null) {
            return null;
        }
        DynamicObject tctbMainInfo = allTaxMainInfoMap.get(orgId);
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)"40", (long)orgId);
        Long parentOrgId = CollectionUtils.isEmpty((Collection)superiorOrgs) ? null : (Long)superiorOrgs.get(0);
        Date now = new Date();
        Date registerTime = tctbMainInfo.getDate("registertime");
        if (registerTime == null) {
            return null;
        }
        data.set("nsrmc", data.get("nsrmc"));
        data.set("jt_mc", jtMc);
        data.set("sjnsrmc", (Object)parentOrgId);
        data.set("startdate", (Object)registerTime);
        if (!validOfBd.equals(isValid)) {
            if (isValid) {
                data.set("enddate", null);
            } else {
                Date date = DateUtils.addDay((Date)DateUtils.getDayFirst((Date)new Date()), (int)-1);
                if (registerTime.compareTo(date) > 0) {
                    Date newStartDate = DateUtils.addDay((Date)date, (int)-1);
                    data.set("startdate", (Object)newStartDate);
                }
                data.set("enddate", (Object)date);
            }
        }
        data.set("modifier", (Object)userId);
        data.set("modifytime", (Object)now);
        data.set("ycsjnsrmc", (Object)parentOrgId);
        data.set("ycnsrmc", data.get("nsrmc"));
        return data;
    }

    private static Boolean getValid(Date startDate, Date endDate) {
        Date now = DateUtils.getDayFirst((Date)new Date());
        if (startDate != null && now.compareTo(startDate) >= 0) {
            return endDate == null || endDate.compareTo(now) >= 0;
        }
        return false;
    }

    private static List<DynamicObject> checkDyoBeforeSaveOrUpdate(List<DynamicObject> dataEntities) {
        ArrayList<DynamicObject> entityList = new ArrayList<DynamicObject>(12);
        if (CollectionUtils.isEmpty(dataEntities)) {
            return entityList;
        }
        List<Long> finalIdSet = QhjtCommonBusiness.getDisabledOrgList();
        for (DynamicObject entity : dataEntities) {
            DynamicObjectCollection dyoList;
            QFilter filter;
            Long id = entity.getLong("id");
            Date startdate = entity.getDate("startdate");
            Date enddate = entity.getDate("enddate");
            String datasource = entity.getString("datasource");
            DynamicObject dataFromDb = QueryServiceHelper.queryOne((String)"tcvvt_group", (String)"nsrmc.id", (QFilter[])new QFilter[]{new QFilter("id", "=", entity.get("id"))});
            if (enddate != null && startdate.compareTo(enddate) > 0) {
                logger.info("\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u665a\u4e8e\u6709\u6548\u671f\u6b62");
                continue;
            }
            String loginaccount = entity.getString("loginaccount");
            if (StringUtils.isNotEmpty((CharSequence)loginaccount)) {
                filter = new QFilter("loginaccount", "=", (Object)loginaccount);
                if (dataFromDb != null) {
                    QFilter idFilter = new QFilter("id", "!=", (Object)entity.getLong("id"));
                    filter.and(idFilter);
                }
                dyoList = QueryServiceHelper.query((String)"tcvvt_group", (String)"startdate,enddate,id,loginaccount", (QFilter[])new QFilter[]{filter});
                List sameLoginaccountDyoList = entityList.stream().filter(dynamicObject -> loginaccount.equals(dynamicObject.getString("loginaccount")) && !dynamicObject.get("id").equals(id)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(sameLoginaccountDyoList)) {
                    dyoList.addAll(sameLoginaccountDyoList);
                }
                if (QhjtCommonBusiness.check(dyoList, startdate, enddate)) {
                    logger.info("\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u767b\u5f55\u8d26\u53f7\uff0c\u8bf7\u4fee\u6539");
                    continue;
                }
            }
            Long nsrmcId = entity.getLong("nsrmc.id");
            filter = new QFilter("nsrmc", "=", entity.get("nsrmc.id"));
            if (dataFromDb != null) {
                QFilter idFilter = new QFilter("id", "!=", (Object)entity.getLong("id"));
                filter.and(idFilter);
            }
            dyoList = QueryServiceHelper.query((String)"tcvvt_group", (String)"startdate,enddate,id,nsrmc", (QFilter[])new QFilter[]{filter});
            List sameNsrmcDyoList = entityList.stream().filter(dynamicObject -> nsrmcId.compareTo(dynamicObject.getLong("nsrmc.id")) == 0 && !dynamicObject.get("id").equals(id)).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(sameNsrmcDyoList)) {
                dyoList.addAll(sameNsrmcDyoList);
            }
            if (QhjtCommonBusiness.check(dyoList, startdate, enddate)) {
                logger.info("\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7eb3\u7a0e\u4eba\u540d\u79f0\uff0c\u8bf7\u4fee\u6539");
                continue;
            }
            String quoofreview = entity.getString("quoofreview");
            if (!"1".equals(quoofreview) && !"0".equals(quoofreview)) {
                logger.info("\u8bf7\u8f93\u5165\u4f01\u4e1a\u96c6\u56e2\u786e\u8ba4\u60c5\u51b5");
                continue;
            }
            if (finalIdSet.contains(nsrmcId) && dataFromDb == null) {
                logger.info("\u8be5\u7eb3\u7a0e\u4eba\u540d\u79f0\u7ec4\u7ec7\u4e0d\u53ef\u7528");
                continue;
            }
            Long sjnsrmcid = entity.getLong("sjnsrmc.id");
            if (finalIdSet.contains(sjnsrmcid) && dataFromDb == null) {
                logger.info("\u8be5\u4e0a\u7ea7\u4f01\u4e1a\u540d\u79f0\u7ec4\u7ec7\u4e0d\u53ef\u7528");
                continue;
            }
            if ("sjtb".equals(datasource) && dataFromDb != null && nsrmcId.longValue() != dataFromDb.getLong("nsrmc.id")) {
                logger.info("\u6570\u636e\u540c\u6b65\u7c7b\u578b\u7684\u6570\u636e\u4e0d\u80fd\u4fee\u6539\u7a0e\u52a1\u7ec4\u7ec7");
                continue;
            }
            entityList.add(entity);
        }
        return entityList;
    }

    private static List<Long> getDisabledOrgList() {
        QFilter statusFilter = new QFilter("status", "=", (Object)"3");
        QFilter nsQFilter = new QFilter("istaxpayer", "!=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,org.id as orgid", (QFilter[])new QFilter[]{statusFilter.or(nsQFilter)});
        return collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
    }

    private static List<Long> queryTaxcMainOrgIdByIsTaxpayer() {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayer();
        if (!ObjectUtils.isEmpty((Object)taxResult) && taxResult.isSuccess() && !ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    private static Pair<Boolean, Object> getSuitableSyncArgs(Long orgId, Pair<Map<Long, Object>, Map<Long, Object>> sysArgs) {
        Object idStr;
        Map jtmcMap;
        Map left = (Map)sysArgs.getLeft();
        Map right = (Map)sysArgs.getRight();
        if (!left.containsKey(orgId) || left.get(orgId) == null || !right.containsKey(orgId) || right.get(orgId) == null) {
            return null;
        }
        Object issyncnszt = left.get(orgId);
        Object jtmc = right.get(orgId);
        Boolean leftValue = null;
        Long rightValue = null;
        if (issyncnszt instanceof Boolean) {
            leftValue = (Boolean)issyncnszt;
        }
        if (jtmc instanceof DynamicObject) {
            rightValue = (Long)jtmc;
        } else if (jtmc instanceof HashMap && MapUtils.isNotEmpty((Map)(jtmcMap = (Map)jtmc)) && (idStr = jtmcMap.get("id")) != null) {
            rightValue = Long.parseLong(idStr.toString());
        }
        if (leftValue != null && rightValue != null) {
            return Pair.of((Object)leftValue, rightValue);
        }
        return null;
    }

    private static boolean check(DynamicObjectCollection dynamicObjects, Date startDate2, Date endDate2) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return false;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date enddate;
            Date startdate = dynamicObject.getDate("startdate");
            if (!QhjtCommonBusiness.chekcInterDate(startdate, enddate = dynamicObject.getDate("enddate"), startDate2, endDate2)) continue;
            return true;
        }
        return false;
    }

    private static boolean chekcInterDate(Date startDate, Date endDate, Date startDateInput, Date endDateInput) {
        if (endDate == null) {
            return endDateInput == null || endDateInput.compareTo(startDate) >= 0;
        }
        if (endDateInput == null) {
            return startDateInput.compareTo(endDate) <= 0;
        }
        return startDateInput.compareTo(endDate) <= 0 && endDateInput.compareTo(startDate) >= 0;
    }

    public static List<Long> queryOrgCountByAccountSetIds(QFilter filter) {
        DynamicObjectCollection count = QueryServiceHelper.query((String)"tcvvt_clique_accountset", (String)"distinct(org) as org", (QFilter[])new QFilter[]{filter});
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)count)) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject dyo : count) {
                orgIds.add(dyo.getLong("org"));
            }
            return orgIds;
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryOrgCountBySubjectIds(QFilter[] filter) {
        DynamicObjectCollection count = QueryServiceHelper.query((String)"tcvvt_clique_account", (String)"distinct(org) as org", (QFilter[])filter);
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)count)) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject dyo : count) {
                orgIds.add(dyo.getLong("org"));
            }
            return orgIds;
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryOrgCountByQcyeSetIds(QFilter filter) {
        DynamicObjectCollection count = QueryServiceHelper.query((String)"tcvvt_clique_qcye", (String)"distinct(org) as org", (QFilter[])new QFilter[]{filter});
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)count)) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject dyo : count) {
                orgIds.add(dyo.getLong("org"));
            }
            return orgIds;
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryOrgCountByVoucherSetIds(QFilter[] filter) {
        DynamicObjectCollection count = QueryServiceHelper.query((String)"tcvvt_voucher", (String)"distinct(org) as org", (QFilter[])filter);
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)count)) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject dyo : count) {
                orgIds.add(dyo.getLong("org"));
            }
            return orgIds;
        }
        return new ArrayList<Long>();
    }

    public static Map<String, String> queryAccountingOrgByIds(List<Long> orgIds) {
        HashMap<String, String> orgMap = new HashMap<String, String>();
        TaxResult result = ViewDataServiceHelper.queryOrgUnitByOrgIdsAndViewNumber(orgIds, (String)"10");
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)result) && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)result.getData())) {
            DynamicObject[] data;
            for (DynamicObject datum : data = (DynamicObject[])result.getData()) {
                orgMap.put(datum.getString("id"), datum.getString("name"));
            }
        }
        return orgMap;
    }
}

