/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.rulefetch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvvt.business.abstractbusiness.AbstractDeclareBusiness;
import kd.taxc.tcvvt.business.abstractbusiness.AbstractRuleFetchBusiness;
import kd.taxc.tcvvt.business.api.common.DeclareBusiness;
import kd.taxc.tcvvt.business.rulefetch.RuleFetchBusinessImpl;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleFetchDto;
import org.apache.commons.lang3.ObjectUtils;

public class DeclareBusinessImpl
extends AbstractDeclareBusiness
implements DeclareBusiness {
    private static List<String> zzsformulakeys = new ArrayList<String>(16);
    private static List<String> formulakeys = new ArrayList<String>(16);
    private static List<String> zzsewbxhs = new ArrayList<String>(16);
    private static List<String> ewbxhs = new ArrayList<String>(16);
    private static Map<String, String> lelation = new HashMap<String, String>(516);

    @Override
    public String gettemplatenum(Long orgId, Date skssqq, Date skssqz, String templatetype) {
        String templateNum = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(skssqq);
        if ("zdsybs_yd".equalsIgnoreCase(templatetype)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSYD2024" : (calendar.get(1) == 2023 ? "ZDSYBSYD2023" : "ZDSYBSYD2020");
        }
        if ("zdsybs_jd".equalsIgnoreCase(templatetype)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSJD2024" : (calendar.get(1) == 2023 ? "ZDSYBSJD2023" : "ZDSYBSJD2020");
        }
        return templateNum;
    }

    public static AbstractRuleFetchBusiness getRuleFetchBusiness() {
        return RuleFetchBusinessInner.ruleFetchBusiness;
    }

    @Override
    public List<RuleFetchDto> multipleGetFetch(List<RuleFetchDto> resultList, Long orgId, Date skssqq, Date skssqz) {
        TaxResult zzs = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(orgId));
        String deadline = "";
        int monthOfDate = DateUtils.getMonthOfDate((Date)skssqq);
        int yearOfDate = DateUtils.getYearOfDate((Date)skssqq);
        String prePeriodSbbid = "";
        if (yearOfDate >= 2023 && !ObjectUtils.isEmpty((Object)zzs) && !ObjectUtils.isEmpty((Object)zzs.getData())) {
            Map<String, BigDecimal> resultMap;
            DynamicObjectCollection categoryentryentity = (DynamicObjectCollection)((DynamicObject)((List)zzs.getData()).get(0)).get("categoryentryentity");
            if (!ObjectUtils.isEmpty((Object)categoryentryentity)) {
                deadline = ((DynamicObject)((DynamicObjectCollection)((DynamicObject)((List)zzs.getData()).get(0)).get("categoryentryentity")).get(0)).getString("deadline");
            }
            if ("ajsb".equalsIgnoreCase(deadline) && monthOfDate > 3 || "aysb".equalsIgnoreCase(deadline) && monthOfDate > 1) {
                prePeriodSbbid = DeclareBusinessImpl.QueryPrePirodSbbidByOrgAndDate(orgId, skssqq);
                resultMap = DeclareBusinessImpl.queryPrePirodSbbAmountByFormulakey(prePeriodSbbid, zzsewbxhs);
                DeclareBusinessImpl.setFetchAmount(resultList, resultMap, zzsformulakeys);
            }
            if (monthOfDate > 1) {
                prePeriodSbbid = DeclareBusinessImpl.QueryPrePirodSbbidByOrgAndDate(orgId, skssqq);
                resultMap = DeclareBusinessImpl.queryPrePirodSbbAmountByFormulakey(prePeriodSbbid, ewbxhs);
                DeclareBusinessImpl.setFetchAmount(resultList, resultMap, formulakeys);
            }
        }
        return resultList;
    }

    public static String QueryPrePirodSbbidByOrgAndDate(Long orgId, Date skssqq) {
        skssqq = DateUtils.addMonth((Date)skssqq, (int)-1);
        QFilter orgf = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqf = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter templatetypef = new QFilter("type", "like", (Object)"%zdsy%");
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{orgf, skssqqf, templatetypef});
        if (!ObjectUtils.isEmpty((Object)dyo)) {
            return dyo.getString("id");
        }
        return "";
    }

    public static Map<String, BigDecimal> queryPrePirodSbbAmountByFormulakey(String sbbid, List<String> ewbxhs) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        QFilter idf = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter ewbxhf = new QFilter("ewblxh", "in", ewbxhs);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"tcvvt_tax", (String)"ewblxh,bnbq", (QFilter[])new QFilter[]{idf, ewbxhf});
        if (!ObjectUtils.isEmpty((Object)result)) {
            for (DynamicObject dyo : result) {
                String ewbxh = dyo.getString("ewblxh");
                BigDecimal amount = dyo.getBigDecimal("bnbq") == null ? new BigDecimal("0.00") : dyo.getBigDecimal("bnbq");
                resultMap.put(lelation.get(ewbxh), amount);
            }
        }
        return resultMap;
    }

    public static void setFetchAmount(List<RuleFetchDto> resultList, Map<String, BigDecimal> resultMap, List<String> formulakeys) {
        for (RuleFetchDto fetchDto : resultList) {
            String formulakey = fetchDto.getFormulakey();
            if (!formulakeys.contains(formulakey)) continue;
            fetchDto.setReportingAmount(resultMap.get(formulakey) == null ? new BigDecimal("0.00") : resultMap.get(formulakey));
            fetchDto.setFetchamount(resultMap.get(formulakey) == null ? new BigDecimal("0.00") : resultMap.get(formulakey));
        }
    }

    static {
        lelation.put("40", "tcvvt_tax#33#bnbq");
        lelation.put("59", "tcvvt_tax#52#bnbq");
        lelation.put("74", "tcvvt_tax#72#bnbq");
        zzsformulakeys.add("tcvvt_tax#33#bnbq");
        zzsformulakeys.add("tcvvt_tax#52#bnbq");
        formulakeys.add("tcvvt_tax#72#bnbq");
        zzsewbxhs.add("40");
        zzsewbxhs.add("59");
        ewbxhs.add("74");
    }

    private static class RuleFetchBusinessInner {
        private static final AbstractRuleFetchBusiness ruleFetchBusiness = new RuleFetchBusinessImpl();

        private RuleFetchBusinessInner() {
        }
    }
}

