/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.rulefetch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.tcvvt.business.abstractbusiness.AbstractRuleFetchBusiness;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleEngineDto;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.tcvvt.common.dto.rulefetch.RuleFetchDto;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.threadpools.Task;
import org.apache.commons.lang3.ObjectUtils;

public class DeclareRuleFetchTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(DeclareRuleFetchTask.class);
    private Long orgId;
    private Date skssqq;
    private Date skssqz;
    private String templateType;
    private String templatenum;
    private AbstractRuleFetchBusiness ruleFetchBusiness;
    private Map<String, String> formulakeyMap;
    private Map<String, String> formulakeyMapSn;
    private int batchSize = 8;
    private List<DynamicObject> accessConfigList;
    public List<RuleFetchDto> ruleFetchResultList;

    public DeclareRuleFetchTask(Long orgId, Date skssqq, Date skssqz, String templateType, List<DynamicObject> accessConfigList, AbstractRuleFetchBusiness ruleFetchBusiness, Map<String, String> formulakeyMap, Map<String, String> formulakeyMapSn, String templatenum) {
        this.orgId = orgId;
        this.skssqq = skssqq;
        this.skssqz = skssqz;
        this.templateType = templateType;
        this.templatenum = templatenum;
        this.accessConfigList = accessConfigList;
        this.ruleFetchBusiness = ruleFetchBusiness;
        this.formulakeyMap = !ObjectUtils.isEmpty(formulakeyMap) ? formulakeyMap : Collections.synchronizedMap(new HashMap());
        this.formulakeyMapSn = !ObjectUtils.isEmpty(formulakeyMap) ? formulakeyMapSn : Collections.synchronizedMap(new HashMap());
        this.ruleFetchResultList = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public List<List<DynamicObject>> getValue() {
        String templateNum = "";
        if (ObjectUtils.isEmpty(this.accessConfigList)) {
            return Lists.partition(this.accessConfigList, (int)this.batchSize);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.skssqq);
        if ("zdsybs_yd".equalsIgnoreCase(this.templateType)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSYD2024" : (calendar.get(1) == 2023 ? "ZDSYBSYD2023" : "ZDSYBSYD2020");
        }
        if ("zdsybs_jd".equalsIgnoreCase(this.templateType)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSJD2024" : (calendar.get(1) == 2023 ? "ZDSYBSJD2023" : "ZDSYBSJD2020");
        }
        QFilter taxTypeFilter = new QFilter("taxtype.number", "=", (Object)this.templateType);
        QFilter formulaname = new QFilter("formula", "like", (Object)"%{P%");
        QFilter formulaTypeFilter = new QFilter("formulatype", "=", (Object)"1");
        QFilter templateNumber = new QFilter("templatenum", "=", (Object)templateNum);
        DynamicObjectCollection collection = null;
        collection = "zdsybs_yd".equalsIgnoreCase(this.templateType) || "zdsybs_jd".equalsIgnoreCase(this.templateType) ? QueryServiceHelper.query((String)"tpo_formula_edit", (String)"id,formulaname,formulakey", (QFilter[])new QFilter[]{taxTypeFilter, formulaname, formulaTypeFilter, templateNumber}) : QueryServiceHelper.query((String)"tpo_formula_edit", (String)"id,formulaname,formulakey", (QFilter[])new QFilter[]{taxTypeFilter, formulaname, formulaTypeFilter});
        if ("ZDSYBSYD2024".equalsIgnoreCase(templateNum) || "ZDSYBSJD2024".equalsIgnoreCase(templateNum)) {
            for (DynamicObject dyo : collection) {
                if (!StringUtil.isOnlyNumber(dyo.getString("formulaname"))) continue;
                String formulakey = dyo.getString("formulakey");
                String[] s = formulakey.split("#");
                if (!s[2].contains("sn") || !s[0].contains("tax") && !s[0].contains("product")) {
                    this.formulakeyMap.put(dyo.getString("formulaname"), dyo.getString("formulakey"));
                }
                if (!s[2].contains("sn") || !s[0].contains("tax") && !s[0].contains("product")) continue;
                this.formulakeyMapSn.put(dyo.getString("formulaname"), dyo.getString("formulakey"));
            }
        } else {
            for (DynamicObject dyo : collection) {
                if (!StringUtil.isOnlyNumber(dyo.getString("formulaname"))) continue;
                this.formulakeyMap.put(dyo.getString("formulaname"), dyo.getString("formulakey"));
            }
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId).and(new QFilter("templateType", "=", (Object)this.templateType));
        QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)this.skssqq).and(new QFilter("skssqz", "=", (Object)this.skssqz));
        DeleteServiceHelper.delete((String)"tcvvt_fetch_summary", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_fetch_detail", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_fetch_adjust", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        return Lists.partition(this.accessConfigList, (int)this.batchSize);
    }

    @Override
    public List<DynamicObject> executor(List<DynamicObject> ex) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        if (ObjectUtils.isEmpty(ex)) {
            return list;
        }
        RuleEngineDto ruleEngineDto = new RuleEngineDto(this.orgId, this.skssqq, this.skssqz, this.templateType, ex);
        List<RuleFetchDto> ruleFetchAmountList = this.ruleFetchBusiness.getRuleFetchSummaryAmount(ruleEngineDto, this.templatenum);
        for (RuleFetchDto ruleFetchDto : ruleFetchAmountList) {
            List<RuleFetchDetailDto> ruleFetchDetailDtoList = ruleFetchDto.getRuleFetchDetailDtoList();
            if (!ObjectUtils.isEmpty(ruleFetchDetailDtoList)) {
                String fetchtype = ruleFetchDto.getFetchtype();
                String projectcaliberid = ruleFetchDto.getProjectcaliberid();
                if (!ObjectUtils.isEmpty((Object)fetchtype)) {
                    if ("sn".equalsIgnoreCase(fetchtype)) {
                        if (!ObjectUtils.isEmpty((Object)projectcaliberid)) {
                            ruleFetchDto.setFormulakey(this.formulakeyMapSn.get(ruleFetchDto.getAccessprojectid() + "-" + projectcaliberid));
                        } else {
                            ruleFetchDto.setFormulakey(this.formulakeyMapSn.get(ruleFetchDto.getAccessprojectid()));
                        }
                    }
                } else if (!ObjectUtils.isEmpty((Object)projectcaliberid)) {
                    ruleFetchDto.setFormulakey(this.formulakeyMap.get(ruleFetchDto.getAccessprojectid() + "-" + projectcaliberid));
                } else {
                    ruleFetchDto.setFormulakey(this.formulakeyMap.get(ruleFetchDto.getAccessprojectid()));
                }
            }
            DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)"tcvvt_fetch_summary");
            summary.set("org", (Object)this.orgId);
            summary.set("skssqq", (Object)this.skssqq);
            summary.set("skssqz", (Object)this.skssqz);
            summary.set("datasource", (Object)"system");
            summary.set("creater", (Object)RequestContext.get().getCurrUserId());
            summary.set("modifier", (Object)RequestContext.get().getCurrUserId());
            summary.set("accessprojectid", (Object)ruleFetchDto.getAccessprojectid());
            summary.set("formulakey", (Object)ruleFetchDto.getFormulakey());
            summary.set("taxlimit", (Object)ruleFetchDto.getTaxlimit());
            summary.set("serialno", (Object)ruleFetchDto.getSerialno());
            summary.set("fetchamount", (Object)ruleFetchDto.getFetchamount());
            summary.set("templatetype", (Object)ruleFetchDto.getTemplateType());
            list.add(summary);
        }
        this.ruleFetchResultList.addAll(ruleFetchAmountList);
        return list;
    }
}

