/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.business.taxorg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;

public class TcvvtTaxOrgCommonBusiness {
    public static boolean isTaxcOrgExistByOrgId(Long orgid) {
        TaxResult taxResult = TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgId((Long)orgid);
        boolean isExist = false;
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            isExist = (Boolean)taxResult.getData();
        }
        return isExist;
    }

    public static boolean isTaxcOrgExistByOrgIdAndIsTaxpayer(Long orgid) {
        TaxResult taxResult = TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgIdAndIsTaxpayer((Long)orgid);
        boolean isExist = false;
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            isExist = (Boolean)taxResult.getData();
        }
        return isExist;
    }

    public static List<Long> queryTaxcOrgByOrgIdAndIsTaxpayer(List<Long> orgIds) {
        List<Long> list = new ArrayList<Long>(orgIds.size());
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdAndIsTaxpayer(orgIds);
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            list = ((List)taxResult.getData()).stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        }
        return list;
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayer() {
        List<Long> list = new ArrayList<Long>();
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgIdByIsTaxpayer();
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            list = (List)taxResult.getData();
        }
        return list;
    }

    public static List<Long> queryTaxcMainOrgIdsByOrgIds(List<Long> orgIds) {
        List<Long> list = new ArrayList<Long>();
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgIds);
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            list = ((List)taxResult.getData()).stream().map(v -> v.getLong("taxorg.org.id")).collect(Collectors.toList());
        }
        return list;
    }

    public static List<DynamicObject> queryTaxcMainByOrgIds(List<Long> orgIds) {
        List<Object> list = new ArrayList<DynamicObject>();
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgIds);
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            list = (List)taxResult.getData();
        }
        return list;
    }

    public static List<Long> queryTaxcMainByCustomFilter(List<Long> orgIds, QFilter[] customFilters) {
        return TcvvtTaxOrgCommonBusiness.queryByCustomFilter(orgIds, TaxationsysMappingEnum.CHN.getId(), customFilters, null);
    }

    public static List<Long> queryTaxcOrgIdsWithPerm(Long userId) {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)userId);
        if (result.isSuccess()) {
            return (List)result.getData();
        }
        return new ArrayList<Long>(0);
    }

    private static List<Long> queryByCustomFilter(List<Long> orgIds, Long taxationsysId, QFilter[] customFilters, String orderBy) {
        List<Long> list = new ArrayList<Long>();
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByCustomFilter(orgIds, (Long)taxationsysId, (String)"taxorg.org.id", (QFilter[])customFilters, (String)orderBy);
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            list = ((DynamicObjectCollection)taxResult.getData()).stream().map(v -> v.getLong("taxorg.org.id")).collect(Collectors.toList());
        }
        return list;
    }

    public static List<Long> queryOrgIdByViewWithPerm(Long userId, String viewNumber) {
        ArrayList<Long> result = new ArrayList<Long>(12);
        TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)userId, (String)viewNumber);
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            result.addAll((Collection)listTaxResult.getData());
        }
        return result;
    }

    public static List<DynamicObject> queryTaxMainInfoByOrgIds(List<Long> orgsList) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(12);
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsWithNoStatus(orgsList, null);
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            result.addAll((Collection)listTaxResult.getData());
        }
        return result;
    }
}

