/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.helper;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListView;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvvt.common.helper.OrgServiceHelper;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OrgCheckServiceHelper {
    public static boolean checkRelation(Long accountOrg, Date startDate, Date endDate) {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"checkRelation", (Object[])new Object[]{accountOrg, startDate, endDate});
    }

    public static boolean orgEnable(IFormView view, DynamicObjectCollection org, boolean needErrorMsg) {
        Map map;
        if (null != org && !org.isEmpty() && StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)(map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"orgEnable", (Object[])new Object[]{((DynamicObject)org.get(0)).getLong("id"), needErrorMsg})).get("code")), (CharSequence)"true")) {
            if (needErrorMsg && null != view) {
                view.showErrorNotification((String)map.get("failInfo"));
            }
            return true;
        }
        return false;
    }

    public static boolean isTaxPayerAuth(IFormView view, String orgId, boolean needErrorMsg) {
        Map map;
        String entityName = view.getEntityId();
        if (view instanceof ListView) {
            entityName = ((ListView)view).getBillFormId();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)(map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"isTaxPayerAuth", (Object[])new Object[]{orgId, entityName, needErrorMsg})).get("code")), (CharSequence)"true")) {
            if (needErrorMsg && null != view) {
                view.showErrorNotification((String)map.get("failInfo"));
            }
            return true;
        }
        return false;
    }

    public static boolean licenseCheckByAppid(TreeNode node, String appid) {
        String orgId = node.getId();
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"licenseCheckByAppid", (Object[])new Object[]{orgId, appid});
    }

    public static boolean checkOrgAndEnable(IFormView view, String orgId, boolean needErrorMsg) {
        DynamicObjectCollection org = OrgServiceHelper.queryOrgListByCondition(TreeUtils.convertParam((String)"id", (Object)orgId));
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            if (needErrorMsg) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckServiceHelper_0", (String)"taxc-tcvvt", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            }
            return true;
        }
        return OrgCheckServiceHelper.orgEnable(view, org, needErrorMsg);
    }

    public static Long setDefaultOrg(IFormView getView, Long orgid, DynamicObjectCollection permOrgs) {
        if (null == permOrgs) {
            return null;
        }
        List orgList = permOrgs.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"setDefaultOrg", (Object[])new Object[]{orgid, orgList});
        if (ObjectUtils.isEmpty(map.get("orgid"))) {
            getView.showErrorNotification((String)map.get("failInfo"));
            return null;
        }
        return (Long)map.get("orgid");
    }
}

