/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.taxc.tcvvt.common.metadata.domain.EntityField;
import kd.taxc.tcvvt.common.metadata.domain.EntityInfo;
import org.apache.commons.lang3.StringUtils;

public class MetadataUtil {
    public static EntityInfo getEntityById(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            EntityInfo entity = new EntityInfo();
            entity.setEntityId(entityid);
            if (mainEntityType.getDisplayName() != null) {
                entity.setEntityName(mainEntityType.getDisplayName().getLocaleValue());
            }
            entity.setTableName(mainEntityType.getAlias());
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            StringBuilder sb = new StringBuilder();
            for (IDataEntityProperty property : mainPros) {
                DecimalProp decProp;
                EntityField entityField = new EntityField();
                entityField.setEntityId(entityid);
                entityField.setEntityName(entity.getEntityName());
                entityField.setFieldId(property.getName());
                if (property.getDisplayName() != null) {
                    entityField.setFieldName(property.getDisplayName().getLocaleValue());
                }
                if (property instanceof FieldProp) {
                    FieldProp field = (FieldProp)property;
                    entityField.setMustInput(field.isMustInput());
                }
                entityField.setColumnName(property.getAlias());
                entityField.setFieldType(property.getClass().getSimpleName().replaceAll("Prop", ""));
                if (property instanceof DecimalProp) {
                    decProp = (DecimalProp)property;
                    entityField.setPrecision(decProp.getPrecision());
                    entityField.setScale(decProp.getScale());
                    if ("tcvat_ybnsr_zb".equals(entityid)) {
                        entityField.setScale(2);
                        entityField.setFieldType("Decimal");
                    }
                } else if (property instanceof BasedataProp) {
                    decProp = (BasedataProp)property;
                    entityField.setBaseEntityId(decProp.getBaseEntityId());
                    entityField.setDisplayProp(decProp.getDisplayProp());
                } else if (property instanceof ComboProp) {
                    entityField.setComboItems(((ComboProp)property).getComboItems());
                } else if (property instanceof TextProp) {
                    entityField.setMaxLength(((TextProp)property).getMaxLenth());
                } else if (property instanceof DateTimeProp) {
                    entityField.setFormat(((DateTimeProp)property).getDateFormat());
                }
                entity.addField(entityField);
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(property.getName());
            }
            entity.setAllFields(sb.toString());
            return entity;
        }
        return null;
    }

    public static String getAllFieldString(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            StringBuilder sb = new StringBuilder();
            for (IDataEntityProperty property : mainPros) {
                if (StringUtils.isEmpty((CharSequence)property.getAlias())) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(property.getName());
            }
            return sb.toString();
        }
        return " * ";
    }

    public static Map<String, String> getComboItemsMap(String entityId, String fieldId) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null) {
            IDataEntityProperty property = null;
            if (fieldId.contains(".")) {
                Map allEntities = mainEntityType.getAllEntities();
                String[] splits = fieldId.split("\\.");
                property = ((EntityType)allEntities.get(splits[0])).getProperty(splits[1]);
            } else {
                DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
                property = (IDataEntityProperty)mainPros.get((Object)fieldId);
            }
            if (property instanceof ComboProp) {
                List items = ((ComboProp)property).getComboItems();
                for (ValueMapItem item : items) {
                    itemMap.put(item.getValue(), item.getName().getLocaleValue());
                }
            }
        }
        return itemMap;
    }
}

