/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.enums.KjGroupCsvEnum;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.ExportUtil;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.threadpools.Task;
import org.apache.commons.lang3.ObjectUtils;

public class CsvExportTask
extends Task<List<Object>> {
    private static Log LOG = LogFactory.getLog(CsvExportTask.class);
    private static final int batchSize = 10000;
    private String entityName;
    private KjGroupCsvEnum kjGroupCsvEnum;
    private String orderBys;
    private List<Object> allPkIds;

    public CsvExportTask(String entityName, KjGroupCsvEnum kjGroupCsvEnum, String orderBys, List<Object> allPkIds) {
        this.entityName = entityName;
        this.kjGroupCsvEnum = kjGroupCsvEnum;
        this.orderBys = orderBys;
        this.allPkIds = allPkIds;
    }

    @Override
    public List<List<Object>> getValue() {
        return Lists.partition(this.allPkIds, (int)10000);
    }

    @Override
    public List<Object> executor(List<Object> batchList) {
        ArrayList<Object> rowList = new ArrayList<Object>();
        if (ObjectUtils.isNotEmpty(batchList)) {
            Map<String, String> dateFormatMap = this.kjGroupCsvEnum.getDateFormatMap();
            QFilter idQ = new QFilter("id", "in", batchList);
            long queryTime = System.currentTimeMillis();
            DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entityName, (String)this.kjGroupCsvEnum.getFields(), (QFilter[])new QFilter[]{idQ}, (String)this.orderBys);
            LOG.info("\u5355\u6279\u67e5\u8be2\u8017\u65f6\uff1a" + (System.currentTimeMillis() - queryTime) + "ms");
            DataEntityPropertyCollection properties = collection.getDynamicObjectType().getProperties();
            long convertTime = System.currentTimeMillis();
            StringBuilder content = new StringBuilder();
            collection.stream().forEach(row -> {
                String[] line = new String[properties.size()];
                for (int i = 0; i < properties.size(); ++i) {
                    boolean isDateFormat;
                    String field = ((IDataEntityProperty)properties.get(i)).getName();
                    line[i] = row.getString(field);
                    boolean bl = isDateFormat = ObjectUtils.isNotEmpty((Object)dateFormatMap) && (StringUtil.equalsIgnoreCase((CharSequence)((IDataEntityProperty)properties.get(i)).getPropertyType().getName(), (CharSequence)"java.sql.Timestamp") || StringUtil.equalsIgnoreCase((CharSequence)((IDataEntityProperty)properties.get(i)).getPropertyType().getName(), (CharSequence)"java.util.Date")) && ObjectUtils.isNotEmpty(dateFormatMap.get(field));
                    if (!isDateFormat) continue;
                    line[i] = ObjectUtils.isEmpty((Object)row.get(field)) ? "" : DateUtils.format(row.getDate(field), (String)dateFormatMap.get(field));
                }
                ExportUtil.writeNext(line, true, content);
            });
            rowList.add(content.toString());
            content.setLength(0);
            LOG.info("\u5355\u6279\u8f6c\u6362\u8017\u65f6\uff1a" + (System.currentTimeMillis() - convertTime) + "ms");
        }
        return rowList;
    }
}

