/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.task;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.tcvvt.common.enums.KjGroupCsvEnum;
import kd.taxc.tcvvt.common.util.ExportUtil;
import kd.taxc.tcvvt.common.util.ExportUtilNew;
import kd.taxc.tcvvt.common.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CsvTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CsvTask.class);
    private int progress = 0;

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (this.progress < progress) {
            this.progress = progress;
        }
        if (this.progress > 100) {
            this.progress = 100;
        } else if (this.progress < 0) {
            this.progress = 0;
        }
    }

    public int getAndSetProgress(int progress) {
        this.setProgress(progress);
        return this.getProgress();
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u3002", (String)"CsvTask_0", (String)"taxc-tcvvt", (Object[])new Object[0]), null);
        String filterList = (String)params.get("filterList");
        Long dataCount = Long.valueOf((String)params.get("datacount"));
        Map orgMap = (Map)params.get("orgMap");
        List orgId = (List)params.get("orgIds");
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (int i = 0; i < orgId.size(); ++i) {
            String orgIdString = String.valueOf(orgId.get(i));
            orgIds.add(Long.parseLong(orgIdString));
        }
        this.feedbackProgress(this.getAndSetProgress(1));
        String url = this.handler("tcvvt_voucher", (QFilter[])SerializationUtils.deSerializeFromBase64((String)filterList), dataCount, orgMap, orgIds);
        this.feedbackProgress(this.getAndSetProgress(99));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "true");
        result.put("url", url);
        this.feedbackCustomdata(result);
    }

    public String handler(String entityName, QFilter[] filters, final Long dataCount, Map<String, String> orgMap, List<Long> orgIds) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        KjGroupCsvEnum kjGroupCsvEnum = KjGroupCsvEnum.getEnumByEntityName("tcvvt_voucher");
        File firstDirectory = FileUtils.getTempDirectory();
        String firstDirectoryPath = firstDirectory.getPath();
        File orgDirectory = new File(firstDirectoryPath + File.separator + UUID.randomUUID());
        File zipDirectory = new File(firstDirectoryPath + File.separator + UUID.randomUUID());
        boolean orgMkdirs = orgDirectory.mkdirs();
        boolean zipMkdirs = zipDirectory.mkdirs();
        if (orgMkdirs) {
            log.info("\u521b\u5efa\u7ec4\u7ec7\u6587\u4ef6\u5939\u6210\u529f: " + orgDirectory);
        } else {
            log.info("\u521b\u5efa\u7ec4\u7ec7\u6587\u4ef6\u5939\u5931\u8d25: " + orgDirectory);
        }
        if (zipMkdirs) {
            log.info("\u521b\u5efa\u538b\u7f29\u5305\u6587\u4ef6\u5939\u6210\u529f: " + zipDirectory);
        } else {
            log.info("\u521b\u5efa\u538b\u7f29\u5305\u6587\u4ef6\u5939\u5931\u8d25: " + zipDirectory);
        }
        HashMap fieldMap = new HashMap();
        mainEntityType.getProperties().stream().forEach(dynamicProperty -> fieldMap.put(dynamicProperty.getName(), "a." + dynamicProperty.getAlias()));
        for (Long orgId : orgIds) {
            StringBuilder where = new StringBuilder(" where 1= 1 ");
            where.append(" and a.forgid = ").append(orgId);
            if (ObjectUtils.isNotEmpty((Object)filters)) {
                Stream.iterate(0, i -> i + 1).limit(filters.length).forEach(num -> {
                    QFilter qFilter = filters[num];
                    String[] propertys = qFilter.getProperty().split("\\.");
                    if (propertys.length > 1) {
                        qFilter.__setProperty(propertys[0]);
                    }
                    where.append(" and ").append(qFilter.toString().replace(qFilter.getProperty(), (CharSequence)fieldMap.get(qFilter.getProperty())));
                });
            }
            String whereString = where.toString().replace("ftlike", "like");
            this.feedbackProgress(this.getAndSetProgress(2));
            final AtomicLong index = new AtomicLong(0L);
            final StringBuilder lineContent = new StringBuilder(1024);
            final SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            final Map<String, String> map = ExportUtilNew.getKjqjMapping();
            try {
                if (ObjectUtils.isEmpty((Object)orgMap.get(String.valueOf(orgId)))) continue;
                String fileDirectory = orgDirectory + File.separator + orgMap.get(String.valueOf(orgId));
                File file = new File(fileDirectory);
                File temp = new File(file.getPath() + File.separator + kjGroupCsvEnum.getFileName() + ".csv");
                boolean tempDirectory = file.mkdirs();
                if (tempDirectory) {
                    log.info("tempDirectory create success");
                } else {
                    log.info("tempDirectory create false");
                }
                String absolutePath = temp.getPath();
                log.info("absolutePath: " + absolutePath);
                ExportUtilNew.writeHead(entityName, kjGroupCsvEnum, absolutePath);
                try (final BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp, true), "GBK"), 0x1000000);){
                    DB.query((DBRoute)new DBRoute("taxc"), (String)(" select a.fnddm nd_dm, a.fkjqj kjqj,      a.fid id,          a.fpzz pzz,        a.fpzh pzh,        a.fflh flh,        a.fpzrq pz_rq,     a.fflzy flzy,      b.fnumber km_dm,   a.fjfje jfje,      a.fdfje dfje,      a.fwbbz wbbz,      a.fwbjfje wbjfje,  a.fwbdfje wbdfje,  a.fshr shr,        a.fzdr zdr,        a.fjzr jzr,        a.fcn cn,          a.ffjs fjs         from t_tcvvt_voucher a left join t_tcvvt_clique_account b on a.fkmdm = b.fid " + whereString), (ResultSetHandler)new ResultSetHandler<DynamicObject>(){

                        public DynamicObject handle(ResultSet resultSet) throws Exception {
                            while (resultSet.next()) {
                                if (index.longValue() % 10000L == 0L) {
                                    float temp = index.floatValue() / dataCount.floatValue();
                                    int progress = 2;
                                    progress = (double)temp < 0.02 ? 2 : (int)((double)(temp * 100.0f) * 0.94);
                                    CsvTask.this.feedbackProgress(CsvTask.this.getAndSetProgress(progress));
                                    if (CsvTask.this.isStop()) {
                                        CsvTask.this.stop();
                                    }
                                }
                                index.incrementAndGet();
                                String nd_dm = resultSet.getString("nd_dm");
                                String kjqj = (String)map.get(resultSet.getString("kjqj"));
                                String pzz = resultSet.getString("pzz");
                                String pzh = resultSet.getString("pzh");
                                String flh = resultSet.getString("flh");
                                Date date = resultSet.getDate("pz_rq");
                                String pz_rq = ObjectUtils.isEmpty((Object)date) ? "" : df.format(date);
                                String flzy = resultSet.getString("flzy");
                                String km_dm = resultSet.getString("km_dm");
                                String jfje = resultSet.getString("jfje");
                                String dfje = resultSet.getString("dfje");
                                String wbbz = resultSet.getString("wbbz");
                                String wbjfje = resultSet.getString("wbjfje");
                                String wbdfje = resultSet.getString("wbdfje");
                                String shr = resultSet.getString("shr");
                                String zdr = resultSet.getString("zdr");
                                String jzr = resultSet.getString("jzr");
                                String cn = resultSet.getString("cn");
                                String fjs = resultSet.getString("fjs");
                                String[] line = new String[]{nd_dm, kjqj, pzz, pzh, flh, pz_rq, flzy, km_dm, jfje, dfje, wbbz, wbjfje, wbdfje, shr, zdr, jzr, cn, fjs};
                                ExportUtilNew.writeNext(line, true, lineContent);
                                bufferedWriter.write(lineContent.toString());
                                lineContent.setLength(0);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("writeCSV error:", e.toString()), new Object[0]);
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
            this.feedbackProgress(this.getAndSetProgress(95));
        }
        String url = "";
        String folderPath = orgDirectory.getPath();
        String zipFilePath = zipDirectory.getPath() + File.separator + kjGroupCsvEnum.getFileName() + ".zip";
        try {
            ExportUtil.zipFolder(folderPath, zipFilePath);
            log.info("Zip file created successfully.");
        }
        catch (IOException e) {
            log.info("Error creating zip file: " + e.getMessage());
        }
        File zipFile = new File(zipFilePath);
        try (FileInputStream inputStream = new FileInputStream(zipFile);){
            this.feedbackProgress(this.getAndSetProgress(96));
            url = ExportUtilNew.downloadCsv(kjGroupCsvEnum.getFileName(), inputStream);
            this.feedbackProgress(this.getAndSetProgress(97));
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5e76\u4e0b\u8f7d\u5f02\u5e38", (String)"CsvTask_1", (String)"taxc-tcvvt", (Object[])new Object[0]), e.toString()), new Object[0]);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)orgDirectory);
                FileUtils.deleteDirectory((File)zipDirectory);
                log.info("\u5220\u9664\u76ee\u5f55\u6210\u529f\uff1a" + orgDirectory);
                log.info("\u5220\u9664\u76ee\u5f55\u6210\u529f\uff1a" + zipDirectory);
            }
            catch (IOException e) {
                log.info("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff1a" + orgDirectory);
                log.info("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff1a" + zipDirectory);
            }
        }
        this.feedbackProgress(this.getAndSetProgress(98));
        return url;
    }
}

