/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.upgrade;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tcvvt.common.metadata.MetadataUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractUpgradeFormPlugin
extends AbstractFormPlugin
implements IUpgradeService {
    private static final String UPGRADEBTN = "upatedata";
    protected static final String SUCCESS_INFO = AbstractUpgradeFormPlugin.getMsgA();
    protected static final String ERROR_INFO = AbstractUpgradeFormPlugin.getMsgB();
    protected static final String POINT = ".";
    protected static final String COMMA = ",";
    protected static final String ID = "id";
    protected static final char ENTER = '\n';
    protected String currentData = "";
    protected static int ERROR = 1;
    protected static int INFO = 2;
    protected StringBuilder logs = new StringBuilder();

    protected static String getMsgA() {
        return "DATA UPGRADE SUCCESSFUL!";
    }

    protected static String getMsgB() {
        return "DATA UPGRADE FAILURE!!!!";
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{UPGRADEBTN});
    }

    protected abstract IUpgradeService getService();

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if (Objects.equals(UPGRADEBTN, source.getKey())) {
            UpgradeResult upgradeResult = this.getService().beforeExecuteSqlWithResult(null, null, null, null);
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
            if (StringUtils.isEmpty((CharSequence)upgradeResult.getErrorInfo())) {
                codeSQLshow.setText(upgradeResult.getLog());
            } else {
                codeSQLshow.setText(upgradeResult.getLog() + "\n" + upgradeResult.getErrorInfo());
            }
            this.getView().updateView();
        }
    }

    protected abstract Log getLogger();

    protected void addLog(int level, String info) {
        if (ERROR == level) {
            this.getLogger().error(info);
        } else {
            this.getLogger().info(info);
        }
        this.logs.append(info);
        this.logs.append('\n');
    }

    protected Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById(entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    protected String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

