/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class DynamicObjectCollectionUtil {
    public static boolean isEqualPkValueSet(DynamicObjectCollection collA, DynamicObjectCollection collB) {
        return DynamicObjectCollectionUtil.isEqualPkValueSet(collA, collB, "id");
    }

    public static boolean isEqualPkValueSet(DynamicObjectCollection collA, DynamicObjectCollection collB, String pkFiled) {
        if (collA == null || collB == null) {
            throw new IllegalArgumentException();
        }
        HashSet<Object> collAPkValueSet = DynamicObjectCollectionUtil.getPkValueSet(collA, pkFiled);
        HashSet<Object> collBPkValueSet = DynamicObjectCollectionUtil.getPkValueSet(collB, pkFiled);
        if (collAPkValueSet.size() != collBPkValueSet.size()) {
            return false;
        }
        for (Object obj : collAPkValueSet) {
            if (collBPkValueSet.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public static HashSet<Object> getPkValueSet(DynamicObjectCollection coll) {
        return DynamicObjectCollectionUtil.getPkValueSet(coll, "id");
    }

    public static HashSet<Object> getPkValueSet(DynamicObjectCollection coll, String pkFiled) {
        if (coll == null) {
            throw new IllegalArgumentException();
        }
        HashSet<Object> resultSet = new HashSet<Object>();
        for (DynamicObject object : coll) {
            if (object.getPkValue() == null || object.get(pkFiled) == null) continue;
            resultSet.add(object.get(pkFiled));
        }
        return resultSet;
    }

    public static String getPkValueStrDesc(DynamicObjectCollection coll) {
        if (coll == null || coll.size() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder builder = new StringBuilder("(");
        for (DynamicObject obj : coll) {
            builder.append(obj.getPkValue().toString()).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        return builder.toString();
    }
}

