/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

public class ExcelUtils {
    private static Log logger = LogFactory.getLog(ExcelUtils.class);

    public static String getStringValueFromCell(Cell cell, DecimalFormat decimalFormat) {
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd");
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.STRING) {
            cellValue = cell.getRichStringCellValue().toString();
        } else if (cellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                double d = cell.getNumericCellValue();
                Date date = DateUtil.getJavaDate((double)d);
                cellValue = sFormat.format(date);
            } else {
                cellValue = decimalFormat.format(cell.getNumericCellValue());
            }
        } else if (cellType == CellType.BLANK) {
            cellValue = "";
        } else if (cellType == CellType.BOOLEAN) {
            cellValue = String.valueOf(cell.getBooleanCellValue());
        } else if (cellType == CellType.ERROR) {
            cellValue = "";
        } else if (cellType == CellType.FORMULA) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                cellValue = sFormat.format(cell.getDateCellValue());
            } else {
                cellValue = String.valueOf(cell.getNumericCellValue());
                logger.info("\u5355\u5143\u683c\u516c\u5f0f\u7684\u503c\uff1a{}", (Object)cell.toString());
            }
        }
        return cellValue;
    }

    public static String getStringValueFromCell(Cell cell) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return ExcelUtils.getStringValueFromCell(cell, decimalFormat);
    }
}

