/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.enums.KjGroupCsvEnum;
import kd.taxc.tcvvt.common.task.CsvExportTask;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.UUID;
import kd.taxc.tcvvt.common.util.threadpools.ThreadPoolsService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ExportUtil {
    private static final Log LOG = LogFactory.getLog(ExportUtil.class);
    private static final String CSV = ".csv";
    private static final String CSV_PATH = "/exportcsv/";
    private static final char separator = ',';
    private static final char quotechar = '\"';
    private static final String lineEnd = System.lineSeparator();

    public static String downloadKjGroupCsvFile(String entityName, QFilter qFilters, IFormView formView, String orderBys, Map<String, String> orgMap, List<Long> orgIds) {
        long time = System.currentTimeMillis();
        KjGroupCsvEnum kjGroupCsvEnum = KjGroupCsvEnum.getEnumByEntityName(entityName);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        Map<String, List<Object>> orgIdToPkIdsMap = ExportUtil.queryOrgIdToPkidsByFilter(entityName, new QFilter[]{qFilters, orgFilter});
        File firstDirectory = FileUtils.getTempDirectory();
        String firstDirectoryPath = firstDirectory.getPath();
        File orgDirectory = new File(firstDirectoryPath + File.separator + UUID.randomUUID());
        File zipDirectory = new File(firstDirectoryPath + File.separator + UUID.randomUUID());
        boolean orgMkdirs = orgDirectory.mkdirs();
        boolean zipMkdirs = zipDirectory.mkdirs();
        if (orgMkdirs) {
            LOG.info("\u521b\u5efa\u7ec4\u7ec7\u6587\u4ef6\u5939\u6210\u529f: " + orgDirectory);
        } else {
            LOG.info("\u521b\u5efa\u7ec4\u7ec7\u6587\u4ef6\u5939\u5931\u8d25: " + orgDirectory);
        }
        if (zipMkdirs) {
            LOG.info("\u521b\u5efa\u538b\u7f29\u5305\u6587\u4ef6\u5939\u6210\u529f: " + zipDirectory);
        } else {
            LOG.info("\u521b\u5efa\u538b\u7f29\u5305\u6587\u4ef6\u5939\u5931\u8d25: " + zipDirectory);
        }
        for (Long orgId : orgIds) {
            List<Object> allPkIds = orgIdToPkIdsMap.get(String.valueOf(orgId));
            if (ObjectUtils.isEmpty(allPkIds)) continue;
            LOG.info("\u67e5\u8be2\u5bfc\u51fa\u603b\u6761\u6570\u8017\u65f6\uff1a" + (System.currentTimeMillis() - time) + "ms");
            try {
                if (ObjectUtils.isEmpty((Object)orgMap.get(String.valueOf(orgId)))) continue;
                File orgFile = new File(orgDirectory.getPath() + File.separator + orgMap.get(String.valueOf(orgId)));
                boolean b = orgFile.mkdirs();
                if (b) {
                    LOG.info("\u904d\u5386\u521b\u5efa\u7ec4\u7ec7\u6587\u4ef6\u5939\u6210\u529f: " + orgFile);
                } else {
                    LOG.info("\u904d\u5386\u521b\u5efa\u7ec4\u7ec7\u6587\u4ef6\u5939\u5931\u8d25: " + orgFile);
                }
                File temp = new File(orgDirectory + File.separator + orgMap.get(String.valueOf(orgId)) + File.separator + kjGroupCsvEnum.getFileName() + CSV);
                LOG.info("\u751f\u6210csv\u6587\u4ef6\u6210\u529f: " + temp);
                ExportUtil.writeHead(entityName, kjGroupCsvEnum, temp.getPath());
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp.getPath(), true), "GBK"));
                    Throwable throwable = null;
                    try {
                        CsvExportTask csvExportTask = new CsvExportTask(entityName, kjGroupCsvEnum, orderBys, allPkIds);
                        List<Future<Object>> futures = ThreadPoolsService.getInstance().submitReturnFuture(csvExportTask);
                        long writeTotalTime = System.currentTimeMillis();
                        while (ObjectUtils.isNotEmpty(futures)) {
                            Iterator<Future<Object>> iterator = futures.iterator();
                            while (iterator.hasNext()) {
                                Future<Object> future = iterator.next();
                                if (!future.isDone()) continue;
                                long writeTime = System.currentTimeMillis();
                                List list = (List)future.get();
                                list.stream().forEach(content -> {
                                    try {
                                        bufferedWriter.write((String)content);
                                        bufferedWriter.flush();
                                    }
                                    catch (IOException e) {
                                        throw new KDBizException((Throwable)e, new ErrorCode("writeRow error:", e.toString()), new Object[0]);
                                    }
                                });
                                iterator.remove();
                                LOG.info("\u5355\u6279\u5199\u5165\u6587\u4ef6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - writeTime) + "ms");
                                LOG.info("\u6587\u4ef6\u5927\u5c0f: " + temp.length());
                            }
                        }
                        LOG.info("\u5199\u5165\u6587\u4ef6\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - writeTotalTime) + "ms");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bufferedWriter == null) continue;
                        if (throwable != null) {
                            try {
                                bufferedWriter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        bufferedWriter.close();
                    }
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("writeCSV error:", e.toString()), new Object[0]);
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
        }
        String folderPath = orgDirectory.getPath();
        String zipFilePath = zipDirectory.getPath() + File.separator + kjGroupCsvEnum.getFileName() + ".zip";
        try {
            ExportUtil.zipFolder(folderPath, zipFilePath);
            LOG.info("Zip file created successfully.");
        }
        catch (IOException e) {
            LOG.info("Error creating zip file: " + e.getMessage());
        }
        File zipFile = new File(zipFilePath);
        LOG.info("\u538b\u7f29\u6587\u4ef6\u8def\u5f84: " + zipFilePath);
        LOG.info("\u538b\u7f29\u6587\u4ef6: " + zipFile);
        try (FileInputStream inputStream = new FileInputStream(zipFile);){
            long uploadTime = System.currentTimeMillis();
            ExportUtil.downloadCsv(kjGroupCsvEnum.getFileName(), formView, inputStream);
            LOG.info("\u4e0a\u4f20\u6587\u4ef6\u5e76\u4e0b\u8f7d\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - uploadTime) + "ms");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)orgDirectory);
                FileUtils.deleteDirectory((File)zipDirectory);
                LOG.info("\u5220\u9664\u76ee\u5f55\u6210\u529f\uff1a" + orgDirectory);
                LOG.info("\u5220\u9664\u76ee\u5f55\u6210\u529f\uff1a" + zipDirectory);
            }
            catch (IOException e) {
                LOG.info("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff1a" + orgDirectory);
                LOG.info("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff1a" + zipDirectory);
            }
        }
        return null;
    }

    private static String downloadCsv(String fileName, IFormView formView, InputStream inputStream) {
        long time = System.currentTimeMillis();
        LOG.info("uoloadCsvFile Time\uff1a" + (System.currentTimeMillis() - time) + "ms");
        try {
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".zip", inputStream, 5000);
            String appId = formView.getFormShowParameter().getAppId();
            String billFormId = ((IListView)formView).getBillFormId();
            PermissionUtils.putTempFilePermissionCache((String)url, (String)appId, (String)billFormId, (String)"2BF66VAR06YX");
            formView.download(url);
        }
        catch (KDBizException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        LOG.info("downloadCsvFile Time\uff1a" + (System.currentTimeMillis() - time) + "ms");
        return "";
    }

    public static void writeNext(String[] nextLine, boolean applyQuotesToAll, StringBuilder appendable) {
        if (nextLine == null) {
            return;
        }
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                appendable.append(',');
            }
            if ((nextElement = StringUtil.defaultString((String)nextLine[i])) == null) continue;
            Boolean stringContainsSpecialCharacters = ExportUtil.stringContainsSpecialCharacters(nextElement);
            ExportUtil.appendQuoteCharacterIfNeeded(applyQuotesToAll, appendable, stringContainsSpecialCharacters);
            if (stringContainsSpecialCharacters.booleanValue()) {
                ExportUtil.processLine(nextElement, appendable);
            } else {
                appendable.append(nextElement);
            }
            ExportUtil.appendQuoteCharacterIfNeeded(applyQuotesToAll, appendable, stringContainsSpecialCharacters);
        }
        appendable.append(lineEnd);
    }

    private static void appendQuoteCharacterIfNeeded(boolean applyQuotesToAll, StringBuilder appendable, Boolean stringContainsSpecialCharacters) {
        if (applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) {
            appendable.append('\"');
        }
    }

    private static boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(34) != -1 || line.indexOf(44) != -1 || line.contains("\n") || line.contains("\r");
    }

    private static void processLine(String nextElement, StringBuilder appendable) {
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            ExportUtil.processCharacter(appendable, nextChar);
        }
    }

    private static void processCharacter(StringBuilder appendable, char nextChar) {
        if (ExportUtil.checkCharactersToEscape(nextChar)) {
            appendable.append('\"');
        }
        appendable.append(nextChar);
    }

    private static boolean checkCharactersToEscape(char nextChar) {
        return nextChar == '\"';
    }

    private static void writeHead(String entityName, KjGroupCsvEnum kjGroupCsvEnum, String absolutePath) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)kjGroupCsvEnum.getFields(), (QFilter[])new QFilter[]{new QFilter("1", "!=", (Object)1)});
        StringBuilder content = new StringBuilder();
        DataEntityPropertyCollection properties = collection.getDynamicObjectType().getProperties();
        properties.forEach(o -> content.append(o.getName()).append(","));
        String newContent = content.substring(0, content.length() - 1);
        content.setLength(0);
        content.append(newContent);
        content.append(lineEnd);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(absolutePath, true), "GBK"));){
            bufferedWriter.write(content.toString());
            bufferedWriter.flush();
            content.setLength(0);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("writeHead error:", e.toString()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolder(String folderPath, String zipFilePath) throws IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipFilePath);
            zos = new ZipOutputStream(fos);
            ExportUtil.addFolderToZip("", new File(folderPath), zos);
        }
        finally {
            if (zos != null) {
                zos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFolderToZip(String parentPath, File folder, ZipOutputStream zos) throws IOException {
        for (File file : Objects.requireNonNull(folder.listFiles())) {
            if (file.isDirectory()) {
                ExportUtil.addFolderToZip("" + folder.getName() + File.separator, file, zos);
                continue;
            }
            LOG.info("\u538b\u7f29\u65f6\u6587\u4ef6\u5927\u5c0f\uff1a" + file.length());
            try (FileInputStream fis = null;){
                int length;
                fis = new FileInputStream(file);
                String path = folder.getName() + File.separator + file.getName();
                if (path.contains("\\")) {
                    path = path.replace("\\", File.separator);
                }
                ZipEntry zipEntry = new ZipEntry(path);
                zos.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zos.write(bytes, 0, length);
                }
            }
        }
    }

    public static Map<String, List<Object>> queryOrgIdToPkidsByFilter(String entityName, QFilter[] qFilter) {
        HashMap<String, List<Object>> orgIdToPkidsMap = new HashMap<String, List<Object>>(516);
        DynamicObjectCollection dyoCollection = QueryServiceHelper.query((String)entityName, (String)"id,org.id as org", (QFilter[])qFilter);
        for (DynamicObject dyo : dyoCollection) {
            String org = dyo.getString("org");
            Long id = dyo.getLong("id");
            List pkids = orgIdToPkidsMap.computeIfAbsent(org, k -> new ArrayList(10));
            pkids.add(id);
        }
        return orgIdToPkidsMap;
    }
}

