/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tcvvt.common.enums.KjGroupCsvEnum;
import kd.taxc.tcvvt.common.util.StringUtil;

public class ExportUtilNew {
    private static final Log LOG = LogFactory.getLog(ExportUtilNew.class);
    public static final String CSV = ".csv";
    private static final String CSV_PATH = "/exportcsv/";
    private static final char separator = ',';
    private static final char quotechar = '\"';
    private static final String lineEnd = "\n";

    public static String downloadCsv(String fileName, InputStream inputStream) {
        try {
            return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".zip", inputStream, 5000);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }

    public static void writeNext(String[] nextLine, boolean applyQuotesToAll, StringBuilder appendable) {
        if (nextLine == null) {
            return;
        }
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                appendable.append(',');
            }
            if ((nextElement = StringUtil.defaultString((String)nextLine[i])) == null) continue;
            Boolean stringContainsSpecialCharacters = ExportUtilNew.stringContainsSpecialCharacters(nextElement);
            ExportUtilNew.appendQuoteCharacterIfNeeded(applyQuotesToAll, appendable, stringContainsSpecialCharacters);
            if (stringContainsSpecialCharacters.booleanValue()) {
                ExportUtilNew.processLine(nextElement, appendable);
            } else {
                appendable.append(nextElement);
            }
            ExportUtilNew.appendQuoteCharacterIfNeeded(applyQuotesToAll, appendable, stringContainsSpecialCharacters);
        }
        appendable.append(lineEnd);
    }

    private static void appendQuoteCharacterIfNeeded(boolean applyQuotesToAll, StringBuilder appendable, Boolean stringContainsSpecialCharacters) {
        if (applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) {
            appendable.append('\"');
        }
    }

    private static boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(34) != -1 || line.indexOf(44) != -1 || line.contains(lineEnd) || line.contains("\r");
    }

    private static void processLine(String nextElement, StringBuilder appendable) {
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            ExportUtilNew.processCharacter(appendable, nextChar);
        }
    }

    private static void processCharacter(StringBuilder appendable, char nextChar) {
        if (ExportUtilNew.checkCharactersToEscape(nextChar)) {
            appendable.append('\"');
        }
        appendable.append(nextChar);
    }

    private static boolean checkCharactersToEscape(char nextChar) {
        return nextChar == '\"';
    }

    public static void writeHead(String entityName, KjGroupCsvEnum kjGroupCsvEnum, String absolutePath) {
        String fields = "ND_DM,KJQJ,PZZ,PZH,FLH,PZ_RQ,FLZY,KM_DM,JFJE,DFJE,WBBZ,WBJFJE,WBDFJE,SHR,ZDR,JZR,CN,FJS\n";
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(absolutePath, true), "GBK"));){
            bufferedWriter.write(fields);
            bufferedWriter.flush();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("writeHead error:", e.toString()), new Object[0]);
        }
    }

    public static final Map<String, String> getKjqjMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("01", "1");
        map.put("02", "2");
        map.put("03", "3");
        map.put("04", "4");
        map.put("05", "5");
        map.put("06", "6");
        map.put("07", "7");
        map.put("08", "8");
        map.put("09", "9");
        map.put("10", "10");
        map.put("11", "11");
        map.put("12", "12");
        return map;
    }

    public static String getFileServiceUploadPath() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        Calendar cal = Calendar.getInstance();
        String year = String.valueOf(cal.get(1));
        int tempMonth = cal.get(2) + 1;
        String month = tempMonth >= 10 ? String.valueOf(tempMonth) : "0" + tempMonth;
        int tempDay = cal.get(5);
        String day = tempDay >= 10 ? String.valueOf(tempDay) : "0" + tempDay;
        String dateString = year + month + day;
        return tenantId + "/" + accountId + "/" + dateString;
    }
}

