/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.TcvvtTemplateUtils;
import kd.taxc.tcvvt.common.util.table.YbnsrService;
import org.apache.commons.lang3.ObjectUtils;

public class MainReportUtil {
    private static final String TCTB_TAX_MAIN = "tctb_tax_main";
    public static final String TCVVT_MESSAGE = "tcvvt_message";

    public static boolean isImport(String orgId, String startdateStr, String enddateStr) {
        if (StringUtil.isEmpty((CharSequence)orgId) || StringUtil.isEmpty((CharSequence)startdateStr) || StringUtil.isEmpty((CharSequence)enddateStr)) {
            return false;
        }
        boolean isImport = false;
        DynamicObject queryNsrxx = MainReportUtil.queryNsrxx(orgId, startdateStr, enddateStr);
        if (queryNsrxx != null && "2".equalsIgnoreCase(queryNsrxx.getString("datatype"))) {
            isImport = true;
        }
        return isImport;
    }

    public static DynamicObject queryNsrxx(String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        DynamicObject template = MainReportUtil.getTemplateType(orgId, startdate, enddate);
        HashMap<String, Object> extendParams = new HashMap<String, Object>(2);
        String type = ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : null;
        extendParams.put("templateid", ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : null);
        return YbnsrService.queryYbnsr(orgId, type, startdate, enddate, extendParams);
    }

    public static DynamicObject getTemplateType(String orgid, String sksqq, String sksqz) {
        Date start = DateUtils.stringToDate(sksqq, "yyyy-MM-dd");
        Date end = DateUtils.stringToDate(sksqz, "yyyy-MM-dd");
        return TcvvtTemplateUtils.getTemplateType(orgid, start, end);
    }

    public static DynamicObject getTcvvtMessage(String orgid, String sksqq, String sksqz) {
        Date start = DateUtils.stringToDate(sksqq, "yyyy-MM-dd");
        Date end = DateUtils.stringToDate(sksqz, "yyyy-MM-dd");
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)start);
        QFilter endFilter = new QFilter("enddate", "=", (Object)end);
        DynamicObject template = TcvvtTemplateUtils.getTemplateType(orgid, DateUtils.stringToDate(sksqq), DateUtils.stringToDate(sksqz));
        QFilter nsrtypeQ = new QFilter("type", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : null);
        QFilter templateidQ = new QFilter("templateid", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : null);
        return BusinessDataServiceHelper.loadSingle((String)TCVVT_MESSAGE, (String)"id,status,orgid,startdate,enddate,reporttype,accountingstandards,newrule,registeraddress,declaretype,entryentity.selectid", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, nsrtypeQ, templateidQ});
    }

    public static Long generateSBBId(String entityName) {
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            return DBServiceHelper.genLongIds((String)entityName, (int)1)[0];
        }
        return DBServiceHelper.genLongIds((String)"tcvat_nsrxx", (int)1)[0];
    }

    public static boolean isOpenTaxMainFinancial(String orgId) {
        boolean isOpen = false;
        if (StringUtil.isBlank((CharSequence)orgId)) {
            return isOpen;
        }
        DynamicObject dynamicObject = TcvvtCategoryInfoBusinessImpl.querycwbbCategoryInfoByOrgId((String)orgId);
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return isOpen;
        }
        if (dynamicObject.getBoolean("enable")) {
            isOpen = true;
        }
        return isOpen;
    }

    public static boolean isZeroDeclareOrg(String orgId) {
        boolean isZeroDeclareOrg = false;
        Boolean temp = (Boolean)SystemParamUtil.getAppParameter((String)"tcvvt", (String)"zerodeclare", (long)Long.parseLong(orgId));
        if (ObjectUtils.isNotEmpty((Object)temp) && temp.booleanValue()) {
            isZeroDeclareOrg = true;
        }
        return isZeroDeclareOrg;
    }

    public static Map<Long, Object> queryZeroDeclareOrgs(List<Long> orgIds) {
        Map appParameterBatch = SystemParamUtil.getAppParameterBatch((String)"tcvvt", (String)"zerodeclare", orgIds);
        return appParameterBatch;
    }

    public static boolean isZeroDeclareOrg(String orgId, Date skssqq, Date skssqz) {
        String conditionjson;
        DynamicObject template = TcvvtTemplateUtils.getTemplateType(orgId, skssqq, skssqz);
        if (ObjectUtils.isNotEmpty((Object)template) && StringUtil.isNotEmpty((CharSequence)(conditionjson = template.getString("conditionjson"))) && conditionjson.contains("zerodeclare")) {
            return true;
        }
        return MainReportUtil.isZeroDeclareOrg(orgId);
    }

    public static String getReportTypeByOrgId(String orgId) {
        String reportType = null;
        QFilter orgIdFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter taxtypeFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)"qysds");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TCTB_TAX_MAIN, (String)"categoryentryentity.deadline", (QFilter[])new QFilter[]{orgIdFilter, taxtypeFilter});
        if (dynamicObject != null) {
            reportType = dynamicObject.getString("categoryentryentity.deadline");
        }
        if (StringUtil.isEmpty(reportType)) {
            reportType = "ajsb";
        }
        return reportType;
    }

    public static void allRequiredFieldValidator(String orgId) {
        QFilter taxationsysQ;
        QFilter orgFilter;
        DynamicObject dTctb;
        if (StringUtils.isNotBlank((CharSequence)orgId) && (dTctb = QueryServiceHelper.queryOne((String)TCTB_TAX_MAIN, (String)"maincompany,taxoffice,accountingstandards,registertype,registertime,registeraddress,actualaddress,codeandname", (QFilter[])new QFilter[]{orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), taxationsysQ = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId())})) != null) {
            String orgname = dTctb.getString("maincompany");
            String taxoffice = dTctb.getString("taxoffice");
            String registertype = dTctb.getString("registertype");
            String registertime = dTctb.getString("registertime");
            String registeraddress = dTctb.getString("registeraddress");
            String codeandname = dTctb.getString("codeandname");
            String actualaddress = dTctb.getString("actualaddress");
            String admindivisionObject = dTctb.getString("accountingstandards");
            if (StringUtils.isEmpty((CharSequence)registeraddress) || "0".equalsIgnoreCase(admindivisionObject) || "0".equalsIgnoreCase(taxoffice) || "0".equalsIgnoreCase(registertype) || StringUtils.isEmpty((CharSequence)registertime) || "0".equalsIgnoreCase(codeandname) || StringUtils.isEmpty((CharSequence)actualaddress)) {
                ErrorCode errorCode = new ErrorCode("allRequiredField", String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"MainReportUtil_0", (String)"taxc-tcvvt", (Object[])new Object[0]), orgname));
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
    }
}

