/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.util.DateUtils;

public class OrgUtils {
    public static final String FORM_ORG_GROUP = "tctb_org_group_latest";
    private static final String FIELD_EFFECTDATE = "effectdate";
    private static final String FIELD_INVALIDDATE = "invaliddate";

    public static DynamicObjectCollection queryTaxOrg(String selectFields, QFilter filter) {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"tctb_tax_main", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return taxOrgs;
    }

    public static QFilter getQFilter(Date enddate) {
        QFilter q = new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(FIELD_INVALIDDATE, ">=", (Object)DateUtils.getLastDateOfMonth1(enddate));
        q = q.or(new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(QFilter.isNull((String)FIELD_INVALIDDATE)));
        return q;
    }

    public static List<ComboItem> getComboItems(List<Map<String, String>> orgList) {
        String orgID = String.valueOf(RequestContext.get().getOrgId());
        int index = -1;
        int orgIndex = -1;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgList.size());
        for (Map<String, String> map : orgList) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(map.get("name")));
            item.setValue(map.get("id"));
            combos.add(item);
            if (!orgID.equals(item.getValue())) continue;
            orgIndex = index;
        }
        if (orgIndex > 0) {
            Collections.swap(combos, 0, orgIndex);
        }
        return combos;
    }
}

