/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.taxc.tcvvt.common.util.EmptyCheckUtils;
import kd.taxc.tcvvt.common.util.MD5;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    private static Pattern REGEX_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");

    public static String getMatchContent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        Matcher matcher = REGEX_PATTERN.matcher(content);
        StringBuilder info = new StringBuilder();
        while (matcher.find()) {
            info.append(matcher.group(1));
            info.append(',');
        }
        if (info.length() > 0) {
            info.deleteCharAt(info.length() - 1);
        } else {
            info.append(content);
        }
        return info.toString();
    }

    public static String fillCharAtLeft(Object obj, int length, char fillChar) {
        return StringUtil.fillCharByPosition(obj, length, fillChar, "left");
    }

    public static String fillCharAtRight(Object obj, int length, char fillChar) {
        return StringUtil.fillCharByPosition(obj, length, fillChar, "right");
    }

    public static String fillCharByPosition(Object obj, int length, char fillChar, String type) {
        if (EmptyCheckUtils.isEmpty(obj)) {
            return String.valueOf(obj);
        }
        String str = String.valueOf(obj);
        if (str.trim().length() >= length) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int fillLength = length - str.length();
        for (int i = 0; i < fillLength; ++i) {
            sb.append(fillChar);
        }
        return "left".equalsIgnoreCase(type) ? sb.append(str).toString() : sb.insert(0, str).toString();
    }

    public static String getMd5(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            content = "";
        }
        content = content.toLowerCase().replaceAll("\\s*", "");
        return MD5.md5(content);
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isNumeric(String str) {
        if (null == str) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(\\-|\\+)?\\d+(\\.\\d+)?$");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isOnlyNumber(String str) {
        if (null == str) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\d+");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

