/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.table.YbnsrService;

public class TcvvtTemplateUtils {
    private static Log LOGGER = LogFactory.getLog(TcvvtTemplateUtils.class);
    private static final String ENTITY_TEMPLATE = "bdtaxr_template_main";
    private static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String SPLIT_STRING_SAVE = "#";
    public static final List<String> TEMPALTE_TYPE = Arrays.asList("FR0001", "FR0002", "FR0003", "FR0004", "FR0011");
    private static final List<String> provinces = new ArrayList<String>();

    public static DynamicObject getTemplateType(String orgid, Date sksqq, Date sksqz) {
        String enddateStr;
        QFilter taxationsysQ;
        QFilter orgIdFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        DynamicObject taxMainInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"tctb_tax_main", (QFilter[])new QFilter[]{orgIdFilter, taxationsysQ = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId())});
        if (null == taxMainInfo) {
            return null;
        }
        String startdateStr = DateUtils.format(sksqq, "yyyy-MM-dd");
        DynamicObjectCollection collection = YbnsrService.queryYbnsr(orgid, TEMPALTE_TYPE, startdateStr, enddateStr = DateUtils.format(sksqz, "yyyy-MM-dd"), Collections.emptyMap());
        if (collection.size() == 1) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)collection.get(0)).getLong("templateid"), (String)ENTITY_TEMPLATE);
            return dynamicObject;
        }
        if (collection.size() > 1) {
            return null;
        }
        String projectname = taxMainInfo.getString("accountingstandards.projectname");
        String newrule = taxMainInfo.getString("newrule");
        Long registeraddress = taxMainInfo.getLong("registeraddress");
        long accountingstandards = taxMainInfo.getLong("accountingstandards.id");
        if (accountingstandards == 1072508277482326016L && (StringUtil.isEmpty((CharSequence)newrule) || "empty".equalsIgnoreCase(newrule))) {
            ErrorCode errorCode = new ErrorCode("allRequiredField", ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u9009\u62e9\u7ef4\u62a4\u201c\u6267\u884c\u65b0\u51c6\u5219\u201d\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u518d\u8fdb\u884c\u586b\u62a5\u3002", (String)"TcvvtTemplateUtils_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
            throw new KDBizException(errorCode, new Object[0]);
        }
        DynamicObject admindivisionObject = BusinessDataServiceHelper.loadSingleFromCache((Object)registeraddress, (String)"bd_admindivision");
        MainReportUtil.allRequiredFieldValidator(orgid);
        String registeraddressName = admindivisionObject.getString("fullname");
        String templateNumber = "";
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TcvvtTemplateUtils_0", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname) && "no".equalsIgnoreCase(newrule)) {
            templateNumber = "FR0001";
        }
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TcvvtTemplateUtils_0", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname) && "yes".equalsIgnoreCase(newrule)) {
            templateNumber = "FR0002";
            Object registeraddressInProvinces = TcvvtTemplateUtils.registeraddressInProvinces(registeraddressName);
            if (((Boolean)registeraddressInProvinces).booleanValue()) {
                templateNumber = "FR0005";
            }
        }
        if (ResManager.loadKDString((String)"\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TcvvtTemplateUtils_1", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0003";
        }
        if (ResManager.loadKDString((String)"\u4f01\u4e1a\u4f1a\u8ba1\u5236\u5ea6", (String)"TcvvtTemplateUtils_2", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0004";
        }
        if (ResManager.loadKDString((String)"\u94f6\u884c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TcvvtTemplateUtils_3", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0011";
        }
        if (MainReportUtil.isZeroDeclareOrg(orgid)) {
            switch (templateNumber) {
                case "FR0001": {
                    templateNumber = "FR0006";
                    break;
                }
                case "FR0002": {
                    templateNumber = "FR0007";
                    break;
                }
                case "FR0003": {
                    templateNumber = "FR0008";
                    break;
                }
                case "FR0004": {
                    templateNumber = "FR0009";
                    break;
                }
                case "FR0005": {
                    templateNumber = "FR0010";
                }
            }
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)templateNumber);
        return BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_TEMPLATE, (QFilter[])new QFilter[]{numberFilter});
    }

    public static DynamicObject getTemplateType(Long accountingStandardId, String newrule, String orgid, Date sksqq, Date sksqz) {
        String templateType = null;
        QFilter accountingStandardIdFilter = new QFilter("id", "=", (Object)accountingStandardId);
        DynamicObject accountingStandard = QueryServiceHelper.queryOne((String)"tpo_tccit_bizdef_kjzz", (String)"id,projectname", (QFilter[])new QFilter[]{accountingStandardIdFilter});
        if (accountingStandard == null) {
            return null;
        }
        String projectname = accountingStandard.getString("projectname");
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TcvvtTemplateUtils_0", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname) && "no".equalsIgnoreCase(newrule)) {
            templateType = "FR0001";
        }
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TcvvtTemplateUtils_0", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname) && "yes".equalsIgnoreCase(newrule)) {
            DynamicObject templateObj = TemplateUtils.getTemplateObjectByConfig((String)"FR0002", (String)orgid, (Date)sksqq, (Date)sksqz);
            if (Objects.isNull(templateObj)) {
                return null;
            }
            templateType = templateObj.getString("number");
        }
        if (ResManager.loadKDString((String)"\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TcvvtTemplateUtils_1", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname)) {
            templateType = "FR0003";
        }
        if (ResManager.loadKDString((String)"\u4f01\u4e1a\u4f1a\u8ba1\u5236\u5ea6", (String)"TcvvtTemplateUtils_2", (String)"taxc-tcvvt", (Object[])new Object[0]).equals(projectname)) {
            templateType = "FR0004";
        }
        QFilter typeFilter = new QFilter("number", "=", (Object)templateType);
        return QueryServiceHelper.queryOne((String)ENTITY_TEMPLATE, (String)"id,number,name,type,startdate,enddate,conditionjson,general", (QFilter[])new QFilter[]{typeFilter});
    }

    public static Boolean registeraddressInProvinces(String registeraddress) {
        for (String province : provinces) {
            if (!registeraddress.contains(province)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static {
        provinces.add(ResManager.loadKDString((String)"\u5c71\u897f\u7701", (String)"TcvvtTemplateUtils_9", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5317\u4eac\u5e02", (String)"TcvvtTemplateUtils_10", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u8d35\u5dde\u7701", (String)"TcvvtTemplateUtils_11", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a", (String)"TcvvtTemplateUtils_12", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6e56\u5317\u7701", (String)"TcvvtTemplateUtils_13", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6cb3\u5357\u7701", (String)"TcvvtTemplateUtils_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u9655\u897f\u7701", (String)"TcvvtTemplateUtils_6", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6c5f\u82cf\u7701", (String)"TcvvtTemplateUtils_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5e7f\u4e1c\u7701", (String)"TcvvtTemplateUtils_14", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u798f\u5efa\u7701", (String)"TcvvtTemplateUtils_15", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u9752\u6d77\u7701", (String)"TcvvtTemplateUtils_16", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5929\u6d25\u5e02", (String)"TcvvtTemplateUtils_17", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6c5f\u897f\u7701", (String)"TcvvtTemplateUtils_18", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a", (String)"TcvvtTemplateUtils_19", (String)"taxc-tcvvt", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6e56\u5357\u7701", (String)"TcvvtTemplateUtils_20", (String)"taxc-tcvvt", (Object[])new Object[0]));
    }
}

