/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util.datasource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.TcvvtTemplateUtils;
import kd.taxc.tcvvt.common.util.datasource.TcvvtAccountTask;
import kd.taxc.tcvvt.common.util.engine.EngineModel;
import kd.taxc.tcvvt.common.util.engine.EngineTask;
import kd.taxc.tcvvt.common.util.engine.PartitionSaveTask;
import kd.taxc.tcvvt.common.util.threadpools.ThreadPoolsService;
import org.apache.commons.lang3.ObjectUtils;

public class TcvvtAccountDataGatherEngine
extends EngineTask<EngineModel, List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(TcvvtAccountDataGatherEngine.class);
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORG = "org";
    public static final String TCVVT_MESSAGE = "tcvvt_message";
    private static final String logTag = "taxc-engine:  ";

    @Override
    public List<DynamicObject> execute() {
        Object model = this.getEngineModel();
        this.deleteData((EngineModel)model);
        return this.runEngine((EngineModel)model);
    }

    private void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate(model.getStartDate());
        Date endDate = DateUtils.stringToDate(model.getEndDate());
        QFilter skssqqzFilter = new QFilter(SKSSQQ, "=", (Object)startDate).and(new QFilter(SKSSQZ, "=", (Object)endDate));
        DeleteServiceHelper.delete((String)"tcvvt_main_account", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_detail", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_adjust", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_adjust_tp", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
    }

    private List<DynamicObject> runEngine(EngineModel engineModel) {
        try {
            long start = System.currentTimeMillis();
            List<DynamicObject> dynamicObjects = this.calSummaryAccountList(engineModel);
            logger.info("{},\u7ec4\u7ec7\uff1a{},\u6240\u5c5e\u671f\uff1a{},{}\u7ed3\u675f\u6267\u884c\u8d22\u52a1\u62a5\u8868\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a{}", new Object[]{logTag, engineModel.getOrgId(), engineModel.getStartDate(), engineModel.getEndDate(), System.currentTimeMillis() - start});
            return dynamicObjects;
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u8d22\u52a1\u62a5\u8868\u53d6\u6570\u51fa\u73b0\u5f02\u5e38:" + exceptionStackTraceMessage);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private List<DynamicObject> calSummaryAccountList(EngineModel engineModel) throws Exception {
        long time = System.currentTimeMillis();
        Date startDate = DateUtils.stringToDate(engineModel.getStartDate());
        Date endDate = DateUtils.stringToDate(engineModel.getEndDate());
        List<DynamicObject> ruleList = this.getAccessConfigList(Long.parseLong(engineModel.getOrgId()), startDate, endDate);
        logger.info("{}\u6b65\u9aa41\uff1a\u83b7\u53d6\u6240\u6709\u76f8\u5173\u53d6\u6570\u914d\u7f6e\u7ed3\u675f,\u83b7\u5f97\u53d6\u6570\u89c4\u5219\u6761\u6570\uff1a{},\u8017\u65f6{}", new Object[]{logTag, ruleList.size(), System.currentTimeMillis() - time});
        if (CollectionUtils.isEmpty(ruleList)) {
            return new ArrayList<DynamicObject>();
        }
        time = System.currentTimeMillis();
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        TcvvtAccountTask tcvvtAccountTask = new TcvvtAccountTask(engineModel, ruleList, userId);
        List<Future<Object>> submitReturnFuture = ThreadPoolsService.getInstance().submitReturnFuture(tcvvtAccountTask);
        List<DynamicObject> accountingList = this.getFutureList(submitReturnFuture);
        List<DynamicObject> detailList = tcvvtAccountTask.detailList;
        logger.info("{}\u6b65\u9aa42\uff1a\u83b7\u53d6\u79d1\u76ee\u8bb0\u5f55{}\u6761\uff0c\u660e\u7ec6\u8bb0\u5f55{}\u6761,\u8017\u65f6\uff1a{}", new Object[]{logTag, accountingList.size(), detailList.size(), System.currentTimeMillis() - time});
        time = System.currentTimeMillis();
        ThreadPoolsService.getInstance().submit(new PartitionSaveTask(accountingList));
        ThreadPoolsService.getInstance().submit(new PartitionSaveTask(detailList));
        logger.info("{}\u6b65\u9aa43:\u4fdd\u5b58\u79d1\u76ee\u8bb0\u5f55{}\u6761\uff0c\u660e\u7ec6\u8bb0\u5f55{}\u6761\uff0c\u8017\u65f6:{}", new Object[]{logTag, accountingList.size(), detailList.size(), System.currentTimeMillis() - time});
        return accountingList;
    }

    private List<DynamicObject> getAccessConfigList(Long orgId, Date start, Date end) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgId);
        QFilter startFilter = new QFilter("startdate", "=", (Object)start);
        QFilter endFilter = new QFilter("enddate", "=", (Object)end);
        DynamicObject template = TcvvtTemplateUtils.getTemplateType(String.valueOf(orgId), start, end);
        QFilter nsrtypeQ = new QFilter("type", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : null);
        QFilter templateidQ = new QFilter("templateid", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : null);
        Long accountingstandard = null;
        DynamicObject massageTp = BusinessDataServiceHelper.loadSingle((String)TCVVT_MESSAGE, (String)"accountingstandards", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, nsrtypeQ, templateidQ});
        if (massageTp != null && massageTp.getDynamicObject("accountingstandards") != null) {
            accountingstandard = massageTp.getDynamicObject("accountingstandards").getLong("id");
        } else {
            DynamicObject dTctb = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"accountingstandards", (QFilter[])new QFilter[]{orgFilter});
            if (dTctb != null) {
                accountingstandard = dTctb.getLong("accountingstandards");
            }
        }
        if (accountingstandard == null) {
            return new ArrayList<DynamicObject>();
        }
        String declareType = "%ayajsb%";
        if (DateUtils.isYearReport(start, end).booleanValue()) {
            declareType = "%ansb%";
        }
        orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter standardQuery = new QFilter("accountstandard", "=", (Object)accountingstandard);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter privateFilter = new QFilter("ruletype", "=", (Object)"private");
        QFilter declareTypeFilter = new QFilter("declaretype", "like", (Object)declareType);
        DynamicObjectCollection privateAccessConfigList = QueryServiceHelper.query((String)"tcvvt_accessconfig", (String)"id,accessproject", (QFilter[])new QFilter[]{orgFilter, enableFilter, standardQuery, statusFilter, privateFilter, declareTypeFilter});
        List<DynamicObject> removeDuplicate = this.removeDuplicate(privateAccessConfigList);
        DynamicObject[] privateRules = BusinessDataServiceHelper.load((Object[])removeDuplicate.stream().map(a -> a.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvvt_accessconfig"));
        List privateAccessConfigIds = Arrays.stream(privateRules).map(m -> m.getDynamicObject("accessproject").getString("id")).collect(Collectors.toList());
        ArrayList<DynamicObject> finalRules = new ArrayList<DynamicObject>(Arrays.asList(privateRules));
        List<DynamicObject> shardingRules = this.getShardingRules(orgId, accountingstandard, declareType);
        if (CollectionUtils.isEmpty(shardingRules)) {
            return finalRules;
        }
        List fiterShardingRules = shardingRules.stream().filter(accessConfig -> {
            String accessprojectId = accessConfig.getDynamicObject("accessproject").getString("id");
            return !privateAccessConfigIds.contains(accessprojectId);
        }).collect(Collectors.toList());
        finalRules.addAll(fiterShardingRules);
        return finalRules;
    }

    private List<DynamicObject> getShardingRules(Long orgId, Long accountingstandard, String declareType) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter standardQuery = new QFilter("accountstandard", "=", (Object)accountingstandard);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter privateFilter = new QFilter("ruletype", "=", (Object)"public");
        QFilter declareTypeFilter = new QFilter("declaretype", "like", (Object)declareType);
        DynamicObjectCollection publicAccessConfigList = QueryServiceHelper.query((String)"tcvvt_accessconfig", (String)"id,accessproject", (QFilter[])new QFilter[]{enableFilter, standardQuery, statusFilter, privateFilter, declareTypeFilter});
        if (publicAccessConfigList == null || publicAccessConfigList.size() == 0) {
            return new ArrayList<DynamicObject>();
        }
        List publicAccessConfigIds = publicAccessConfigList.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("orgentity.org", "=", (Object)orgId);
        QFilter ruleFilter = new QFilter("ruleentity.rule", "in", publicAccessConfigIds);
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcvvt_sharingplan", (String)"ruleentity.rule as ruleid", (QFilter[])new QFilter[]{orgFilter, ruleFilter});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])sharingRules.stream().map(a -> a.get("ruleid")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvvt_accessconfig"));
        return Arrays.asList(dynamicObjects);
    }

    private List<DynamicObject> removeDuplicate(DynamicObjectCollection accessConfigList) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        if (accessConfigList == null) {
            return result;
        }
        ArrayList<String> accessprojectIds = new ArrayList<String>();
        ArrayList<String> duplicateAccessProjectids = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)accessConfigList)) {
            return result;
        }
        for (DynamicObject accessConfig : accessConfigList) {
            String accessproject = accessConfig.getString("accessproject");
            if (!StringUtil.isNotEmpty((CharSequence)accessproject)) continue;
            if (!accessprojectIds.contains(accessproject)) {
                result.add(accessConfig);
                accessprojectIds.add(accessproject);
                continue;
            }
            duplicateAccessProjectids.add(accessproject);
        }
        return result.stream().filter(m -> !duplicateAccessProjectids.contains(m.getString("accessproject"))).collect(Collectors.toList());
    }
}

