/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util.datasource;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.business.customsource.CustomSourceFactory;
import kd.taxc.bdtaxr.common.helper.TaxcCustomSourceDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.tcvvt.common.enums.RuleConfigEnum;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.FilterBuilderUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.engine.EngineModel;
import kd.taxc.tcvvt.common.util.threadpools.Task;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TcvvtAccountTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(TcvvtAccountTask.class);
    private static final String MIAN_DYO_KEY = "main_dyo_key_%s";
    private static final String logTag = "taxc-account-task: ";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORG = "org";
    private BigDecimal reverse = new BigDecimal(-1);
    private int batchSize = 10;
    private List<DynamicObject> rules;
    private Map<String, String> map;
    private Map<String, List<String>> mainList;
    public List<DynamicObject> detailList;
    private Date start;
    private Date end;
    private Map<Long, DynamicObject> filterMap;
    private String taxLimit;
    private HashMap<String, List<Long>> heSuanOrgIdsMap = new HashMap();
    private EngineModel model;
    private String userId;
    private static List<String> filterTable = new ArrayList<String>();

    public TcvvtAccountTask(EngineModel model, List<DynamicObject> rules, String userId) {
        this.detailList = Collections.synchronizedList(new ArrayList());
        this.mainList = Collections.synchronizedMap(new HashMap());
        this.filterMap = Collections.synchronizedMap(new HashMap());
        this.rules = rules;
        this.model = model;
        this.userId = userId;
        this.map = new HashMap<String, String>();
        String startDate = model.getStartDate();
        String endDate = model.getEndDate();
        this.start = DateUtils.stringToDate(startDate);
        this.end = DateUtils.stringToDate(endDate);
        this.taxLimit = DateUtils.getTaxLimit(this.start, this.end);
    }

    @Override
    public List<List<DynamicObject>> getValue() {
        for (DynamicObject rule : this.rules) {
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            for (DynamicObject setting : entryentity) {
                DynamicObject table = setting.getDynamicObject("table");
                String entryName = table.getString("name");
                if (this.heSuanOrgIdsMap.containsKey(entryName)) continue;
                List<Long> orgIds = Collections.singletonList(Long.parseLong(this.model.getOrgId()));
                List<Long> listByRelation = this.getOrgListByRelation(orgIds, DateUtils.stringToDate(this.model.getStartDate(), "yyyy-MM-dd"), DateUtils.stringToDate(this.model.getEndDate(), "yyyy-MM-dd"), table);
                this.heSuanOrgIdsMap.put(entryName, listByRelation);
            }
        }
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)this.model.getDeclareType());
        QFilter formulaname = new QFilter("formula", "like", (Object)"%{P%");
        QFilter formulaTypeFilter = new QFilter("formulatype", "=", (Object)"1");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bdtaxr_formula_edit", (String)"id,formulaname,formulakey", (QFilter[])new QFilter[]{taxTypeFilter, formulaname, formulaTypeFilter});
        for (DynamicObject dyo : dynamicObjectCollection) {
            if (!StringUtil.isOnlyNumber(dyo.getString("formulaname"))) continue;
            this.map.put(dyo.getString("formulaname"), dyo.getString("formulakey"));
        }
        return Lists.partition(this.rules, (int)this.batchSize);
    }

    public List<Long> getOrgListByRelation(List<Long> orgList, Date skssqq, Date skssqz, DynamicObject dataSourceObject) {
        Long tableId = dataSourceObject.getLong("id");
        String entryName = dataSourceObject.getString("name");
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(orgList, (Date)skssqq, (Date)skssqz);
        Map fieldMap = RuleConfigUtils.get((Long)tableId);
        String org = (String)fieldMap.get("orgstate");
        if (null != org) {
            String entityKey = entryName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            orgList = EngineCalcFilterService.getOrgListByRelation((Map)orgRelationMap, orgList, (String)entryName, (String)entityKey, (String)orgFieldName);
        }
        return orgList;
    }

    @Override
    public List<DynamicObject> executor(List<DynamicObject> rules) {
        logger.info("\u5f00\u59cb\u5206\u6279\u8c03\u7528\u53d6\u6570\u914d\u7f6e");
        long l = System.currentTimeMillis();
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(16);
        String orgId = this.model.getOrgId();
        for (DynamicObject rule : rules) {
            String serialNo = UUID.randomUUID().toString();
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvvt_main_account"));
            summary.set(ORG, (Object)orgId);
            summary.set(SKSSQQ, (Object)this.start);
            summary.set(SKSSQZ, (Object)this.end);
            summary.set("datasource", (Object)"system");
            summary.set("creater", (Object)this.userId);
            DynamicObject accessProject = rule.getDynamicObject("accessproject");
            if (accessProject == null) continue;
            summary.set("accessprojectid", (Object)accessProject.getString("id"));
            if (StringUtils.isEmpty((String)this.map.get(accessProject.getString("id")))) continue;
            summary.set("formulakey", (Object)this.map.get(accessProject.getString("id")));
            summary.set("taxlimit", (Object)this.taxLimit);
            summary.set("datasource", (Object)"system");
            summary.set("serialno", (Object)serialNo);
            List<DynamicObject> accountingList = this.getDetailDyos(serialNo, rule, this.start, this.end);
            if (CollectionUtils.isEmpty(accountingList)) continue;
            this.detailList.addAll(accountingList);
            BigDecimal accountingamount = BigDecimal.ZERO;
            BigDecimal amount = this.getAccountingAmount(accountingList);
            accountingamount = accountingamount.add(amount);
            summary.set("fetchamount", (Object)accountingamount.setScale(2, 4));
            summaryList.add(summary);
        }
        logger.info("{}\u5206\u6279\u8c03\u7528\u53d6\u6570\u914d\u7f6e\u7ed3\u675f\uff0c\u8017\u65f6{}", (Object)logTag, (Object)(System.currentTimeMillis() - l));
        return summaryList;
    }

    private BigDecimal getAccountingAmount(List<DynamicObject> accountingList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject invoice : accountingList) {
            totalAmount = totalAmount.add(invoice.getBigDecimal("fetchamount"));
        }
        return totalAmount;
    }

    private List<DynamicObject> getDetailDyos(String serialNo, DynamicObject rule, Date start, Date end) {
        long startTime = System.currentTimeMillis();
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(entryentity.size());
        try {
            for (DynamicObject setting : entryentity) {
                this.fetchData(rule, serialNo, start, end, setting, list);
            }
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("{}:\u8d22\u52a1\u62a5\u8868\u53d6\u6570\u83b7\u53d6\u660e\u7ec6\u6570\u65f6\u51fa\u73b0\u5f02\u5e38:{}", rule.get("number"), (Object)exceptionStackTraceMessage);
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("{}\u5355\u6761\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u7ed3\u675f\u6267\u884c\uff0c\u53d6\u6570\u914d\u7f6e:{},\u8017\u65f6\uff1a{}", new Object[]{logTag, rule.get("number"), costTime});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject getFilterEntryEntity(Long id) {
        if (this.filterMap.containsKey(id)) {
            return this.filterMap.get(id);
        }
        TcvvtAccountTask tcvvtAccountTask = this;
        synchronized (tcvvtAccountTask) {
            if (this.filterMap.containsKey(id)) {
                return this.filterMap.get(id);
            }
            QFilter tableid = new QFilter("id", "=", (Object)id);
            QFilter[] filters = new QFilter[]{tableid};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])filters);
            for (DynamicObject d : collection) {
                if (!"true".equals(d.getString("entryentity.orgstate"))) continue;
                this.filterMap.put(id, d);
                return d;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getMainList(List<Long> orgIds, Date start, Date lastDateOfDay) {
        long time = System.currentTimeMillis();
        String key = orgIds.get(0) + "#" + DateUtils.format(start, "yyyy-MM-dd") + "#" + DateUtils.format(lastDateOfDay, "yyyy-MM-dd");
        List<String> sbbIds = this.mainList.get(String.format(MIAN_DYO_KEY, key));
        if (!CollectionUtils.isEmpty(sbbIds)) {
            return sbbIds;
        }
        TcvvtAccountTask tcvvtAccountTask = this;
        synchronized (tcvvtAccountTask) {
            sbbIds = this.mainList.get(String.format(MIAN_DYO_KEY, key));
            if (CollectionUtils.isEmpty(sbbIds)) {
                QFilter orgFilter = new QFilter(ORG, "in", orgIds);
                QFilter skssqqFilter = new QFilter(SKSSQQ, ">=", (Object)start);
                QFilter skssqzFilter = new QFilter(SKSSQZ, "<=", (Object)lastDateOfDay);
                DynamicObjectCollection financeMainConList = QueryServiceHelper.query((String)"tdm_finance_main", (String)"id", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter});
                sbbIds = financeMainConList.stream().map(m -> m.getString("id")).collect(Collectors.toList());
                this.mainList.put(String.format(MIAN_DYO_KEY, key), sbbIds);
                logger.info("{}\u521d\u59cb\u5316sbbid\u53d6\u6570\u6761\u4ef6,\u8017\u65f6:{}", (Object)logTag, (Object)(System.currentTimeMillis() - time));
            }
            logger.info("{}\u5f97\u5230sbbid\u53d6\u6570\u6761\u4ef6\uff1a{}", (Object)logTag, (Object)(System.currentTimeMillis() - time));
            return sbbIds;
        }
    }

    private void fetchData(DynamicObject rule, String serialNo, Date start, Date end, DynamicObject setting, List<DynamicObject> list) {
        DynamicObject acountDetail = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvvt_main_detail"));
        acountDetail.set("ruleid", (Object)String.valueOf(rule.get("id")));
        acountDetail.set(ORG, (Object)this.model.getOrgId());
        acountDetail.set("serialno", (Object)serialNo);
        acountDetail.set(SKSSQQ, (Object)start);
        acountDetail.set(SKSSQZ, (Object)end);
        acountDetail.set("filtercondition", setting.get("filtercondition"));
        DynamicObject table = setting.getDynamicObject("table");
        if (table == null) {
            return;
        }
        DynamicObject amountfield = setting.getDynamicObject("amountfield");
        acountDetail.set("amountfield", (Object)amountfield.getLong("id"));
        acountDetail.set("datadirection", setting.get("datadirection"));
        acountDetail.set("bizname", setting.get("bizname"));
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        String amountField = setting.getDynamicObject("amountfield").getString("fieldname");
        String entryName = table.getString("name");
        if ("gl_voucher".equalsIgnoreCase(entryName)) {
            amountField = "entries." + amountField;
        }
        String fieldSubName = setting.getDynamicObject("amountfield").getString("fieldsubname");
        acountDetail.set("table", (Object)table.getLong("id"));
        String conditionJson = setting.getString("conditionjson");
        String advancedconf = setting.getString("advancedconfjson");
        ImmutablePair<Date, Date> dataPair = this.setQueryDateByAdvanceConf(start, end, advancedconf);
        Date newStartdate = (Date)dataPair.left;
        Date newEnddate = (Date)dataPair.right;
        DynamicObject orgstate = this.getFilterEntryEntity(table.getLong("id"));
        if (orgstate == null) {
            return;
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        String tableName = entryName;
        DynamicObjectCollection accountingList = null;
        if (StringUtils.isNotEmpty((String)conditionJson)) {
            String sourceTableName;
            String string = sourceTableName = !"tdm_finance_main".equals(entryName) ? entryName : fieldSubName;
            if (!"gl_balance".equals(entryName)) {
                filterList.add(FilterBuilderUtils.buildFilter(conditionJson, sourceTableName));
            }
        }
        List<Long> heSuanOrgs = this.heSuanOrgIdsMap.get(tableName);
        QFilter effectdate = new QFilter("effectdate", "<=", (Object)start);
        QFilter invaliddate = new QFilter("invaliddate", ">=", (Object)end).or(new QFilter("invaliddate", "is null", null));
        QFilter taxtype = new QFilter("taxtype", "=", (Object)"cwbb");
        QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter status = new QFilter("status", "=", (Object)"2");
        QFilter orgid = new QFilter("orgrow.orgid", "=", (Object)Long.parseLong(this.model.getOrgId()));
        QFilter declaration = new QFilter("orgrow.declaration", "=", (Object)"2");
        DynamicObject group = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"id", (QFilter[])new QFilter[]{effectdate, invaliddate, taxtype, billstatus, status, orgid, declaration});
        List<Object> orgids = new ArrayList();
        Boolean isGroup = false;
        if (!ObjectUtils.isEmpty((Object)group)) {
            QFilter groupid = new QFilter("id", "=", (Object)group.getLong("id"));
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.orgid as orgid", (QFilter[])new QFilter[]{groupid});
            orgids = orgs.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
            isGroup = true;
        }
        if (isGroup.booleanValue()) {
            heSuanOrgs.addAll(orgids);
        }
        if (!"gl_balance".equals(entryName)) {
            if ("gl_voucher".equals(entryName)) {
                filterList.add(new QFilter(orgstate.getString("entryentity.fieldname"), "in", heSuanOrgs));
                filterList.add(new QFilter("bookeddate", ">=", dataPair.left));
                filterList.add(new QFilter("bookeddate", "<=", dataPair.right));
            } else if ("tdm_balance_new".equals(entryName) || "tdm_recording_voucher_new".equals(entryName)) {
                filterList.add(new QFilter(orgstate.getString("entryentity.fieldname"), "in", heSuanOrgs));
                filterList.add(new QFilter("accountyear", "=", (Object)DateUtils.format((Date)dataPair.right, "yyyy")));
                int monthStart = DateUtils.getMonthOfDate((Date)dataPair.left);
                int monthEnd = DateUtils.getMonthOfDate((Date)dataPair.right);
                ArrayList<String> accountperiodList = new ArrayList<String>(2);
                for (int monthInt = monthStart; monthInt <= monthEnd; ++monthInt) {
                    String monthOfFormat = String.format("%02d", monthInt);
                    accountperiodList.add(monthOfFormat);
                }
                filterList.add(new QFilter("accountperiod", "in", accountperiodList));
            } else if ("tdm_finance_main".equals(entryName)) {
                tableName = fieldSubName;
                Date lastDateOfDay = DateUtils.getDayLast((Date)dataPair.getRight());
                List<String> sbbIds = this.getMainList(heSuanOrgs, (Date)dataPair.getLeft(), lastDateOfDay);
                if (sbbIds != null && !sbbIds.isEmpty() && !StringUtils.isEmpty((String)fieldSubName)) {
                    QFilter filter = new QFilter("sbbid", "in", sbbIds);
                    filterList.add(filter);
                } else {
                    filterList.add(new QFilter("sbbid", "is null", null));
                }
            }
        }
        BigDecimal sum = BigDecimal.ZERO;
        if ("gl_balance".equals(entryName)) {
            sum = TaxcCustomSourceDataServiceHelper.queryBizDataRetSum((Long)Long.parseLong(this.model.getOrgId()), (Date)start, (Date)end, (Long)table.getLong("id"), (String)amountField, (String)entryName, (String)conditionJson, (String)advancedconf, null);
        } else if ("tdm_balance_new".equalsIgnoreCase(entryName)) {
            sum = TaxcCustomSourceDataServiceHelper.queryBizDataRetSum(heSuanOrgs, (Date)start, (Date)end, (long)table.getLong("id"), (String)amountField, (String)fieldSubName, (String)conditionJson, (String)advancedconf);
        } else if (filterTable.contains(tableName)) {
            Iterator categoty = null;
            sum = CustomSourceFactory.getInstance().queryBizDataRetSum(Long.valueOf(Long.parseLong(this.model.getOrgId())), start, end, Long.valueOf(table.getLong("id")), amountField, entryName, conditionJson, advancedconf, (Long)((Object)categoty));
        } else {
            accountingList = QueryServiceHelper.query((String)tableName, (String)amountField, (QFilter[])filterList.toArray(new QFilter[0]));
            for (DynamicObject dyo : accountingList) {
                sum = sum.add(dyo.getBigDecimal(amountField));
            }
        }
        BigDecimal numAfterPositive = Boolean.TRUE.equals(setting.getBoolean("absolute")) ? sum.abs() : sum;
        String dataDirection = setting.getString("datadirection");
        detailTotalAmount = "positive".equals(dataDirection) ? numAfterPositive : numAfterPositive.multiply(this.reverse);
        acountDetail.set("fetchamount", (Object)detailTotalAmount);
        acountDetail.set("absolute", (Object)setting.getString("absolute"));
        list.add(acountDetail);
    }

    private ImmutablePair<Date, Date> setQueryDateByAdvanceConf(Date startdate, Date enddate, String advancedconf) {
        if (advancedconf.equals(RuleConfigEnum.CUMULATIVE.getRuleConfigCode())) {
            startdate = DateUtils.getFirstDateOfYear(startdate);
        }
        if (advancedconf.equals(RuleConfigEnum.TOBEGIN.getRuleConfigCode())) {
            startdate = DateUtils.getFirstDateOfMonth(startdate);
            enddate = DateUtils.getLastDateOfMonth(startdate);
        }
        if (advancedconf.equals(RuleConfigEnum.TOEND.getRuleConfigCode())) {
            startdate = DateUtils.getFirstDateOfMonth(enddate);
            enddate = DateUtils.getLastDateOfMonth(enddate);
        }
        if (advancedconf.equals(RuleConfigEnum.SQQMS.getRuleConfigCode())) {
            startdate = DateUtils.addMonth(startdate, -1);
            enddate = DateUtils.getLastDateOfMonth(startdate);
        }
        return ImmutablePair.of((Object)startdate, (Object)enddate);
    }

    static {
        filterTable.add("tdm_finance_hblrbfilter");
        filterTable.add("tdm_finance_hbzcfzbfilter");
        filterTable.add("tdm_finance_lrbfilter");
        filterTable.add("tdm_finance_syzqybdfilter");
        filterTable.add("tdm_finance_xjllbfilter");
        filterTable.add("tdm_finance_zcfzbfilter");
    }
}

