/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.tcvvt.common.util.datasource.TcvvtAccountDataGatherEngine;
import kd.taxc.tcvvt.common.util.engine.EngineModel;
import kd.taxc.tcvvt.common.util.engine.EngineTask;
import kd.taxc.tcvvt.common.util.threadpools.ThreadPoolsService;

public class TcvvtEngineUtils {
    private static final List<EngineTask<EngineModel, List<DynamicObject>>> ENGINE_TASK_LIST = new ArrayList<EngineTask<EngineModel, List<DynamicObject>>>();

    public static List<DynamicObject> execute(RequestContext context, List<EngineModel> engineModels) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(ENGINE_TASK_LIST.size());
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        for (EngineModel engineModel : engineModels) {
            for (EngineTask<EngineModel, List<DynamicObject>> engineTask : ENGINE_TASK_LIST) {
                engineTask.setCtx(context);
                engineTask.setEngineModel(engineModel);
                futures.add(ThreadPoolsService.getInstance().submitFutrue(engineTask));
            }
            for (Future future : futures) {
                List result = (List)future.get(60L, TimeUnit.SECONDS);
                dynamicObjects.addAll(result);
            }
            futures.clear();
        }
        return dynamicObjects;
    }

    public static List<DynamicObject> execute(List<EngineModel> engineModels) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(ENGINE_TASK_LIST.size());
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        for (EngineModel engineModel : engineModels) {
            for (EngineTask<EngineModel, List<DynamicObject>> engineTask : ENGINE_TASK_LIST) {
                engineTask.setEngineModel(engineModel);
                futures.add(ThreadPoolsService.getInstance().submitFutrue(engineTask));
            }
            for (Future future : futures) {
                List result = (List)future.get(60L, TimeUnit.SECONDS);
                dynamicObjects.addAll(result);
            }
            futures.clear();
        }
        return dynamicObjects;
    }

    static {
        ENGINE_TASK_LIST.add(new TcvvtAccountDataGatherEngine());
    }
}

