/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.common.util.table;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.EmptyCheckUtils;
import kd.taxc.tcvvt.common.util.StringUtil;

public class YbnsrService {
    private static Log logger = LogFactory.getLog(YbnsrService.class);
    public static final String TCVAT_NSRXX = "tcvat_nsrxx";
    public static final String SPLITSTRING = "#";
    public static final String EWBLXH = "ewblxh";
    public static final String SBBID = "sbbid";
    private static final String ORGID = "org";
    private static final String STATUS = "declarestatus";
    private static final String PAY_STATUS = "paystatus";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String SBRQ = "sbrq";
    private static final String NSRTYPE = "type";
    private static final String TAXLIMIT = "taxlimit";
    private static final String TEMPLATE_ID = "templateid";
    private static final String ID = "id";
    public static final String GROUP_REGISTER_TABLE = "tcvvt_clique_mcinfo";
    public static final String GROUP_REGISTER_ORIGINAL_TABLE = "tcvvt_roll_list";
    private static final String[] declareFileList = new String[]{"id"};
    private static final String[] fields = new String[]{"id", "number", "contactinformation", "maincompany", "taxorg.taxpayer as taxpayer", "taxorg.unifiedsocialcode as unifiedsocialcode", "registertype.name", "registeredcapital", "registertime", "codeandname.name", "legalpeople", "registeraddress", "actualaddress", "accountingstandards", "orgid", "registeraddrdetail", "actualaddrdetail", "entryentity.bankname", "entryentity.bankacct,taxoffice"};

    public static DynamicObject queryYbnsr(String orgid, String type, String startData, String endData, Map<String, Object> extendParams) {
        return YbnsrService.queryYbnsr(orgid, type, startData, endData, 0, extendParams);
    }

    public static DynamicObjectCollection queryDateRangeSbbId(String orgid, String type, String taxLimit, Date startData, Date endData) {
        QFilter orgidFilter = new QFilter(ORGID, "=", (Object)Long.valueOf(orgid));
        if (StringUtil.isNotBlank((CharSequence)type)) {
            orgidFilter.and(new QFilter(NSRTYPE, "=", (Object)type));
        }
        QFilter limitFilter = new QFilter(TAXLIMIT, "=", (Object)taxLimit);
        QFilter startDataFilter = new QFilter(SKSSQQ, ">=", (Object)startData);
        QFilter endDataFilter = new QFilter(SKSSQZ, "<=", (Object)endData);
        DynamicObjectCollection temp = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)"declarestatus,org,id", (QFilter[])new QFilter[]{orgidFilter, limitFilter, startDataFilter, endDataFilter});
        return temp;
    }

    private static DynamicObject getDynamicObjectByFilters(Map<String, Object> extendParams, List<QFilter> qFilters) {
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                Object value = entry.getValue();
                if (entry.getKey().equals("groupid")) {
                    value = Long.parseLong(value.toString());
                }
                QFilter extendFilter = new QFilter(entry.getKey(), "=", value);
                qFilters.add(extendFilter);
            }
        }
        QFilter[] qFilterArr = new QFilter[qFilters.size()];
        String allFieldString = MetadataUtil.getAllFieldToQuery((String)TCVAT_NSRXX);
        DynamicObjectCollection temp = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)allFieldString, (QFilter[])qFilters.toArray(qFilterArr));
        if (null != temp && temp.size() > 0) {
            return (DynamicObject)temp.get(0);
        }
        return null;
    }

    public static DynamicObject queryYbnsr(String orgid, String stype, String startData, String endData, int month, Map<String, Object> extendParams) {
        List<QFilter> qFilters = YbnsrService.getQFilters(orgid, stype, startData, endData, month, false, extendParams);
        return YbnsrService.getDynamicObjectByFilters(extendParams, qFilters);
    }

    public static List<QFilter> getQFilters(String orgid, String stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!YbnsrService.checkGroupSubmmitted(stype, extendParams)) {
            qFilters.add(new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)));
        }
        qFilters.add(new QFilter(NSRTYPE, "=", (Object)stype));
        if (dateRange) {
            qFilters.add(new QFilter(SKSSQQ, ">=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startData), month)));
        } else {
            qFilters.add(new QFilter(SKSSQQ, "=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startData), month)));
        }
        qFilters.add(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endData), month))));
        qFilters.add(new QFilter(TAXLIMIT, "=", (Object)DateUtils.getTaxLimit(DateUtils.stringToDate(startData), DateUtils.stringToDate(endData))));
        return qFilters;
    }

    public static DynamicObjectCollection queryYbnsr(String orgid, List<String> stype, String startData, String endData, Map<String, Object> extendParams) {
        List<QFilter> qFilters = YbnsrService.getQFilters(orgid, stype, startData, endData, 0, false, extendParams);
        String allFieldString = MetadataUtil.getAllFieldToQuery((String)TCVAT_NSRXX);
        QFilter[] qFilterArr = new QFilter[qFilters.size()];
        return QueryServiceHelper.query((String)TCVAT_NSRXX, (String)allFieldString, (QFilter[])qFilters.toArray(qFilterArr));
    }

    public static List<QFilter> getQFilters(String orgid, List<String> stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)));
        qFilters.add(new QFilter(NSRTYPE, "in", stype));
        if (dateRange) {
            qFilters.add(new QFilter(SKSSQQ, ">=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startData), month)));
        } else {
            qFilters.add(new QFilter(SKSSQQ, "=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startData), month)));
        }
        qFilters.add(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endData), month))));
        qFilters.add(new QFilter(TAXLIMIT, "=", (Object)DateUtils.getTaxLimit(DateUtils.stringToDate(startData), DateUtils.stringToDate(endData))));
        return qFilters;
    }

    public static boolean checkGroupSubmmitted(String type, Map<String, Object> extendParams) {
        return StringUtils.equals((CharSequence)"qhjtbs", (CharSequence)type) && EmptyCheckUtils.isNotEmpty(extendParams) && StringUtils.isNotBlank((Object)extendParams.get("groupid"));
    }
}

