/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.accessconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvvt.business.finance.TcvvtAccessconfigBusinessImpl;
import kd.taxc.tcvvt.common.util.OrgUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AccessconfigList
extends AbstractListPlugin {
    private static final String ACCOUNTSTANDARD = "accountstandard.projectname";
    private static final String ACCOUNTSTANDARD_ID = "accountstandard.id";
    private static final String REPORTTYPE = "reporttype.name";
    private static final String BASTAX_TAXORG = "bastax_taxorg";

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        List list = ((FilterColumnSetFilterEvent)args).getCommonFilterValue(ACCOUNTSTANDARD);
        this.getPageCache().put("accountstandardJson", null == list ? "" : SerializationUtils.toJsonString((Object)list));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String openType = (String)this.getView().getFormShowParameter().getCustomParam("openType");
        if (ObjectUtils.isEmpty((Object)openType) || !"openbyf7".equalsIgnoreCase(openType)) {
            FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
            List commonFilterColumns = contInitEvent.getCommonFilterColumns();
            String selectValue = this.getPageCache().get("accountstandardJson");
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(4);
            if (StringUtil.isNotBlank((CharSequence)selectValue)) {
                List list = (List)SerializationUtils.fromJsonString((String)selectValue, List.class);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_reporttype", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("entryentity.sykjzzhzd", "=", (Object)Long.valueOf((String)list.get(0)))});
                for (DynamicObject object : collection) {
                    ComboItem item = new ComboItem();
                    item.setValue(object.getString("id"));
                    item.setCaption(new LocaleString(object.getString("name")));
                    combos.add(item);
                }
            }
            for (FilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (StringUtil.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)ACCOUNTSTANDARD)) {
                    filterColumn.setDefaultValue("1072508277482326016");
                    continue;
                }
                if (!StringUtil.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)REPORTTYPE)) continue;
                CommonFilterColumn filter = (CommonFilterColumn)filterColumn;
                filter.setDefaultValue("1277583623859502080");
                if (ObjectUtils.isEmpty(combos)) continue;
                filter.setComboItems(combos);
            }
        }
    }

    private String getDefaultOrg(IFormView view) {
        String defaultOrg = "";
        DynamicObjectCollection col = this.eligibleOrg();
        if (null != col) {
            long orgId = RequestContext.get().getOrgId();
            boolean useDefault = false;
            for (DynamicObject obj : col) {
                if (obj.getLong("id") != orgId) continue;
                defaultOrg = String.valueOf(orgId);
                useDefault = true;
                break;
            }
            if (!useDefault && col.size() > 0) {
                defaultOrg = ((DynamicObject)col.get(0)).getString("id");
            }
        }
        return defaultOrg;
    }

    protected List<ComboItem> getComboItems() {
        ArrayList<Map<String, String>> orgItems = new ArrayList<Map<String, String>>();
        DynamicObjectCollection col = this.eligibleOrg();
        if (null != col) {
            col.stream().forEach(v -> {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", v.getString("id"));
                item.put("number", v.getString("number"));
                item.put("name", v.getString("name"));
                item.put("parentid", v.getString("parentid"));
                item.put("status", v.getString("status"));
                item.put("longnumber", v.getString("longnumber"));
                orgItems.add(item);
            });
        }
        return OrgUtils.getComboItems(orgItems);
    }

    protected DynamicObjectCollection eligibleOrg() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        if (null == col || col.isEmpty()) {
            return null;
        }
        List<Long> orgList = col.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        List<Long> finalOrgList = orgList = AccessconfigList.mergeTaxOrgIds(orgList, "3");
        col.removeIf(o -> !finalOrgList.contains(o.getLong("id")));
        return col;
    }

    public static List<Long> mergeTaxOrgIds(List<Long> idList, String status) {
        QFilter orgFilter = new QFilter("org.id", "in", idList);
        QFilter nsQFilter = new QFilter("istaxpayer", "!=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"id,org.id as orgid", (QFilter[])new QFilter[]{orgFilter, nsQFilter});
        List disabledOrgList = collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        List<Long> mergeOrgIds = idList.stream().filter(v -> !disabledOrgList.contains(v)).collect(Collectors.toList());
        return mergeOrgIds;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String newtype = this.getPageCache().get("newtype");
        String oid = null;
        if (newtype != null) {
            if (newtype.equalsIgnoreCase("tblshare") || newtype.equalsIgnoreCase("tblpriuse")) {
                this.getPageCache().put(newtype, "1");
                List orgid = this.getControlFilters().getFilter("org.id");
                List ids = orgid.stream().filter(o -> !StringUtil.isEmpty((CharSequence)String.valueOf(o))).map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
                DynamicObject[] legalOrgs = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)"id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)"1").and("status", "=", (Object)"1").and("id", "in", ids)});
                oid = legalOrgs.length > 0 ? legalOrgs[0].getString("id") : null;
            } else if (newtype.equalsIgnoreCase("tblcopy")) {
                oid = this.getPageCache().get("tblcopy");
            }
            if (oid != null) {
                DynamicObject[] load = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)"id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)"1").and("status", "=", (Object)"1").and("id", "=", (Object)Long.valueOf(oid))});
                if (load == null || load.length == 0) {
                    oid = null;
                    e.getParameter().setCustomParam("setnull", (Object)true);
                } else {
                    HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_accessconfig", "47156aff000000ac", RequestContext.get().getCurrUserId());
                    if (!allPermOrgsByUserId.hasAllOrgPerm() && !allPermOrgsByUserId.getHasPermOrgs().contains(load[0].getLong("id"))) {
                        oid = null;
                        e.getParameter().setCustomParam("setnull", (Object)true);
                    }
                }
            }
            e.getParameter().setCustomParam("orgid", (Object)oid);
            this.getPageCache().put("newtype", null);
        }
        if (newtype != null) {
            if (newtype.equalsIgnoreCase("tblshare")) {
                e.getParameter().getCustomParams().put("ruletype", "public");
            } else if (newtype.equalsIgnoreCase("tblcopy")) {
                this.setRuleType(e);
            }
        } else {
            this.setRuleType(e);
        }
    }

    private void setRuleType(BeforeShowBillFormEvent e) {
        Object[] selectRowsDetails = this.getSelectRowsDetail();
        if (!ObjectUtils.isEmpty((Object[])selectRowsDetails)) {
            Long focusRowPkId = (Long)this.getFocusRowPkId();
            for (Object selectRowsDetail : selectRowsDetails) {
                if (selectRowsDetail.getLong("id") != focusRowPkId.longValue()) continue;
                String ruletype = selectRowsDetail.getString("ruletype");
                e.getParameter().getCustomParams().put("ruletype", ruletype);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"tblshare") || StringUtil.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"tblpriuse") || StringUtil.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"tblcopy")) {
            this.getPageCache().put("newtype", itemKey);
            if (StringUtil.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"tblcopy") && this.getSelectRowsDetail() != null && this.getSelectRowsDetail().length == 1) {
                this.getPageCache().put("tblcopy", String.valueOf(this.getSelectRowsDetail()[0].get("org.id")));
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"specifiedsharing")) {
            if (this.getSelectedRows().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AccessconfigList_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject[] dynamicObjects = this.getSelectRowsDetail();
            Arrays.stream(dynamicObjects).forEach(row -> {
                if (!StringUtil.equalsIgnoreCase((CharSequence)row.getString("enable"), (CharSequence)"1")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u7528\u7684\u6570\u636e\u624d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AccessconfigList_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (!StringUtil.equalsIgnoreCase((CharSequence)row.getString("ruletype"), (CharSequence)"public")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u5206\u914d\u89c4\u5219\u624d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AccessconfigList_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            });
        } else if (StringUtil.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"tblenable")) {
            DynamicObject[] selectedRows = this.getSelectRowsDetail();
            HashSet<Long> privateSet = new HashSet<Long>();
            HashSet<Long> orgSet = new HashSet<Long>();
            HashSet<Long> accessprojectSet = new HashSet<Long>();
            HashMap<String, Map<String, Integer>> accessconfigMap = new HashMap<String, Map<String, Integer>>();
            for (DynamicObject o2 : selectedRows) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)o2.getString("ruletype"), (CharSequence)"private") || !StringUtil.equalsIgnoreCase((CharSequence)o2.getString("enable"), (CharSequence)"0")) continue;
                privateSet.add(o2.getLong("id"));
                orgSet.add(o2.getLong("org.id"));
                accessprojectSet.add(o2.getLong("accessproject.id"));
                this.dealAccessconfigMap(o2, accessconfigMap);
            }
            this.determineAccessconfigUniqueness(evt, accessconfigMap);
            if (!privateSet.isEmpty()) {
                Arrays.stream(selectedRows).forEach(o -> {
                    privateSet.add(o.getLong("id"));
                    orgSet.add(o.getLong("org.id"));
                    accessprojectSet.add(o.getLong("accessproject.id"));
                });
                QFilter status = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter ruletype = new QFilter("ruletype", "=", (Object)"private");
                QFilter noInid = new QFilter("id", "not in", (Object)privateSet.toArray());
                QFilter org = new QFilter("org", "in", (Object)orgSet.toArray());
                QFilter accessproject = new QFilter("accessproject", "in", (Object)accessprojectSet.toArray());
                DynamicObjectCollection collection = TcvvtAccessconfigBusinessImpl.queryAccessConfigByOrgAndProject(new QFilter[]{status, ruletype, noInid, org, accessproject});
                for (DynamicObject o3 : collection) {
                    this.dealAccessconfigMap(o3, accessconfigMap);
                }
                this.determineAccessconfigUniqueness(evt, accessconfigMap);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if ("specified_sharing".equalsIgnoreCase(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tcvvt_sharingplan", (boolean)true);
            ListSelectedRowCollection accessConfigRows = this.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ListSelectedRow accessConfigRow : accessConfigRows) {
                Long primaryKeyValue = (Long)accessConfigRow.getPrimaryKeyValue();
                ids.add(primaryKeyValue);
            }
            DynamicObjectCollection accessConfigList = QueryServiceHelper.query((String)"tcvvt_accessconfig", (String)"id,accountstandard.id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            Set collect = accessConfigList.stream().map(m -> m.getLong(ACCOUNTSTANDARD_ID)).collect(Collectors.toSet());
            if (collect.size() != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4f1a\u8ba1\u5236\u5ea6\u3002", (String)"AccessconfigList_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("accountstandard", "=", (Object)((DynamicObject)accessConfigList.get(0)).getLong(ACCOUNTSTANDARD_ID));
            listShowParameter.getListFilterParameter().setFilter(filter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "specifiedsharing"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtil.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"specifiedsharing") && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            StringBuilder message = new StringBuilder();
            ListSelectedRowCollection returnDataRows = (ListSelectedRowCollection)returnData;
            List list = returnDataRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toList());
            ListSelectedRowCollection accessConfigRows = this.getSelectedRows();
            List seletRules = accessConfigRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvvt_sharingplan"));
            DynamicObject[] selRules = BusinessDataServiceHelper.load((Object[])seletRules.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvvt_accessconfig"));
            HashMap map = new HashMap();
            HashMap accessProjectmap = new HashMap();
            HashMap numberMap = new HashMap();
            Arrays.stream(selRules).forEach(o -> {
                map.put(o.getLong("id"), o.getString("accessproject.name"));
                numberMap.put(o.getLong("id"), o.getString("number"));
            });
            for (DynamicObject selRule : selRules) {
                List<Long> accessconfigIdList;
                long accessprojectId = selRule.getLong("accessproject.id");
                long accessconfigId = selRule.getLong("id");
                boolean b = accessProjectmap.containsKey(accessprojectId);
                if (b) {
                    accessconfigIdList = (List)accessProjectmap.get(accessprojectId);
                    accessconfigIdList.add(accessconfigId);
                    accessProjectmap.put(accessprojectId, accessconfigIdList);
                    continue;
                }
                accessconfigIdList = new ArrayList<Long>();
                accessconfigIdList.add(accessconfigId);
                accessProjectmap.put(accessprojectId, accessconfigIdList);
            }
            for (Map.Entry entry : accessProjectmap.entrySet()) {
                List Ids = (List)entry.getValue();
                if (Ids.size() <= 1) continue;
                StringBuilder numberS = new StringBuilder();
                String accessprojectName = (String)map.get(Ids.get(0));
                for (Long id : Ids) {
                    numberS.append((String)numberMap.get(id));
                    numberS.append("\u3001");
                }
                String format = String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u53d6\u6570\u89c4\u5219\u5b58\u5728\u76f8\u540c\u7684\u53d6\u6570\u9879\u76ee\u201c%1$s\u201d\uff1a%2$s\u3002", (String)"AccessconfigList_8", (String)"taxc-tcvvt", (Object[])new Object[0]), accessprojectName, numberS.deleteCharAt(numberS.lastIndexOf("\u3001")));
                message.append(format);
                message.append("\r\n");
            }
            if (StringUtil.isNotBlank((CharSequence)message)) {
                this.getView().showTipNotification(message.toString());
                return;
            }
            Arrays.stream(objects).forEach(planObject -> {
                DynamicObjectCollection ruleCollection = planObject.getDynamicObjectCollection("ruleentity");
                List rules = ruleCollection.stream().map(o -> o.getLong("rule.id")).collect(Collectors.toList());
                List ruleNames = ruleCollection.stream().map(o -> o.getString("rule.accessproject.name")).collect(Collectors.toList());
                List existsRules = (List)CollectionUtils.intersection(rules, (Iterable)seletRules);
                accessConfigRows.stream().forEach(o -> {
                    Long id = (Long)o.getPrimaryKeyValue();
                    if (!rules.contains(id) && !ruleNames.contains(map.get(id))) {
                        DynamicObject dynamicObject = ruleCollection.addNew();
                        dynamicObject.set("rule", o.getPrimaryKeyValue());
                    }
                    if (!rules.contains(id) && ruleNames.contains(map.get(id))) {
                        String format = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\u201c%1$s\u201d\u5b58\u5728\u76f8\u540c\u7684\u53d6\u6570\u9879\u76ee\u201c%2$s\u201d\u3002", (String)"AccessconfigList_5", (String)"taxc-tcvvt", (Object[])new Object[0]), planObject.getString("name"), map.get(id));
                        message.append(format);
                        message.append("\r\n");
                    }
                });
                if (!existsRules.isEmpty()) {
                    StringBuilder orgMes = new StringBuilder();
                    ruleCollection.stream().forEach(o -> {
                        if (existsRules.contains(o.get("rule.id"))) {
                            orgMes.append(o.getString("rule.number"));
                            orgMes.append(" ");
                        }
                    });
                    String format = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\u201c%1$s\u201d\u5df2\u914d\u7f6e\u89c4\u5219\u201c%2$s\u201d\u3002", (String)"AccessconfigList_6", (String)"taxc-tcvvt", (Object[])new Object[0]), planObject.getString("name"), orgMes);
                    message.append(format);
                    message.append("\r\n");
                }
            });
            SaveServiceHelper.save((DynamicObject[])objects);
            if (StringUtil.isNotBlank((CharSequence)message)) {
                this.getView().showTipNotification(message.toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u6210\u529f\u3002", (String)"AccessconfigList_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List list = e.getQFilters();
        list.stream().forEach(o -> {
            if (StringUtil.equalsIgnoreCase((CharSequence)o.getProperty(), (CharSequence)ACCOUNTSTANDARD_ID)) {
                this.getPageCache().put(ACCOUNTSTANDARD_ID, SerializationUtils.toJsonString((Object)o.getValue()));
            }
        });
    }

    private DynamicObject[] getSelectRowsDetail() {
        List ids = this.getSelectedRows().stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvvt_accessconfig"));
    }

    private void dealAccessconfigMap(DynamicObject o, Map<String, Map<String, Integer>> accessconfigMap) {
        Long orgId = o.getLong("org.id");
        Long accessProjectId = o.getLong("accessproject.id");
        String declareType = o.getString("declaretype");
        String[] split = declareType.split(",");
        String accessconfigMapKey = orgId + "-" + accessProjectId;
        if (!accessconfigMap.containsKey(accessconfigMapKey)) {
            HashMap<String, Integer> delareTypeMap = new HashMap<String, Integer>();
            for (String s : split) {
                if (ObjectUtils.isEmpty((Object)s)) continue;
                delareTypeMap.put(s, 1);
            }
            accessconfigMap.put(accessconfigMapKey, delareTypeMap);
        } else {
            Map<String, Integer> delareTypeMap = accessconfigMap.get(accessconfigMapKey);
            for (String s : split) {
                if (ObjectUtils.isEmpty((Object)s)) continue;
                if (!delareTypeMap.containsKey(s)) {
                    delareTypeMap.put(s, 1);
                    continue;
                }
                int count = delareTypeMap.get(s) + 1;
                delareTypeMap.put(s, count);
            }
            accessconfigMap.put(accessconfigMapKey, delareTypeMap);
        }
    }

    private void determineAccessconfigUniqueness(BeforeItemClickEvent evt, Map<String, Map<String, Integer>> accessconfigMap) {
        for (Map.Entry<String, Map<String, Integer>> accessconfigMapEntry : accessconfigMap.entrySet()) {
            Map<String, Integer> delareTypeMap = accessconfigMapEntry.getValue();
            for (Map.Entry<String, Integer> delareTypeMapEntry : delareTypeMap.entrySet()) {
                Integer value = delareTypeMapEntry.getValue();
                if (value <= 1) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u3001\u53d6\u6570\u9879\u76ee\u548c\u7533\u62a5\u7c7b\u578b\u76f8\u540c\u65f6\uff0c\u81ea\u7528\u89c4\u5219\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AccessconfigList_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }
}

