/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.accessconfig;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvvt.business.taxorg.TcvvtTaxOrgCommonBusiness;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.StringUtil;

public class AccessconfigQhPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String systemType = "taxc-tcvvt";
    private static final String ORG = "org";
    private static final String ACCESSPROJECT = "accessproject";
    private static final String APPLICABLERULES = "applicablerules";
    private static final String SAVECOPYID = "saveCopyId";
    private static final String SAVECOPY = "savecopy";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String TABLE = "table";
    private static final String ENTRY_ENTITY_KEY = "entryentity";
    private static final String SAVECOPYID_RULETYPE = "savecopyid_ruletype";
    private static final String RULE_QHJT = "RULE-QHJT-001";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accessproject = (BasedataEdit)this.getControl(ACCESSPROJECT);
        accessproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl(TABLE);
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5343\u6237\u96c6\u56e2\u53d6\u6570\u914d\u7f6e", (String)"AccessconfigQhPlugin_0", (String)systemType, (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        String id = this.getPageCache().get(SAVECOPYID);
        if (StringUtil.isNotBlank((CharSequence)id)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(id), (DynamicObjectType)this.getModel().getDataEntityType());
            this.getModel().setValue(ORG, dynamicObject.get(ORG));
            this.getModel().setValue(ACCESSPROJECT, dynamicObject.get(ACCESSPROJECT));
            this.getModel().setValue(APPLICABLERULES, dynamicObject.get(APPLICABLERULES));
            this.getModel().setValue("ruletype", dynamicObject.get("ruletype"));
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY_KEY);
            this.getModel().deleteEntryData(ENTRY_ENTITY_KEY);
            collection.stream().forEach(o -> {
                int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY_KEY);
                this.getModel().setValue("bizname", o.get("bizname"), rowIndex);
                this.getModel().setValue(TABLE, o.get(TABLE), rowIndex);
                this.getModel().setValue("amountfield", o.get("amountfield"), rowIndex);
                this.getModel().setValue("absolute", o.get("absolute"), rowIndex);
                this.getModel().setValue("datatype", o.get("datatype"), rowIndex);
                this.getModel().setValue("datadirection", o.get("datadirection"), rowIndex);
                this.getModel().setValue("filtercondition", o.get("filtercondition"), rowIndex);
                this.getModel().setValue("conditionjson", o.get("conditionjson"), rowIndex);
                this.getModel().setValue("advancedconf", o.get("advancedconf"), rowIndex);
                this.getModel().setValue("advancedconfjson", o.get("advancedconfjson"), rowIndex);
                this.getModel().setValue("jsbl", o.get("jsbl"), rowIndex);
                this.getModel().setValue("exratejson", o.get("exratejson"), rowIndex);
            });
            this.getPageCache().put(SAVECOPYID_RULETYPE, dynamicObject.getString("ruletype"));
            this.getPageCache().remove(SAVECOPYID);
        }
    }

    public void beforeBindData(EventObject e) {
        Map customParams;
        Object orgid;
        super.beforeBindData(e);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctb_datasource_peek_rule", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)RULE_QHJT)});
        if (dynamicObject != null) {
            this.getModel().setValue(APPLICABLERULES, (Object)dynamicObject.getLong("id"));
        }
        if ((orgid = (customParams = this.getView().getFormShowParameter().getCustomParams()).get("setnull")) != null && "true".equalsIgnoreCase(orgid.toString())) {
            this.getModel().setValue(ORG, null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String saveCopyIdRuletype = this.getPageCache().get(SAVECOPYID_RULETYPE);
        if (StringUtil.isNotEmpty((CharSequence)saveCopyIdRuletype)) {
            this.getModel().setValue("ruletype", (Object)saveCopyIdRuletype);
            this.getPageCache().remove(SAVECOPYID_RULETYPE);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getView().getParentView().getPageCache().get("tblshare"), (CharSequence)"1")) {
            this.getModel().setValue("ruletype", (Object)"public");
            this.getView().getParentView().getPageCache().remove("tblshare");
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getView().getParentView().getPageCache().get("tblpriuse"), (CharSequence)"1")) {
            this.getModel().setValue("ruletype", (Object)"private");
            this.getView().getParentView().getPageCache().remove("tblpriuse");
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ACCESSPROJECT)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            Date dayFirst = DateUtils.getDayFirst(new Date());
            QFilter startDateQ = new QFilter("validfrom", "<=", (Object)dayFirst);
            QFilter endDateQ = new QFilter("validto", ">=", (Object)dayFirst).or("validto", "=", null);
            formShowParameter.getTreeFilterParameter().getQFilters().add(startDateQ);
            formShowParameter.getTreeFilterParameter().getQFilters().add(endDateQ);
            formShowParameter.getListFilterParameter().getQFilters().add(startDateQ);
            formShowParameter.getListFilterParameter().getQFilters().add(endDateQ);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ORG)) {
            DynamicObjectCollection col = this.eligibleOrg();
            List ids = col.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter idQFilter = new QFilter("id", "in", ids);
            formShowParameter.getTreeFilterParameter().getQFilters().add(idQFilter);
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)TABLE)) {
            Long id = this.getModel().getDataEntity().getLong("applicablerules.id");
            QFilter peekrule = new QFilter("peekrule.fbasedataid", "=", (Object)id);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(peekrule);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (result.isSuccess() && StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get(SAVECOPY), (CharSequence)"1")) {
                List ids = result.getSuccessPkIds();
                this.getPageCache().put(SAVECOPYID, ids.get(0).toString());
                this.getPageCache().put("isSuccess", "1");
            }
            this.getPageCache().remove(SAVECOPY);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)SAVECOPY)) {
            this.getPageCache().put(SAVECOPY, "1");
            this.checkFailedTip(evt);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"bar_save")) {
            this.checkFailedTip(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue(TABLE, focusRow);
            if (tabletype == null) {
                args.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().startsWith("setadvancedconf")) {
            String key = evt.getActionId();
            String entitySuffix = key.replace("setadvancedconf", "");
            Map filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + entitySuffix);
                this.getModel().setValue("advancedconf" + entitySuffix, filterData.get("advancedconf"), currentRowIndex);
                this.getModel().setValue("advancedconfjson" + entitySuffix, filterData.get("advancedconfjson"), currentRowIndex);
            }
        }
    }

    private void checkFailedTip(BeforeItemClickEvent evt) {
        QFilter idQ;
        QFilter ruletypeQ;
        Object accessprojectId;
        QFilter accessprojectQ;
        Object orgId;
        QFilter orgQ;
        QFilter statusQ;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null != org && !TcvvtTaxOrgCommonBusiness.isTaxcOrgExistByOrgId(org.getLong("id"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u7981\u7528\uff0c\u8bf7\u542f\u7528\u518d\u4fdd\u5b58\u3002", (String)"AccessconfigQhPlugin_1", (String)systemType, (Object[])new Object[0]), org.getString("name")));
            evt.setCancel(true);
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().getString("ruletype"), (CharSequence)"private") && QueryServiceHelper.exists((String)"tcvvt_qh_accessconfig", (QFilter[])new QFilter[]{statusQ = new QFilter("enable", "=", (Object)Boolean.TRUE), orgQ = new QFilter(ORG, "=", orgId = this.getModel().getDataEntity().get("org.id")), accessprojectQ = new QFilter(ACCESSPROJECT, "=", accessprojectId = this.getModel().getDataEntity().get("accessproject.id")), ruletypeQ = new QFilter("ruletype", "=", (Object)"private"), idQ = new QFilter("id", "!=", this.getModel().getDataEntity().get("id"))})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u548c\u53d6\u6570\u9879\u76ee\u76f8\u540c\u65f6\uff0c\u81ea\u7528\u89c4\u5219\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u6761\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AccessconfigQhPlugin_2", (String)systemType, (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    protected DynamicObjectCollection eligibleOrg() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        if (null == col || col.isEmpty()) {
            return null;
        }
        List<Long> orgList = col.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        List<Long> finalOrgList = orgList = AccessconfigQhPlugin.mergeTaxOrgIds(orgList, "3");
        col.removeIf(o -> !finalOrgList.contains(o.getLong("id")));
        return col;
    }

    public static List<Long> mergeTaxOrgIds(List<Long> idList, String status) {
        if (StringUtils.equals((CharSequence)status, (CharSequence)"2")) {
            status = "1";
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)"3")) {
            status = "0";
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        QFilter orgFilter = new QFilter("org.id", "in", idList);
        QFilter nsQFilter = new QFilter("istaxpayer", "!=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"id,org.id as orgid", (QFilter[])new QFilter[]{orgFilter, statusFilter.or(nsQFilter)});
        List disabledOrgList = collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        List<Long> mergeOrgIds = idList.stream().filter(v -> !disabledOrgList.contains(v)).collect(Collectors.toList());
        return mergeOrgIds;
    }
}

