/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.accessconfig;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvvt.business.taxorg.TcvvtTaxOrgCommonBusiness;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.StringUtil;

public class AccessconfigTaxPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String systemType = "taxc-tcvvt";
    private static final String ORG = "org";
    private static final String ACCESSPROJECT = "accessproject";
    private static final String APPLICABLERULES = "applicablerules";
    private static final String SAVECOPYID = "saveCopyId";
    private static final String SAVECOPY = "savecopy";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String TABLE = "table";
    private static final String PROJECTCALIBER = "projectcaliber";
    private static final String ENTYR_ENTITY = "entryentity";
    private static final String ENTRY_ENTITY_KEY = "entryentity";
    private static final String ENTRY_ENTITY_KEY_1 = "entryentity1";
    private static final String SAVECOPYID_RULETYPE = "savecopyid_ruletype";
    private static final String KEY_CONDITIONJSON = "conditionjson1";
    private static final String KEY_FILTERCONDITION = "filtercondition1";
    private static final String RULE_QHJT = "RULE-QHJT-001";
    private static final String TAX = "tax";
    private static final String FINANCE = "finance";
    private static final String PRODUCT = "product";
    private static final String QYJQDCB = "qyjqdcb";
    private static final String RULE_ZDSYBS_X01 = "RULE-ZDSYBS-X01";
    private static final String RULE_ZDSYBS_X02 = "RULE-ZDSYBS-X02";
    private static final String RULE_ZDSYBS_X03 = "RULE-ZDSYBS-X03";
    private static final String RULE_ZDSYBS_X04 = "RULE-ZDSYBS-X04";
    private static final String REPORT_TYPE = "reporttype";
    public static Map<String, String> relateMap = new HashMap<String, String>(4);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accessproject = (BasedataEdit)this.getControl(ACCESSPROJECT);
        accessproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl(TABLE);
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table1 = (BasedataEdit)this.getControl("table1");
        table1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield1");
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u91cd\u70b9\u7a0e\u6e90\u53d6\u6570\u914d\u7f6e", (String)"AccessconfigTaxPlugin_0", (String)systemType, (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        ListView listView = (ListView)this.getView().getParentView();
        if (!ObjectUtils.isEmpty((Object)listView)) {
            Map filterMap = listView.getControlFilters().getFilters();
            for (Map.Entry entry : filterMap.entrySet()) {
                Object value;
                ControlFilter filter = (ControlFilter)entry.getValue();
                Object v0 = value = ObjectUtils.isEmpty((Object)filter.getValue()) ? null : filter.getValue().get(0);
                if (!StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"org.id")) continue;
                this.getModel().setValue(ORG, value);
            }
            this.getModel().setValue("isupgrade", (Object)"1");
        }
        AccessconfigTaxPlugin.setProjectcaliber(this.getView());
        String id = this.getPageCache().get(SAVECOPYID);
        if (StringUtil.isNotBlank((CharSequence)id)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(id), (DynamicObjectType)this.getModel().getDataEntityType());
            this.getModel().setValue(ORG, dynamicObject.get(ORG));
            this.getModel().setValue(ACCESSPROJECT, dynamicObject.get(ACCESSPROJECT));
            this.getModel().setValue(PROJECTCALIBER, dynamicObject.get(PROJECTCALIBER));
            this.getModel().setValue(APPLICABLERULES, dynamicObject.get(APPLICABLERULES));
            this.getModel().setValue("ruletype", dynamicObject.get("ruletype"));
            this.getModel().setValue("isupgrade", dynamicObject.get("isupgrade"));
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection collection1 = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY_KEY_1);
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData(ENTRY_ENTITY_KEY_1);
            collection.stream().forEach(o -> {
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("bizname", o.get("bizname"), rowIndex);
                this.getModel().setValue(TABLE, o.get(TABLE), rowIndex);
                this.getModel().setValue("amountfield", o.get("amountfield"), rowIndex);
                this.getModel().setValue("absolute", o.get("absolute"), rowIndex);
                this.getModel().setValue("datatype", o.get("datatype"), rowIndex);
                this.getModel().setValue("datadirection", o.get("datadirection"), rowIndex);
                this.getModel().setValue("filtercondition", o.get("filtercondition"), rowIndex);
                this.getModel().setValue("conditionjson", o.get("conditionjson"), rowIndex);
                this.getModel().setValue("advancedconf", o.get("advancedconf"), rowIndex);
                this.getModel().setValue("advancedconfjson", o.get("advancedconfjson"), rowIndex);
                this.getModel().setValue("vatrate", o.get("vatrate"), rowIndex);
                this.getModel().setValue("jsbl", o.get("jsbl"), rowIndex);
                this.getModel().setValue("exratejson", o.get("exratejson"), rowIndex);
            });
            collection1.stream().forEach(o -> {
                int rowIndex1 = this.getModel().createNewEntryRow(ENTRY_ENTITY_KEY_1);
                this.getModel().setValue("bizname1", o.get("bizname1"), rowIndex1);
                this.getModel().setValue("table1", o.get("table1"), rowIndex1);
                this.getModel().setValue("amountfield1", o.get("amountfield1"), rowIndex1);
                this.getModel().setValue("absolute1", o.get("absolute1"), rowIndex1);
                this.getModel().setValue("datatype1", o.get("datatype1"), rowIndex1);
                this.getModel().setValue("datadirection1", o.get("datadirection1"), rowIndex1);
                this.getModel().setValue(KEY_FILTERCONDITION, o.get(KEY_FILTERCONDITION), rowIndex1);
                this.getModel().setValue(KEY_CONDITIONJSON, o.get(KEY_CONDITIONJSON), rowIndex1);
                this.getModel().setValue("advancedconf1", o.get("advancedconf1"), rowIndex1);
                this.getModel().setValue("advancedconfjson1", o.get("advancedconfjson1"), rowIndex1);
                this.getModel().setValue("vatrate1", o.get("vatrate1"), rowIndex1);
                this.getModel().setValue("jsbl1", o.get("jsbl1"), rowIndex1);
                this.getModel().setValue("exratejson1", o.get("exratejson1"), rowIndex1);
            });
            this.getPageCache().put(SAVECOPYID_RULETYPE, dynamicObject.getString("ruletype"));
            this.getPageCache().remove(SAVECOPYID);
            AccessconfigTaxPlugin.accessentry1(this.getView());
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("setnull");
        if (orgid != null && "true".equalsIgnoreCase(orgid.toString())) {
            this.getModel().setValue(ORG, null);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String saveCopyIdRuletype = this.getPageCache().get(SAVECOPYID_RULETYPE);
        if (StringUtil.isNotEmpty((CharSequence)saveCopyIdRuletype)) {
            this.getModel().setValue("ruletype", (Object)saveCopyIdRuletype);
            this.getPageCache().remove(SAVECOPYID_RULETYPE);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getView().getParentView().getPageCache().get("tblshare"), (CharSequence)"1")) {
            this.getModel().setValue("ruletype", (Object)"public");
            this.getView().getParentView().getPageCache().remove("tblshare");
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getView().getParentView().getPageCache().get("tblpriuse"), (CharSequence)"1")) {
            this.getModel().setValue("ruletype", (Object)"private");
            this.getView().getParentView().getPageCache().remove("tblpriuse");
        }
        AccessconfigTaxPlugin.setProjectcaliber(this.getView());
        AccessconfigTaxPlugin.accessentry1(this.getView());
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (REPORT_TYPE.equalsIgnoreCase(name)) {
            this.getModel().setValue(ACCESSPROJECT, null);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctb_datasource_peek_rule", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)relateMap.get(this.getModel().getValue(REPORT_TYPE)))});
            if (dynamicObject != null) {
                this.getModel().setValue(APPLICABLERULES, (Object)dynamicObject.getLong("id"));
                if (e.getChangeSet()[0].getOldValue() != null) {
                    this.showConfirmTips(e.getChangeSet()[0].getOldValue().toString());
                }
            }
            AccessconfigTaxPlugin.setProjectcaliber(this.getView());
            AccessconfigTaxPlugin.accessentry1(this.getView());
        } else if ("table1".equals(e.getProperty().getName())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY_1);
            this.getModel().setValue("amountfield1", null, rowIndex);
            this.getModel().setValue(KEY_FILTERCONDITION, null, rowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, null, rowIndex);
            this.getModel().setValue("absolute1", (Object)Boolean.FALSE, rowIndex);
        } else if ("amountfield1".equals(name)) {
            String suffix = name.replace("amountfield1", "");
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(suffix + ENTRY_ENTITY_KEY_1);
            if (changeAmount == null) {
                return;
            }
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue(suffix + "table1", rowIndex);
            DynamicObject amountfield = (DynamicObject)this.getModel().getValue(suffix + "amountfield1", rowIndex);
            RuleTemplateService.setAdvanceConfDefaultValue((IDataModel)this.getModel(), (int)rowIndex, (DynamicObject)tabletype, (DynamicObject)amountfield, (String)(suffix + "advancedconf1"), (String)(suffix + "advancedconfjson1"));
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ACCESSPROJECT)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            Date dayFirst = DateUtils.getDayFirst(new Date());
            QFilter startDateQ = new QFilter("validfrom", "<=", (Object)dayFirst);
            QFilter endDateQ = new QFilter("validto", ">=", (Object)dayFirst).or("validto", "=", null);
            QFilter isleafQ = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
            QFilter isfetch = new QFilter("fetch", "=", (Object)Boolean.TRUE);
            formShowParameter.getTreeFilterParameter().getQFilters().add(startDateQ);
            formShowParameter.getTreeFilterParameter().getQFilters().add(endDateQ);
            formShowParameter.getTreeFilterParameter().getQFilters().add(isfetch);
            formShowParameter.getListFilterParameter().getQFilters().add(startDateQ);
            formShowParameter.getListFilterParameter().getQFilters().add(endDateQ);
            formShowParameter.getListFilterParameter().getQFilters().add(isfetch);
            Object reporttype = this.getModel().getValue(REPORT_TYPE);
            if (reporttype != null) {
                QFilter type = new QFilter("type", "=", reporttype);
                formShowParameter.getListFilterParameter().getQFilters().add(type);
                formShowParameter.getTreeFilterParameter().getQFilters().add(type);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ORG)) {
            DynamicObjectCollection col = this.eligibleOrg();
            List ids = col.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter idQFilter = new QFilter("id", "in", ids);
            formShowParameter.getTreeFilterParameter().getQFilters().add(idQFilter);
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)TABLE) || "table1".equalsIgnoreCase(name)) {
            Object reporttype = this.getModel().getValue(REPORT_TYPE);
            if (ObjectUtils.isEmpty((Object)reporttype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u62a5\u8868\u7c7b\u578b\u201d\u3002", (String)"AccessconfigTaxPlugin_1", (String)systemType, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long id = this.getModel().getDataEntity().getLong("applicablerules.id");
            QFilter peekrule = new QFilter("peekrule.fbasedataid", "=", (Object)id);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(peekrule);
        } else if (name.equals("amountfield1")) {
            DynamicObject taxation;
            IDataModel dataModel = this.getModel();
            IFormView formView = this.getView();
            int rowIndex = dataModel.getEntryCurrentRowIndex(ENTRY_ENTITY_KEY_1);
            DynamicObject tabletype = (DynamicObject)dataModel.getValue("table1", rowIndex);
            if (tabletype == null) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"AccessconfigTaxPlugin_8", (String)systemType, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
            String entityName = ((BasedataEdit)evt.getSource()).getView().getFormShowParameter().getFormId();
            if (RuleTypeEnum.REDUCE.getEntry().equals(entityName) && "tdm_balance_new".equals(tabletype.get("name"))) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
            if (RuleTypeEnum.INCOME.getEntry().equals(entityName) && null != (taxation = (DynamicObject)dataModel.getValue("taxation")) && taxation.getString("number").equals("MS") && "tdm_balance_new".equals(tabletype.get("name"))) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (result.isSuccess() && StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get(SAVECOPY), (CharSequence)"1")) {
                List ids = result.getSuccessPkIds();
                this.getPageCache().put(SAVECOPYID, ids.get(0).toString());
                this.getPageCache().put("isSuccess", "1");
            }
            this.getPageCache().remove(SAVECOPY);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)SAVECOPY)) {
            this.getPageCache().put(SAVECOPY, "1");
            this.checkFailedTip(evt);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"bar_save")) {
            this.checkFailedTip(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            Object[] dataEntitys = entryentity.getEntryData().getDataEntitys();
            EntryGrid entryentity1 = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY_1);
            Object[] dataEntitys1 = entryentity1.getEntryData().getDataEntitys();
            String report = (String)this.getModel().getValue(REPORT_TYPE);
            if (ObjectUtils.isEmpty((Object[])dataEntitys) && ObjectUtils.isEmpty((Object[])dataEntitys1)) {
                if (report.equalsIgnoreCase(PRODUCT) || report.equalsIgnoreCase(TAX)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u672c\u5e74\u9879\u76ee\u53d6\u6570\u660e\u7ec6\u201d\u6216\u201c\u4e0a\u5e74\u9879\u76ee\u53d6\u6570\u660e\u7ec6\u201d\u3002", (String)"AccessconfigTaxPlugin_7", (String)systemType, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u6570\u660e\u7ec6\u201d\u3002", (String)"AccessconfigTaxPlugin_9", (String)systemType, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        String entitySuffix;
        String key;
        super.closedCallBack(evt);
        if (evt.getActionId().equalsIgnoreCase("setadvancedconf")) {
            key = evt.getActionId();
            entitySuffix = key.replace("setadvancedconf", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity" + entitySuffix);
                this.getModel().setValue("advancedconf" + entitySuffix, filterData.get("advancedconf"), currentRowIndex);
                this.getModel().setValue("advancedconfjson" + entitySuffix, filterData.get("advancedconfjson"), currentRowIndex);
            }
        }
        if (evt.getActionId().equalsIgnoreCase("setting")) {
            key = evt.getActionId();
            entitySuffix = key.replace("setting", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY_1 + entitySuffix);
                this.getModel().setValue(KEY_FILTERCONDITION + entitySuffix, filterData.get("filterdescription"), currentRowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + entitySuffix, filterData.get("filtervalue"), currentRowIndex);
            }
        }
    }

    private void checkFailedTip(BeforeItemClickEvent evt) {
        Object value;
        String product;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null != org && !TcvvtTaxOrgCommonBusiness.isTaxcOrgExistByOrgId(org.getLong("id"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u7981\u7528\uff0c\u8bf7\u542f\u7528\u518d\u4fdd\u5b58\u3002", (String)"AccessconfigTaxPlugin_2", (String)systemType, (Object[])new Object[0]), org.getString(systemType)));
            evt.setCancel(true);
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().getString("ruletype"), (CharSequence)"private")) {
            Object orgId = this.getModel().getDataEntity().get("org.id");
            Object accessprojectId = this.getModel().getDataEntity().get("accessproject.id");
            Long projectcaliberId = !ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get("projectcaliber.id")) ? this.getModel().getDataEntity().get("projectcaliber.id") : Long.valueOf(0L);
            QFilter orgQ = new QFilter(ORG, "=", orgId);
            QFilter accessprojectQ = new QFilter(ACCESSPROJECT, "=", accessprojectId);
            QFilter projectcaliberIdQ = new QFilter(PROJECTCALIBER, "=", (Object)projectcaliberId);
            QFilter statusQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter ruletypeQ = new QFilter("ruletype", "=", (Object)"private");
            QFilter idQ = new QFilter("id", "!=", this.getModel().getDataEntity().get("id"));
            if (QueryServiceHelper.exists((String)"tcvvt_tax_accessconfig", (QFilter[])new QFilter[]{statusQ, orgQ, accessprojectQ, ruletypeQ, idQ, projectcaliberIdQ})) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u3001\u53d6\u6570\u9879\u76ee\u548c\u9879\u76ee\u53e3\u5f84\u76f8\u540c\u65f6\uff0c\u81ea\u7528\u89c4\u5219\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u6761\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AccessconfigTaxPlugin_3", (String)systemType, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(product = (String)this.getModel().getValue(REPORT_TYPE))) && (product.equalsIgnoreCase(PRODUCT) || product.equalsIgnoreCase(TAX)) && ObjectUtils.isEmpty((Object)(value = this.getModel().getValue(PROJECTCALIBER))) && product.equalsIgnoreCase(PRODUCT)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u53e3\u5f84\u201d\u3002", (String)"AccessconfigTaxPlugin_10", (String)systemType, (Object[])new Object[0]));
            evt.setCancel(true);
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection collection1 = this.getModel().getEntryEntity(ENTRY_ENTITY_KEY_1);
        String ruleuse = " ";
        if (product.equalsIgnoreCase(TAX) || product.equalsIgnoreCase(PRODUCT)) {
            if (!ObjectUtils.isEmpty((Object)collection) && ObjectUtils.isEmpty((Object)collection1)) {
                ruleuse = ",bn,";
            }
            if (ObjectUtils.isEmpty((Object)collection) && !ObjectUtils.isEmpty((Object)collection1)) {
                ruleuse = ",sn,";
            }
            if (!ObjectUtils.isEmpty((Object)collection) && !ObjectUtils.isEmpty((Object)collection1)) {
                ruleuse = ",bn,sn,";
            }
        }
        this.getModel().setValue("ruleuse", (Object)ruleuse);
        this.getModel().setDataChanged(false);
    }

    protected DynamicObjectCollection eligibleOrg() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        if (null == col || col.isEmpty()) {
            return null;
        }
        List<Long> orgList = col.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        List<Long> finalOrgList = orgList = AccessconfigTaxPlugin.mergeTaxOrgIds(orgList, "3");
        col.removeIf(o -> !finalOrgList.contains(o.getLong("id")));
        return col;
    }

    public static List<Long> mergeTaxOrgIds(List<Long> idList, String status) {
        if (StringUtils.equals((CharSequence)status, (CharSequence)"2")) {
            status = "1";
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)"3")) {
            status = "0";
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        QFilter orgFilter = new QFilter("org.id", "in", idList);
        QFilter nsQFilter = new QFilter("istaxpayer", "!=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"id,org.id as orgid", (QFilter[])new QFilter[]{orgFilter, statusFilter.or(nsQFilter)});
        List disabledOrgList = collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        List<Long> mergeOrgIds = idList.stream().filter(v -> !disabledOrgList.contains(v)).collect(Collectors.toList());
        return mergeOrgIds;
    }

    private void showConfirmTips(String oldValue) {
        if (this.hasEntryRows() && this.getPageCache().get("oldValue") == null) {
            this.getPageCache().put("oldValue", oldValue);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("change", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AccessconfigTaxPlugin_4", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AccessconfigTaxPlugin_5", (String)systemType, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u4fee\u6539\u62a5\u8868\u7c7b\u578b\uff0c\u5c06\u4f1a\u6e05\u7a7a\u201c\u53d6\u6570\u660e\u7ec6\u201d\uff0c\u786e\u8ba4\u4fee\u6539\u5417?", (String)"AccessconfigTaxPlugin_6", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if ("change".equalsIgnoreCase(fieldKey)) {
            if ("Yes".equalsIgnoreCase(messageBoxClosedEvent.getResult().name())) {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue(ACCESSPROJECT, null);
                this.getPageCache().put("oldValue", null);
                this.getModel().deleteEntryData(ENTRY_ENTITY_KEY_1);
            } else {
                String oldValue = this.getPageCache().get("oldValue");
                this.getModel().setValue(REPORT_TYPE, (Object)oldValue);
                this.getPageCache().put("oldValue", null);
                HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
                props.put("text", new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u9879\u76ee\u53d6\u6570\u660e\u7ec6", (String)"AccessconfigTaxPlugin_12", (String)systemType, (Object[])new Object[0])));
                this.getView().updateControlMetadata("advconap", props);
            }
        }
    }

    private boolean hasEntryRows() {
        int size = this.getModel().getEntryRowCount("entryentity");
        return size == 1 && (this.getModel().getValue("bizname", 0) != null && !"".equalsIgnoreCase(this.getModel().getValue("bizname", 0).toString()) || this.getModel().getValue(TABLE, 0) != null || this.getModel().getValue("amountfield", 0) != null) || size > 1;
    }

    public static void setProjectcaliber(IFormView view) {
        String product = (String)view.getModel().getValue(REPORT_TYPE);
        if (!ObjectUtils.isEmpty((Object)product) && product.equalsIgnoreCase(PRODUCT)) {
            view.setVisible(Boolean.valueOf(true), new String[]{PROJECTCALIBER});
            ((BasedataEdit)view.getControl(PROJECTCALIBER)).setMustInput(true);
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{PROJECTCALIBER});
            view.getModel().setValue(PROJECTCALIBER, null);
            ((BasedataEdit)view.getControl(PROJECTCALIBER)).setMustInput(false);
        }
    }

    public static void accessentry1(IFormView view) {
        String product = (String)view.getModel().getValue(REPORT_TYPE);
        if (!ObjectUtils.isEmpty((Object)product) && (product.equalsIgnoreCase(PRODUCT) || product.equalsIgnoreCase(TAX))) {
            view.setVisible(Boolean.valueOf(true), new String[]{"advconap1"});
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u9879\u76ee\u53d6\u6570\u660e\u7ec6", (String)"AccessconfigTaxPlugin_12", (String)systemType, (Object[])new Object[0])));
            view.updateControlMetadata("advconap", props);
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"advconap1"});
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u53d6\u6570\u660e\u7ec6", (String)"AccessconfigTaxPlugin_11", (String)systemType, (Object[])new Object[0])));
            view.updateControlMetadata("advconap", props);
        }
    }

    public static BiPredicate<String, String> predicate(String table, List<String> columns) {
        return (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
    }

    static {
        relateMap.put(TAX, RULE_ZDSYBS_X01);
        relateMap.put(PRODUCT, RULE_ZDSYBS_X02);
        relateMap.put(FINANCE, RULE_ZDSYBS_X03);
        relateMap.put(QYJQDCB, RULE_ZDSYBS_X04);
    }
}

