/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.accountset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.business.qhjt.QhjtCommonBusiness;
import kd.taxc.tcvvt.common.helper.OrgServiceHelper;
import kd.taxc.tcvvt.common.util.ExportUtil;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.PluginUtil;
import kd.taxc.tcvvt.common.util.StringUtil;

public class AccountSetListPlugin
extends AbstractListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        HasPermOrgResult orgsByUserId = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_accountset", "47150e89000000ac", RequestContext.get().getCurrUserId());
        QFilter filter = null;
        if (orgsByUserId != null && !orgsByUserId.hasAllOrgPerm()) {
            filter = new QFilter("id", "in", (Object)orgsByUserId.getHasPermOrgs());
        }
        args.getQfilters().add(filter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        long orgId = RequestContext.get().getOrgId();
        Map<String, Map<String, String>> allOrgByViewId = OrgServiceHelper.getAllOrgByViewId(10L, null);
        Collection<Map<String, String>> values = allOrgByViewId.values();
        Set<String> oids = allOrgByViewId.keySet();
        ArrayList<Long> ids = new ArrayList<Long>(12);
        for (String id : oids) {
            ids.add(Long.valueOf(id));
        }
        this.getPermOrgResult(ids);
        if (ids != null && ids.size() > 0) {
            long orgid = RequestContext.get().getOrgId();
            if (ids.contains(orgid)) {
                args.getFilterColumn("org.name").setDefaultValue(String.valueOf(orgId));
            } else {
                args.getFilterColumn("org.name").setDefaultValue(((Long)ids.get(0)).toString());
            }
        }
    }

    public void getPermOrgResult(List<Long> ids) {
        List perm = new ArrayList();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            HasPermOrgResult tcvvt = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_accountset", "47150e89000000ac", RequestContext.get().getCurrUserId());
            if (tcvvt != null) {
                perm = tcvvt.getHasPermOrgs();
            }
            ids.retainAll(perm);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "outportcsv".equals(((Donothing)args.getSource()).getOperateKey())) {
            List<Long> orgCount;
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("outportcsv", (IFormPlugin)this);
            QFilter filter = null;
            if (selectedRows != null && selectedRows.size() > 0) {
                List pkIds = Arrays.stream(selectedRows.getPrimaryKeyValues()).distinct().collect(Collectors.toList());
                orgCount = QhjtCommonBusiness.queryOrgCountByAccountSetIds(new QFilter("id", "in", pkIds));
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$s\u4e2a\u6838\u7b97\u7ec4\u7ec7\u5171%2$s\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"AccountSetListPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]), orgCount.size(), selectedRows.size()), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else if (billlist.getCurrentListAllRowCollection().size() == 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa0\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"AccountSetListPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                args.setCancel(true);
            } else {
                if (StringUtil.isEmpty((CharSequence)this.getPageCache().get("filterList"))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa0\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"AccountSetListPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                    return;
                }
                List setFilter = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("filterList"));
                for (QFilter qf : setFilter) {
                    if (filter != null) {
                        filter.and(qf);
                        continue;
                    }
                    filter = qf;
                }
            }
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcvvt_clique_accountset", (String)"count(id) as total", (QFilter[])new QFilter[]{filter});
            orgCount = QhjtCommonBusiness.queryOrgCountByAccountSetIds(filter);
            if (dynamicObject.getLong("total") > 5000000L) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570%s\u6761\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u884c\u6570\u9650\u5236\uff1a5000000\u6761\u6570\u636e\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"AccountSetListPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]), dynamicObject.getLong("total")));
                args.setCancel(true);
                return;
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$s\u4e2a\u6838\u7b97\u7ec4\u7ec7\u5171%2$s\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"AccountSetListPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]), orgCount.size(), dynamicObject.getLong("total")), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    public void setFilter(SetFilterEvent e) {
        this.getPageCache().put("filterList", SerializationUtils.serializeToBase64((Object)e.getMergeQFilters()));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Object o;
        if (this.getControlFilters().getFilters().get("org.id") != null && (o = ((ControlFilter)this.getControlFilters().getFilters().get("org.id")).getValue().get(0)) != null) {
            e.getParameter().getShowParameter().getCustomParams().put("org", o);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)"outportcsv", (CharSequence)fieldKey) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            List pkIds = Arrays.stream(billlist.getSelectedRows().getPrimaryKeyValues()).distinct().collect(Collectors.toList());
            List orgIds = QhjtCommonBusiness.queryOrgCountByAccountSetIds(new QFilter("id", "in", pkIds));
            Map<String, String> orgMap = QhjtCommonBusiness.queryAccountingOrgByIds(orgIds);
            QueryBuilder queryBuilder = PluginUtil.getListQueryBuilder(this, billlist);
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            QFilter filter = null;
            if (selectedRows != null && selectedRows.size() > 0) {
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                filter = new QFilter("id", "in", (Object)primaryKeyValues);
            } else {
                if (billlist.getCurrentListAllRowCollection().size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"AccountSetListPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    return;
                }
                if (StringUtil.isEmpty((CharSequence)this.getPageCache().get("filterList"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"AccountSetListPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    return;
                }
                List setFilter = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("filterList"));
                orgIds = billlist.getSelectedMainOrgIds();
                orgMap = QhjtCommonBusiness.queryAccountingOrgByIds(orgIds);
                for (QFilter qf : setFilter) {
                    if (filter != null) {
                        filter.and(qf);
                        continue;
                    }
                    filter = qf;
                }
            }
            if (filter != null) {
                ExportUtil.downloadKjGroupCsvFile("tcvvt_clique_accountset", filter, this.getView(), queryBuilder.getOrderBys(), orgMap, orgIds);
            }
        }
    }
}

